/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class IntrospectedInfo
implements Serializable {
    private static IntrospectedInfo defaults = null;
    private static boolean defaultsInited = false;
    private static boolean defaultsEverInited = false;
    private static final long serialVersionUID = -2290064038236292995L;
    private Map clazzes = Collections.synchronizedMap(new HashMap());
    private Map namedefs = new HashMap();
    private transient Set listeners = new HashSet(5);
    private transient Set tonotify = new HashSet(5);
    private transient ChangeListener antBridgeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
            IntrospectedInfo.this.clearDefs();
            IntrospectedInfo.this.fireStateChanged();
        }
    };
    private transient ChangeListener holder;
    private static IntrospectedInfo merged;

    public static synchronized IntrospectedInfo getDefaults() {
        if (defaults == null) {
            defaults = new IntrospectedInfo();
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class clazz = IntrospectedInfo.class;
        synchronized (clazz) {
            if (!defaultsInited && this == defaults) {
                AntModule.err.log("IntrospectedInfo.getDefaults: loading...");
                defaultsInited = true;
                this.loadDefaults(!defaultsEverInited);
                defaultsEverInited = true;
            }
        }
    }

    private void clearDefs() {
        this.clazzes.clear();
        this.namedefs.clear();
        defaultsInited = false;
    }

    private void loadDefaults(boolean bl) {
        ClassLoader classLoader = AntBridge.getMainClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("org/apache/tools/ant/taskdefs/defaults.properties");
        if (inputStream != null) {
            try {
                defaults.load(inputStream, "task", classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default taskdefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default taskdefs");
        }
        InputStream inputStream2 = classLoader.getResourceAsStream("org/apache/tools/ant/types/defaults.properties");
        if (inputStream2 != null) {
            try {
                defaults.load(inputStream2, "type", classLoader);
            }
            catch (IOException iOException) {
                AntModule.err.log("Could not load default typedefs");
                AntModule.err.notify((Throwable)iOException);
            }
        } else {
            AntModule.err.log("Could not open default typedefs");
        }
        defaults.loadNetBeansSpecificDefinitions();
        if (bl) {
            AntBridge.addChangeListener(WeakListeners.change((ChangeListener)this.antBridgeListener, (Object)AntBridge.class));
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.defaults=" + defaults);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.listeners = new HashSet(5);
        this.tonotify = new HashSet(5);
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.clazzes = (Map)getField.get("clazzes", null);
        this.namedefs = (Map)getField.get("namedefs", null);
        if (this.namedefs == null) {
            AntModule.err.log("#15739: reading old version of IntrospectedInfo");
            this.namedefs = new HashMap();
            object5 = getField.get("tasks", null);
            if (object5 == null) {
                throw new NullPointerException();
            }
            if (!(object5 instanceof Map)) {
                throw new ClassCastException(object5.toString());
            }
            this.namedefs.put("task", object5);
            object4 = (Map)getField.get("types", null);
            if (object4 == null) {
                throw new NullPointerException();
            }
            this.namedefs.put("type", object4);
        }
        object5 = this.namedefs.entrySet().iterator();
        while (object5.hasNext()) {
            object4 = object5.next();
            object3 = (String)object4.getKey();
            object2 = (Map)object4.getValue();
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
            }
        }
        object4 = this.clazzes.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = (Map.Entry)object4.next();
            object2 = (String)object3.getKey();
            object = (IntrospectedClass)object3.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.fireStateChanged");
        }
        Set set = this.listeners;
        synchronized (set) {
            if (this.listeners.isEmpty()) {
                return;
            }
            if (this.tonotify.isEmpty()) {
                RequestProcessor.getDefault().post((Runnable)new ChangeTask());
            }
            this.tonotify.addAll(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefs(String string) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            Map map2 = (Map)this.namedefs.get(string);
            if (map2 != null) {
                return Collections.unmodifiableMap(map2);
            }
            return Collections.EMPTY_MAP;
        }
    }

    private IntrospectedClass getData(String string) throws IllegalArgumentException {
        IntrospectedClass introspectedClass = (IntrospectedClass)this.clazzes.get(string);
        if (introspectedClass == null) {
            throw new IllegalArgumentException("Unknown class: " + string);
        }
        return introspectedClass;
    }

    public boolean isKnown(String string) {
        this.init();
        return this.clazzes.get(string) != null;
    }

    public boolean supportsText(String string) throws IllegalArgumentException {
        this.init();
        return this.getData((String)string).supportsText;
    }

    public Map getAttributes(String string) throws IllegalArgumentException {
        this.init();
        Map map = this.getData((String)string).attrs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getElements(String string) throws IllegalArgumentException {
        this.init();
        Map map = this.getData((String)string).subs;
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getTags(String string) throws IllegalArgumentException {
        this.init();
        return this.getData((String)string).enumTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream inputStream, String string, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (string.equals("type") && string2.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            String string3 = (String)entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClass(string3);
                this.register(string2, clazz, string, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                AntModule.err.log("IntrospectedInfo: skipping " + string3 + ": " + classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                AntModule.err.log("IntrospectedInfo: skipping " + string3 + ": " + noClassDefFoundError);
            }
            catch (LinkageError linkageError) {
                IOException iOException = new IOException("Could not load class " + string3 + ": " + linkageError);
                AntModule.err.annotate((Throwable)iOException, (Throwable)linkageError);
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                IOException iOException = new IOException("Could not load class " + string3 + ": " + runtimeException);
                AntModule.err.annotate((Throwable)iOException, (Throwable)runtimeException);
                throw iOException;
            }
        }
    }

    private void loadNetBeansSpecificDefinitions() {
        this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsNoNamespace());
        if (AntBridge.getInterface().isAnt16()) {
            this.loadNetBeansSpecificDefinitions0(AntBridge.getCustomDefsWithNamespace());
        }
    }

    private void loadNetBeansSpecificDefinitions0(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                Class clazz = (Class)entry2.getValue();
                this.register(string2, clazz, string);
            }
        }
    }

    public synchronized void register(String string, Class clazz, String string2) {
        this.register(string, clazz, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(String string, Class clazz, String string2, boolean bl) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            HashMap<String, String> hashMap = (HashMap<String, String>)this.namedefs.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                this.namedefs.put(string2, hashMap);
            }
            hashMap.put(string, clazz.getName());
        }
        boolean bl2 = this.analyze(clazz, null, false);
        if (bl2 && bl) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String string, String string2) {
        this.init();
        Map map = this.namedefs;
        synchronized (map) {
            Map map2 = (Map)this.namedefs.get(string2);
            if (map2 != null) {
                map2.remove(string);
            }
        }
        this.fireStateChanged();
    }

    private boolean analyze(Class clazz, Set set, boolean bl) {
        Iterator iterator;
        Object object;
        Object object2;
        String string = clazz.getName();
        if (IntrospectedInfo.getDefaults().isKnown(string)) {
            return false;
        }
        if ((set == null || !set.add(clazz)) && this.isKnown(string)) {
            return false;
        }
        IntrospectedClass introspectedClass = new IntrospectedClass();
        if (bl) {
            String[] stringArray = AntBridge.getInterface().getEnumeratedValues(clazz);
            if (stringArray != null) {
                introspectedClass.enumTags = stringArray;
                return !introspectedClass.equals(this.clazzes.put(clazz.getName(), introspectedClass));
            }
            return this.clazzes.remove(clazz.getName()) != null;
        }
        IntrospectionHelperProxy introspectionHelperProxy = AntBridge.getInterface().getIntrospectionHelper(clazz);
        introspectedClass.supportsText = introspectionHelperProxy.supportsCharacters();
        Enumeration enumeration = introspectionHelperProxy.getAttributes();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (enumeration.hasMoreElements()) {
            introspectedClass.attrs = new HashMap();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                try {
                    object = introspectionHelperProxy.getAttributeType((String)object2);
                    iterator = ((Class)object).getName();
                    if (IntrospectedInfo.hasSuperclass(clazz, "org.apache.tools.ant.Task") && (((String)object2).equals("location") && ((String)((Object)iterator)).equals("org.apache.tools.ant.Location") || ((String)object2).equals("taskname") && ((String)((Object)iterator)).equals("java.lang.String") || ((String)object2).equals("description") && ((String)((Object)iterator)).equals("java.lang.String"))) continue;
                    introspectedClass.attrs.put(object2, iterator);
                    hashSet.add(object);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.attrs = null;
        }
        object2 = new HashSet();
        enumeration = introspectionHelperProxy.getNestedElements();
        if (enumeration.hasMoreElements()) {
            introspectedClass.subs = new HashMap();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    iterator = introspectionHelperProxy.getElementType((String)object);
                    introspectedClass.subs.put(object, ((Class)((Object)iterator)).getName());
                    object2.add(iterator);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify(1, (Throwable)runtimeException);
                }
            }
        } else {
            introspectedClass.subs = null;
        }
        boolean bl2 = !introspectedClass.equals(this.clazzes.put(clazz.getName(), introspectedClass));
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.analyze((Class)iterator.next(), set, false);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            bl2 |= this.analyze((Class)iterator.next(), set, true);
        }
        return bl2;
    }

    private static boolean hasSuperclass(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public void scanProject(Map map) {
        this.init();
        Iterator iterator = map.entrySet().iterator();
        HashSet hashSet = new HashSet();
        boolean bl = false;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            bl |= this.scanMap((Map)entry.getValue(), (String)entry.getKey(), hashSet);
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("IntrospectedInfo.scanProject: " + this);
        }
        if (bl) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanMap(Map map, String string, Set set) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (string.equals("type") && string2.equals("description")) {
                AntModule.err.log("Skipping pseudodef of <description>");
                continue;
            }
            Class clazz = (Class)entry.getValue();
            HashMap<String, String> hashMap = (HashMap<String, String>)this.namedefs.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                this.namedefs.put(string, hashMap);
            }
            IntrospectedInfo introspectedInfo = this;
            synchronized (introspectedInfo) {
                Map map2 = IntrospectedInfo.getDefaults().getDefs(string);
                if (map2.get(string2) == null) {
                    bl |= !clazz.getName().equals(hashMap.put(string2, clazz.getName()));
                }
                if (!IntrospectedInfo.getDefaults().isKnown(clazz.getName())) {
                    try {
                        bl |= this.analyze(clazz, set, false);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        AntModule.err.log("Skipping " + clazz.getName() + ": " + noClassDefFoundError);
                    }
                    catch (LinkageError linkageError) {
                        AntModule.err.annotate((Throwable)linkageError, 1, "Cannot scan class " + clazz.getName(), null, null, null);
                        AntModule.err.notify(1, (Throwable)linkageError);
                    }
                }
            }
        }
        return bl;
    }

    public String toString() {
        return "IntrospectedInfo[namedefs=" + this.namedefs + ",clazzes=" + this.clazzes + "]";
    }

    private static IntrospectedInfo merge(IntrospectedInfo[] introspectedInfoArray) {
        ChangeListener changeListener;
        final IntrospectedInfo introspectedInfo = new IntrospectedInfo();
        introspectedInfo.holder = changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IntrospectedInfo introspectedInfo2 = (IntrospectedInfo)changeEvent.getSource();
                introspectedInfo2.init();
                introspectedInfo.clazzes.putAll(introspectedInfo2.clazzes);
                Iterator iterator = introspectedInfo2.namedefs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    if (introspectedInfo.namedefs.containsKey(string)) {
                        ((Map)introspectedInfo.namedefs.get(string)).putAll(map);
                        continue;
                    }
                    introspectedInfo.namedefs.put(string, new HashMap(map));
                }
                introspectedInfo.fireStateChanged();
            }
        };
        for (int i = 0; i < introspectedInfoArray.length; ++i) {
            introspectedInfoArray[i].addChangeListener(WeakListeners.change((ChangeListener)changeListener, (Object)introspectedInfoArray[i]));
            changeListener.stateChanged(new ChangeEvent(introspectedInfoArray[i]));
        }
        return introspectedInfo;
    }

    public static synchronized IntrospectedInfo getKnownInfo() {
        if (merged == null) {
            merged = IntrospectedInfo.merge(new IntrospectedInfo[]{IntrospectedInfo.getDefaults(), AntSettings.getDefault().getCustomDefs()});
        }
        return merged;
    }

    private static final class IntrospectedClass
    implements Serializable {
        private static final long serialVersionUID = 4039297397834774403L;
        public boolean supportsText;
        public Map attrs;
        public Map subs;
        public String[] enumTags;

        private IntrospectedClass() {
        }

        public String toString() {
            String string = this.enumTags != null ? Arrays.asList((Object[])this.enumTags).toString() : "null";
            return "IntrospectedClass[text=" + this.supportsText + ",attrs=" + this.attrs + ",subs=" + this.subs + ",enumTags=" + string + "]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntrospectedClass)) {
                return false;
            }
            IntrospectedClass introspectedClass = (IntrospectedClass)object;
            return this.supportsText == introspectedClass.supportsText && Utilities.compareObjects((Object)this.attrs, (Object)introspectedClass.attrs) && Utilities.compareObjects((Object)this.subs, (Object)introspectedClass.subs) && Utilities.compareObjects((Object)this.enumTags, (Object)introspectedClass.enumTags);
        }
    }

    private class ChangeTask
    implements Runnable {
        private ChangeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ChangeListener[] changeListenerArray;
            Object object = IntrospectedInfo.this.listeners;
            synchronized (object) {
                if (IntrospectedInfo.this.tonotify.isEmpty()) {
                    return;
                }
                changeListenerArray = IntrospectedInfo.this.tonotify.toArray(new ChangeListener[IntrospectedInfo.this.tonotify.size()]);
                IntrospectedInfo.this.tonotify.clear();
            }
            object = new ChangeEvent(IntrospectedInfo.this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }
    }
}

