/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static ExecutorTask runTarget(FileObject fileObject, String[] stringArray, Properties properties) throws IOException, IllegalArgumentException {
        if (fileObject == null) {
            throw new NullPointerException("Must pass non-null build script");
        }
        if (stringArray != null && stringArray.length == 0) {
            throw new IllegalArgumentException("No targets supplied");
        }
        AntProjectCookie antProjectCookie = TargetLister.getAntProjectCookie(fileObject);
        AntTargetExecutor.Env env = new AntTargetExecutor.Env();
        if (properties != null) {
            Properties properties2 = env.getProperties();
            properties2.putAll((Map<?, ?>)properties);
            env.setProperties(properties2);
        }
        return AntTargetExecutor.createTargetExecutor(env).execute(antProjectCookie, stringArray);
    }

    public static FileObject[] findSelectedFiles(Lookup lookup, FileObject fileObject, String string, boolean bl) {
        if (fileObject != null && !fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        if (string != null && string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Cannot includes slashes in suffix: " + string);
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        Iterator iterator = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            DataObject dataObject = (DataObject)iterator.next();
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = bl2 = FileUtil.toFile((FileObject)fileObject2) != null;
            if (fileObject != null) {
                bl2 &= FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject == fileObject2;
            }
            if (string != null) {
                bl2 &= fileObject2.getNameExt().endsWith(string);
            }
            if (bl2) {
                linkedHashSet.add(fileObject2);
                continue;
            }
            if (!bl) continue;
            return null;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    public static FileObject[] regexpMapFiles(FileObject[] fileObjectArray, FileObject fileObject, Pattern pattern, FileObject fileObject2, String string, boolean bl) throws IllegalArgumentException {
        ArrayList<Matcher> arrayList = new ArrayList<Matcher>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string2;
            Matcher matcher;
            String string3 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObjectArray[i]);
            if (string3 == null) {
                throw new IllegalArgumentException("The file " + fileObjectArray[i] + " is not in " + fileObject);
            }
            if (pattern != null) {
                matcher = pattern.matcher(string3);
                string2 = matcher.replaceFirst(string);
                if (string2.equals(string3) && !matcher.find(0)) {
                    if (!bl) continue;
                    return null;
                }
            } else {
                string2 = string3;
            }
            if ((matcher = fileObject2.getFileObject(string2)) == null) {
                if (!bl) continue;
                return null;
            }
            arrayList.add(matcher);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public static String antIncludesList(FileObject[] fileObjectArray, FileObject fileObject) throws IllegalArgumentException {
        return ActionUtils.antIncludesList(fileObjectArray, fileObject, true);
    }

    public static String antIncludesList(FileObject[] fileObjectArray, FileObject fileObject, boolean bl) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObjectArray[i]);
            if (string == null) {
                throw new IllegalArgumentException("The file " + fileObjectArray[i] + " is not in " + fileObject);
            }
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            if (!fileObjectArray[i].isFolder()) continue;
            if (string.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append('*');
            if (!bl) continue;
            stringBuffer.append('*');
        }
        return stringBuffer.toString();
    }
}

