/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetLister {
    private static final Map antProjectCookies;
    static final /* synthetic */ boolean $assertionsDisabled;

    private TargetLister() {
    }

    public static Set getTargets(AntProjectCookie antProjectCookie) throws IOException {
        HashSet hashSet = new HashSet();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(System.getProperties());
        Script script = new Script(null, antProjectCookie, hashSet, hashMap, Collections.EMPTY_MAP);
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        TargetLister.traverseScripts(script, hashSet2, hashSet3);
        return hashSet2;
    }

    private static void traverseScripts(Script script, Set set, Set set2) throws IOException {
        if (!set2.add(script.getScript())) {
            return;
        }
        set.addAll(script.getTargets());
        Iterator iterator = script.getImports().iterator();
        while (iterator.hasNext()) {
            Script script2 = (Script)iterator.next();
            TargetLister.traverseScripts(script2, set, set2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AntProjectCookie getAntProjectCookie(FileObject fileObject) {
        AntProjectCookie antProjectCookie;
        Object object;
        block7: {
            try {
                object = DataObject.find((FileObject)fileObject);
                antProjectCookie = (AntProjectCookie)object.getCookie(AntProjectCookie.class);
                if (antProjectCookie != null) {
                    return antProjectCookie;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
        }
        object = antProjectCookies;
        synchronized (object) {
            antProjectCookie = (AntProjectCookie)antProjectCookies.get(fileObject);
            if (antProjectCookie == null) {
                antProjectCookie = new AntProjectSupport(fileObject);
                antProjectCookies.put(fileObject, antProjectCookie);
            }
            return antProjectCookie;
        }
    }

    static {
        $assertionsDisabled = !TargetLister.class.desiredAssertionStatus();
        antProjectCookies = new WeakHashMap();
    }

    private static final class Script {
        private final AntProjectCookie apc;
        private final Script importingScript;
        private final Map targets;
        private final String defaultTarget;
        private final List imports;
        private final String name;
        private final Set alreadyImported;
        private static final Set TRUE_VALS;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Script(Script script, AntProjectCookie antProjectCookie, Set set, Map map, Map map2) throws IOException {
            String string;
            this.importingScript = script;
            this.apc = antProjectCookie;
            this.alreadyImported = set;
            Element element = antProjectCookie.getProjectElement();
            if (element == null) {
                throw new IOException("Could not parse " + antProjectCookie);
            }
            File file = antProjectCookie.getFile();
            if (file != null) {
                set.add(file);
            }
            this.defaultTarget = (string = element.getAttribute("default")).length() > 0 ? string : null;
            String string2 = element.getAttribute("name");
            this.name = string2.length() > 0 ? string2 : null;
            String string3 = element.getAttribute("basedir");
            File file2 = new File(string3 = string3.length() == 0 ? "." : string3.replace('/', File.separatorChar).replace('\\', File.separatorChar));
            File file3 = file2.isAbsolute() ? file2 : (file != null ? new File(file.getParentFile(), string3) : null);
            this.targets = new HashMap();
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            if (file3 != null && !hashMap.containsKey("basedir")) {
                hashMap.put("basedir", file3.getAbsolutePath());
            }
            HashMap hashMap2 = new HashMap(map2);
            this.imports = new ArrayList();
            this.interpretTasks(set, element, file3, hashMap, hashMap2, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interpretTasks(Set set, Element element, File file, Map map, Map map2, Map map3) throws IOException {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Element element2;
                String string;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element3 = (Element)node;
                String string2 = string = element3.getLocalName();
                String string3 = element3.getNamespaceURI();
                if (string3 != null) {
                    string2 = string3 + '#' + string2;
                }
                if ((element2 = (Element)map2.get(string2)) != null) {
                    object6 = new HashMap();
                    object5 = element2.getChildNodes();
                    for (int j = 0; j < object5.getLength(); ++j) {
                        if (object5.item(j).getNodeType() != 1) continue;
                        object4 = (Element)object5.item(j);
                        object3 = object4.getLocalName();
                        if (((String)object3).equals("attribute")) {
                            String string4 = object4.getAttribute("name");
                            if (string4.length() == 0 || (object2 = Script.replaceAntProperties((String)(object = element3.getAttribute(string4)), map)) == null) continue;
                            object6.put(string4, object2);
                            continue;
                        }
                        if (!((String)object3).equals("sequential")) continue;
                        this.interpretTasks(set, (Element)object4, file, map, map2, (Map)object6);
                    }
                    continue;
                }
                if (map3 == null && string.equals("target")) {
                    object6 = element3.getAttribute("name");
                    this.targets.put(object6, new Target(this, element3, (String)object6));
                    continue;
                }
                if (map3 == null && string.equals("import")) {
                    object6 = element3.getAttribute("file").replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    object5 = Script.replaceAntProperties((String)object6, map);
                    if (((String)object5).indexOf("${") != -1) continue;
                    File file2 = new File((String)object5);
                    if (file2.isAbsolute()) {
                        object4 = file2;
                    } else {
                        if (this.apc.getFile() == null) {
                            throw new IOException("Cannot import relative path " + (String)object6 + " from a diskless script");
                        }
                        object4 = new File(this.apc.getFile().getParentFile(), (String)object5);
                    }
                    if (set.contains(object4)) continue;
                    if (((File)object4).canRead()) {
                        object3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)object4));
                        if (!$assertionsDisabled && object3 == null) {
                            throw new AssertionError(object4);
                        }
                        AntProjectCookie antProjectCookie = TargetLister.getAntProjectCookie((FileObject)object3);
                        this.imports.add(new Script(this, antProjectCookie, set, map, map2));
                        continue;
                    }
                    object3 = element3.getAttribute("optional");
                    boolean bl = TRUE_VALS.contains(((String)object3).toLowerCase(Locale.US));
                    if (bl) continue;
                    throw new IOException("Cannot find import " + object4 + " from " + this.apc);
                }
                if (string.equals("property")) {
                    if (element3.hasAttribute("value")) {
                        object6 = Script.replaceMacroParams(element3.getAttribute("name"), map3);
                        if (((String)object6).length() == 0 || map.containsKey(object6)) continue;
                        object5 = Script.replaceMacroParams(element3.getAttribute("value"), map3);
                        String string5 = Script.replaceAntProperties((String)object5, map);
                        map.put(object6, string5);
                        continue;
                    }
                    object6 = Script.replaceMacroParams(element3.getAttribute("file"), map3);
                    if (((String)object6).length() <= 0) continue;
                    object5 = Script.replaceAntProperties((String)object6, map);
                    File file3 = new File((String)object5);
                    if (!file3.isAbsolute() && file != null) {
                        file3 = new File(file, ((String)object5).replace('/', File.separatorChar).replace('\\', File.separatorChar));
                    }
                    if (!file3.canRead()) continue;
                    object4 = new Properties();
                    object3 = new FileInputStream(file3);
                    try {
                        ((Properties)object4).load((InputStream)object3);
                    }
                    finally {
                        ((InputStream)object3).close();
                    }
                    Map map4 = Script.evaluateAll(map, Collections.singletonList(object4));
                    if (map4 == null) continue;
                    object = map4.entrySet().iterator();
                    while (object.hasNext()) {
                        object2 = (Map.Entry)object.next();
                        String string6 = (String)object2.getKey();
                        if (map.containsKey(string6)) continue;
                        map.put(string6, (String)object2.getValue());
                    }
                    continue;
                }
                if (!string.equals("macrodef") || ((String)(object6 = element3.getAttribute("name"))).length() == 0) continue;
                string3 = element3.getAttribute("uri");
                if (string3.length() > 0) {
                    object6 = string3 + '#' + (String)object6;
                }
                if (map2.containsKey(object6)) continue;
                map2.put(object6, element3);
            }
        }

        private static String replaceMacroParams(String string, Map map) {
            if (string.indexOf(64) == -1) {
                return string;
            }
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n2;
                if ((n2 = string.indexOf(64, n)) == -1 || n2 == string.length() - 1) {
                    stringBuffer.append(string.substring(n));
                    return stringBuffer.toString();
                }
                char c = string.charAt(n2 + 1);
                if (c == '{') {
                    int n3 = string.indexOf(125, n2 + 2);
                    if (n3 != -1) {
                        String string2 = string.substring(n2 + 2, n3);
                        if (map.containsKey(string2)) {
                            stringBuffer.append(string.substring(n, n2));
                            stringBuffer.append((String)map.get(string2));
                        } else {
                            stringBuffer.append(string.substring(n, n3 + 1));
                        }
                        n = n3 + 1;
                        continue;
                    }
                    stringBuffer.append(string.substring(n));
                    return stringBuffer.toString();
                }
                stringBuffer.append(string.substring(n, n + 2));
                n += 2;
            }
        }

        private static String replaceAntProperties(String string, Map map) {
            return (String)Script.subst(string, map, Collections.EMPTY_SET);
        }

        private static Map evaluateAll(Map map, List list) {
            HashMap<Object, String> hashMap = new HashMap<Object, String>(map);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                String string;
                Object object2;
                Map.Entry entry;
                Map map2 = (Map)iterator.next();
                HashMap<Object, Set> hashMap2 = new HashMap<Object, Set>();
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    object2 = (String)entry.getKey();
                    if (hashMap.containsKey(object2)) continue;
                    string = (String)entry.getValue();
                    object = Script.subst(string, hashMap, map2.keySet());
                    if (object instanceof String) {
                        hashMap.put(object2, (String)object);
                        continue;
                    }
                    hashMap2.put(object2, (Set)object);
                }
                entry = new HashSet(hashMap2.keySet());
                iterator2 = hashMap2.values().iterator();
                while (iterator2.hasNext()) {
                    entry.addAll((Set)((Object)iterator2.next()));
                }
                try {
                    object2 = Utilities.topologicalSort((Collection)((Object)entry), hashMap2);
                }
                catch (TopologicalSortException topologicalSortException) {
                    return null;
                }
                Collections.reverse(object2);
                iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    string = (String)((Object)iterator2.next());
                    if (hashMap.containsKey(string)) continue;
                    object = (String)map2.get(string);
                    hashMap.put(string, (String)Script.subst((String)object, hashMap, map2.keySet()));
                }
            }
            return hashMap;
        }

        private static Object subst(String string, Map map, Set set) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError((Object)"null rawval passed in");
            }
            if (string.indexOf(36) == -1) {
                return string;
            }
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            HashSet<String> hashSet = new HashSet<String>();
            while (true) {
                int n2;
                if ((n2 = string.indexOf(36, n)) == -1 || n2 == string.length() - 1) {
                    if (hashSet.isEmpty()) {
                        stringBuffer.append(string.substring(n));
                        return stringBuffer.toString();
                    }
                    return hashSet;
                }
                char c = string.charAt(n2 + 1);
                if (c == '$') {
                    if (hashSet.isEmpty()) {
                        stringBuffer.append('$');
                    }
                    n += 2;
                    continue;
                }
                if (c == '{') {
                    int n3 = string.indexOf(125, n2 + 2);
                    if (n3 != -1) {
                        String string2 = string.substring(n2 + 2, n3);
                        if (map.containsKey(string2)) {
                            if (hashSet.isEmpty()) {
                                stringBuffer.append(string.substring(n, n2));
                                stringBuffer.append((String)map.get(string2));
                            }
                            n = n3 + 1;
                            continue;
                        }
                        if (set.contains(string2)) {
                            hashSet.add(string2);
                            n = n3 + 1;
                            continue;
                        }
                        if (hashSet.isEmpty()) {
                            stringBuffer.append(string.substring(n, n3 + 1));
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (hashSet.isEmpty()) {
                        stringBuffer.append(string.substring(n));
                        return stringBuffer.toString();
                    }
                    return hashSet;
                }
                if (hashSet.isEmpty()) {
                    stringBuffer.append(string.substring(n, n + 2));
                }
                n += 2;
            }
        }

        public AntProjectCookie getScript() {
            return this.apc;
        }

        public String getName() {
            return this.name;
        }

        public Collection getTargets() {
            return this.targets.values();
        }

        public String getDefaultTargetName() {
            return this.defaultTarget;
        }

        public Collection getImports() {
            return this.imports;
        }

        public Script getImportingScript() {
            return this.importingScript;
        }

        public Script getMainScript() {
            if (this.importingScript != null) {
                return this.importingScript.getMainScript();
            }
            return this;
        }

        public boolean defines(String string) {
            if (!this.targets.containsKey(string)) {
                return false;
            }
            Script script = this.importingScript;
            while (script != null) {
                if (script.targets.containsKey(string)) {
                    return false;
                }
                script = script.importingScript;
            }
            return true;
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$api$support$TargetLister == null ? (class$org$apache$tools$ant$module$api$support$TargetLister = TargetLister.class$("org.apache.tools.ant.module.api.support.TargetLister")) : class$org$apache$tools$ant$module$api$support$TargetLister).desiredAssertionStatus();
            TRUE_VALS = new HashSet(5);
            TRUE_VALS.add("true");
            TRUE_VALS.add("yes");
            TRUE_VALS.add("on");
        }
    }

    public static final class Target {
        private final Script script;
        private final Element el;
        private final String name;

        Target(Script script, Element element, String string) {
            this.script = script;
            this.el = element;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            String string = this.script.getName();
            if (string != null) {
                return string + '.' + this.getName();
            }
            return this.getName();
        }

        public Element getElement() {
            return this.el;
        }

        public AntProjectCookie getScript() {
            return this.script.getScript();
        }

        public boolean isDescribed() {
            return this.el.getAttribute("description").length() > 0;
        }

        public boolean isInternal() {
            String string = this.getName();
            return string.length() > 0 && string.charAt(0) == '-';
        }

        public boolean isOverridden() {
            return !this.script.defines(this.getName());
        }

        public boolean isDefault() {
            return !this.isOverridden() && this.getName().equals(this.script.getMainScript().getDefaultTargetName());
        }

        public String toString() {
            return "Target " + this.getName() + " in " + this.getScript();
        }
    }
}

