/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AuxClassLoader;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.DummyBridgeImpl;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.io.NullOutputStream;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBridge {
    private static final ErrorManager err;
    private static final String KEY_MAIN_CLASS_PATH = "mainClassPath";
    private static final String KEY_MAIN_CLASS_LOADER = "mainClassLoader";
    private static final String KEY_BRIDGE_CLASS_LOADER = "bridgeClassLoader";
    private static final String KEY_BRIDGE = "bridge";
    private static final String KEY_CUSTOM_DEFS = "customDefs";
    private static final String KEY_CUSTOM_DEF_CLASS_LOADERS = "customDefClassLoaders";
    private static Reference stuff;
    private static List listeners;
    private static MiscListener miscListener;
    private static Lookup.Result modulesResult;
    private static String originalJavaClassPath;
    private static int delegating;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map delegateIns;
    private static Map delegateOuts;
    private static Map delegateErrs;
    private static List suspendedDelegationTasks;
    private static int fakingJavaClassPath;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AntBridge() {
    }

    public static synchronized void addChangeListener(ChangeListener changeListener) {
        listeners.add(changeListener);
    }

    public static synchronized void removeChangeListener(ChangeListener changeListener) {
        listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeListener[] changeListenerArray;
        stuff = null;
        ChangeEvent changeEvent = new ChangeEvent(AntBridge.class);
        Class clazz = AntBridge.class;
        synchronized (clazz) {
            changeListenerArray = listeners.toArray(new ChangeListener[listeners.size()]);
        }
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(changeEvent);
        }
    }

    public static ClassLoader getMainClassLoader() {
        return (ClassLoader)AntBridge.getStuff().get(KEY_MAIN_CLASS_LOADER);
    }

    private static ClassLoader getBridgeClassLoader() {
        return (ClassLoader)AntBridge.getStuff().get(KEY_BRIDGE_CLASS_LOADER);
    }

    public static Map getCustomDefsWithNamespace() {
        return (Map)AntBridge.getStuff().get(KEY_CUSTOM_DEFS);
    }

    public static Map getCustomDefsNoNamespace() {
        HashMap hashMap = new HashMap();
        Iterator iterator = AntBridge.getCustomDefsWithNamespace().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            HashMap<String, Class> hashMap2 = new HashMap<String, Class>();
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                Class clazz = (Class)entry2.getValue();
                int n = string2.lastIndexOf(58);
                String string3 = n != -1 ? string2.substring(n + 1) : string2;
                hashMap2.put(string3, clazz);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public static Map getCustomDefClassLoaders() throws IOException {
        return (Map)AntBridge.getStuff().get(KEY_CUSTOM_DEF_CLASS_LOADERS);
    }

    public static BridgeInterface getInterface() {
        return (BridgeInterface)AntBridge.getStuff().get(KEY_BRIDGE);
    }

    private static synchronized Map getStuff() {
        Map map = stuff != null ? (Map)stuff.get() : null;
        if (map == null) {
            map = AntBridge.createStuff();
            stuff = new SoftReference<Map>(map);
        }
        return map;
    }

    private static Map createStuff() {
        err.log("AntBridge.createStuff - loading Ant installation...");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Class<?> clazz;
            Class<?> clazz2;
            List list = AntBridge.createMainClassPath();
            err.log("mainClassPath=" + list);
            hashMap.put(KEY_MAIN_CLASS_PATH, AntBridge.classPathToString(list));
            ClassLoader classLoader = AntBridge.createMainClassLoader(list);
            hashMap.put(KEY_MAIN_CLASS_LOADER, classLoader);
            ClassLoader classLoader2 = AntBridge.createBridgeClassLoader(classLoader);
            hashMap.put(KEY_BRIDGE_CLASS_LOADER, classLoader2);
            Class<?> clazz3 = Class.forName("org.apache.tools.ant.input.InputHandler", false, classLoader2);
            ClassLoader classLoader3 = clazz3.getClassLoader();
            if (classLoader3 != classLoader) {
                throw new IllegalStateException("Wrong class loader is finding Ant: " + classLoader3);
            }
            Class<?> clazz4 = Class.forName("org.apache.tools.ant.input.InputHandler", false, classLoader);
            if (clazz4 != clazz3) {
                throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + clazz4.getClassLoader());
            }
            try {
                clazz2 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, classLoader2);
                if (clazz2.getClassLoader() != classLoader) {
                    throw new IllegalStateException("Bridge loader is loading stuff from elsewhere: " + clazz2.getClassLoader());
                }
                clazz = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, classLoader);
                if (clazz != clazz2) {
                    throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + clazz.getClassLoader());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            clazz2 = classLoader2.loadClass("org.apache.tools.ant.module.bridge.impl.BridgeImpl");
            if (clazz2.getClassLoader() != classLoader2) {
                throw new IllegalStateException("Wrong class loader is finding bridge impl: " + clazz2.getClassLoader());
            }
            hashMap.put(KEY_BRIDGE, (BridgeInterface)clazz2.newInstance());
            clazz = AntBridge.createCustomDefClassLoaders(classLoader);
            hashMap.put(KEY_CUSTOM_DEF_CLASS_LOADERS, clazz);
            hashMap.put(KEY_CUSTOM_DEFS, AntBridge.createCustomDefs((Map)((Object)clazz)));
        }
        catch (Exception exception) {
            AntBridge.fallback(hashMap, exception);
        }
        catch (LinkageError linkageError) {
            AntBridge.fallback(hashMap, linkageError);
        }
        return hashMap;
    }

    private static void fallback(Map map, Throwable throwable) {
        map.clear();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        map.put(KEY_MAIN_CLASS_LOADER, classLoader);
        map.put(KEY_BRIDGE_CLASS_LOADER, classLoader);
        map.put(KEY_BRIDGE, new DummyBridgeImpl(throwable));
        HashMap hashMap = new HashMap();
        hashMap.put("task", new HashMap());
        hashMap.put("type", new HashMap());
        map.put(KEY_CUSTOM_DEFS, hashMap);
        map.put(KEY_CUSTOM_DEF_CLASS_LOADERS, Collections.EMPTY_MAP);
    }

    private static String classPathToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((File)iterator.next()).getAbsolutePath());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public static String getMainClassPath() {
        return (String)AntBridge.getStuff().get(KEY_MAIN_CLASS_PATH) + File.pathSeparatorChar + originalJavaClassPath;
    }

    private static List createMainClassPath() throws Exception {
        File[] fileArray;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        File file = new File(AntSettings.getDefault().getAntHomeWithDefault(), "lib");
        if (!file.isDirectory()) {
            throw new IOException("No such Ant library dir: " + file);
        }
        err.log("Creating main class loader from " + file);
        File[] fileArray2 = new File(file.getParentFile(), "patches").listFiles(new JarFilter());
        if (fileArray2 != null) {
            for (int i = 0; i < fileArray2.length; ++i) {
                linkedHashSet.add(fileArray2[i]);
            }
        }
        if ((fileArray = file.listFiles(new JarFilter())) == null) {
            throw new IOException("Listing: " + file);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            linkedHashSet.add(fileArray[i]);
        }
        NbClassPath nbClassPath = AntSettings.getDefault().getExtraClasspath();
        String string = nbClassPath.getClassPath();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(new File(stringTokenizer.nextToken()));
        }
        nbClassPath = AntSettings.getDefault().getAutomaticExtraClasspath();
        string = nbClassPath.getClassPath();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(new File(stringTokenizer.nextToken()));
        }
        return new ArrayList(linkedHashSet);
    }

    private static ClassLoader createMainClassLoader(List list) throws Exception {
        URL[] uRLArray = new URL[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            uRLArray[n++] = ((File)iterator.next()).toURI().toURL();
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (err.isLoggable(1)) {
            List<URL> list2 = classLoader instanceof URLClassLoader ? Arrays.asList(((URLClassLoader)classLoader).getURLs()) : null;
            err.log("AntBridge.createMainClassLoader: cp=" + Arrays.asList(uRLArray) + " parent.urls=" + list2);
        }
        return new MaskedClassLoader(uRLArray, classLoader);
    }

    private static ClassLoader createBridgeClassLoader(ClassLoader classLoader) throws Exception {
        File file = InstalledFileLocator.getDefault().locate("ant/nblib/bridge.jar", "org.apache.tools.ant.module", false);
        if (file == null) {
            throw new IllegalStateException("no ant/nblib/bridge.jar found");
        }
        return AntBridge.createAuxClassLoader(file, classLoader, AntBridge.class.getClassLoader());
    }

    private static ClassLoader createAuxClassLoader(File file, ClassLoader classLoader, ClassLoader classLoader2) throws IOException {
        return new AuxClassLoader(classLoader2, classLoader, file.toURI().toURL());
    }

    private static Map createCustomDefClassLoaders(ClassLoader classLoader) throws IOException {
        HashMap<String, ClassLoader> hashMap = new HashMap<String, ClassLoader>();
        ModuleInfo[] moduleInfoArray = miscListener.getEnabledModules();
        InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            String string = moduleInfoArray[i].getCodeNameBase();
            String string2 = string.replace('.', '-');
            File file = installedFileLocator.locate("ant/nblib/" + string2 + ".jar", string, false);
            if (file == null) continue;
            ClassLoader classLoader2 = AntBridge.createAuxClassLoader(file, classLoader, moduleInfoArray[i].getClassLoader());
            hashMap.put(string, classLoader2);
        }
        return hashMap;
    }

    private static Map createCustomDefs(Map map) throws IOException {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        hashMap.put("task", hashMap2);
        hashMap.put("type", hashMap3);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Document document;
            String string;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            ClassLoader classLoader = (ClassLoader)entry.getValue();
            URL uRL = classLoader.getResource(string = string2.replace('.', '/') + "/antlib.xml");
            if (uRL == null) {
                throw new IOException("Could not find " + string + " in ant/nblib/" + string2.replace('.', '-') + ".jar");
            }
            try {
                document = XMLUtil.parse((InputSource)new InputSource(uRL.toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException sAXException) {
                throw (IOException)new IOException(sAXException.toString()).initCause(sAXException);
            }
            Element element = document.getDocumentElement();
            if (!element.getLocalName().equals("antlib")) {
                throw new IOException("Bad root element for " + uRL + ": " + element);
            }
            NodeList nodeList = element.getChildNodes();
            Properties properties = new Properties();
            Properties properties2 = new Properties();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                boolean bl;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                if (element2.getNodeName().equals("taskdef")) {
                    bl = false;
                } else if (element2.getNodeName().equals("typedef")) {
                    bl = true;
                } else {
                    err.log(16, "Warning: unrecognized definition " + element2 + " in " + uRL);
                    continue;
                }
                String string3 = element2.getAttribute("name");
                if (string3 == null) {
                    err.log(16, "Warning: skipping definition " + element2 + " with no 'name' in " + uRL);
                    continue;
                }
                String string4 = element2.getAttribute("classname");
                if (string4 == null) {
                    throw new IOException("No 'classname' attr on def of " + string3 + " in " + uRL);
                }
                (bl ? properties2 : properties).setProperty(string3, string4);
            }
            AntBridge.loadDefs(properties, hashMap2, classLoader);
            AntBridge.loadDefs(properties2, hashMap3, classLoader);
        }
        return hashMap;
    }

    private static void loadDefs(Properties properties, Map map, ClassLoader classLoader) throws IOException {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            try {
                Class<?> clazz = classLoader.loadClass(string2);
                map.put(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                IOException iOException = new IOException("Could not load class " + string2 + ": " + classNotFoundException);
                err.annotate((Throwable)iOException, (Throwable)classNotFoundException);
                throw iOException;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                err.log("AntBridge.loadDefs: skipping " + string2 + ": " + noClassDefFoundError);
            }
            catch (LinkageError linkageError) {
                IOException iOException = new IOException("Could not load class " + string2 + ": " + linkageError);
                err.annotate((Throwable)iOException, (Throwable)linkageError);
                throw iOException;
            }
        }
    }

    private static boolean masked(String string) {
        return string.startsWith("org.apache.tools.") || string.startsWith("org.netbeans.");
    }

    public static synchronized void pushSystemInOutErr(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.put(threadGroup, inputStream);
        delegateOuts.put(threadGroup, printStream);
        delegateErrs.put(threadGroup, printStream2);
    }

    public static synchronized void restoreSystemInOutErr() {
        if (!$assertionsDisabled && delegating <= 0) {
            throw new AssertionError();
        }
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        delegateIns.remove(threadGroup);
        delegateOuts.remove(threadGroup);
        delegateErrs.remove(threadGroup);
    }

    public static synchronized void suspendDelegation() {
        Thread thread = Thread.currentThread();
        suspendedDelegationTasks.add(thread);
    }

    public static synchronized void resumeDelegation() {
        Thread thread = Thread.currentThread();
        if (!$assertionsDisabled && !suspendedDelegationTasks.contains(thread)) {
            throw new AssertionError((Object)("Have not suspended delegation in " + thread));
        }
        suspendedDelegationTasks.remove(thread);
    }

    public static synchronized void fakeJavaClassPath() {
        if (fakingJavaClassPath++ == 0) {
            String string = AntBridge.getMainClassPath();
            err.log("Faking java.class.path=" + string);
            System.setProperty("java.class.path", string);
        }
    }

    public static synchronized void unfakeJavaClassPath() {
        if (--fakingJavaClassPath == 0) {
            err.log("Restoring java.class.path=" + originalJavaClassPath);
            System.setProperty("java.class.path", originalJavaClassPath);
        }
    }

    static {
        $assertionsDisabled = !AntBridge.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance(AntBridge.class.getName());
        stuff = null;
        listeners = new ArrayList();
        miscListener = new MiscListener();
        modulesResult = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        AntSettings.getDefault().addPropertyChangeListener(miscListener);
        modulesResult.addLookupListener((LookupListener)miscListener);
        originalJavaClassPath = System.getProperty("java.class.path");
        delegating = 0;
        delegateIns = new HashMap();
        delegateOuts = new HashMap();
        delegateErrs = new HashMap();
        suspendedDelegationTasks = new ArrayList();
        fakingJavaClassPath = 0;
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MultiplexPrintStream(boolean bl) {
            this(new NullOutputStream(), bl);
        }

        private MultiplexPrintStream(NullOutputStream nullOutputStream, boolean bl) {
            super((OutputStream)nullOutputStream);
            nullOutputStream.throwException = true;
            this.err = bl;
        }

        private PrintStream delegate() {
            ThreadGroup threadGroup;
            Map map;
            Thread thread = Thread.currentThread();
            Map map2 = map = this.err ? delegateErrs : delegateOuts;
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !map.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            PrintStream printStream = (PrintStream)map.get(threadGroup);
            if (printStream != null && !suspendedDelegationTasks.contains(thread)) {
                return printStream;
            }
            if (delegating > 0) {
                PrintStream printStream2;
                PrintStream printStream3 = printStream2 = this.err ? origErr : origOut;
                if (!$assertionsDisabled && printStream2 == null) {
                    throw new AssertionError();
                }
                return printStream2;
            }
            return this.err ? System.err : System.out;
        }

        public boolean checkError() {
            return this.delegate().checkError();
        }

        public void close() {
            this.delegate().close();
        }

        public void flush() {
            this.delegate().flush();
        }

        public void print(long l) {
            this.delegate().print(l);
        }

        public void print(char[] cArray) {
            this.delegate().print(cArray);
        }

        public void print(int n) {
            this.delegate().print(n);
        }

        public void print(boolean bl) {
            this.delegate().print(bl);
        }

        public void print(char c) {
            this.delegate().print(c);
        }

        public void print(float f) {
            this.delegate().print(f);
        }

        public void print(double d) {
            this.delegate().print(d);
        }

        public void print(Object object) {
            this.delegate().print(object);
        }

        public void print(String string) {
            this.delegate().print(string);
        }

        public void println(double d) {
            this.delegate().println(d);
        }

        public void println(Object object) {
            this.delegate().println(object);
        }

        public void println(float f) {
            this.delegate().println(f);
        }

        public void println(int n) {
            this.delegate().println(n);
        }

        public void println(char c) {
            this.delegate().println(c);
        }

        public void println(boolean bl) {
            this.delegate().println(bl);
        }

        public void println(String string) {
            this.delegate().println(string);
        }

        public void println(char[] cArray) {
            this.delegate().println(cArray);
        }

        public void println() {
            this.delegate().println();
        }

        public void println(long l) {
            this.delegate().println(l);
        }

        public void write(int n) {
            this.delegate().write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.delegate().write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.delegate().write(byArray, n, n2);
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$bridge$AntBridge == null ? (class$org$apache$tools$ant$module$bridge$AntBridge = AntBridge.class$("org.apache.tools.ant.module.bridge.AntBridge")) : class$org$apache$tools$ant$module$bridge$AntBridge).desiredAssertionStatus();
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InputStream delegate() {
            ThreadGroup threadGroup;
            Thread thread = Thread.currentThread();
            for (threadGroup = thread.getThreadGroup(); threadGroup != null && !delegateIns.containsKey(threadGroup); threadGroup = threadGroup.getParent()) {
            }
            InputStream inputStream = (InputStream)delegateIns.get(threadGroup);
            if (inputStream != null && !suspendedDelegationTasks.contains(thread)) {
                return inputStream;
            }
            if (delegating > 0) {
                if (!$assertionsDisabled && origIn == null) {
                    throw new AssertionError();
                }
                return origIn;
            }
            return System.in;
        }

        public int read() throws IOException {
            return this.delegate().read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.delegate().read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.delegate().read(byArray, n, n2);
        }

        public int available() throws IOException {
            return this.delegate().available();
        }

        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        public void mark(int n) {
            this.delegate().mark(n);
        }

        public void close() throws IOException {
            this.delegate().close();
        }

        public long skip(long l) throws IOException {
            return this.delegate().skip(l);
        }

        public void reset() throws IOException {
            this.delegate().reset();
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$bridge$AntBridge == null ? (class$org$apache$tools$ant$module$bridge$AntBridge = AntBridge.class$("org.apache.tools.ant.module.bridge.AntBridge")) : class$org$apache$tools$ant$module$bridge$AntBridge).desiredAssertionStatus();
        }
    }

    private static final class MaskedClassLoader
    extends AllPermissionURLClassLoader {
        public MaskedClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            if (AntBridge.masked(string)) {
                Class<?> clazz = this.findLoadedClass(string);
                if (clazz == null) {
                    clazz = this.findClass(string);
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }

    static class AllPermissionURLClassLoader
    extends URLClassLoader {
        private static PermissionCollection allPermission;

        private static synchronized PermissionCollection getAllPermissions() {
            if (allPermission == null) {
                allPermission = new Permissions();
                allPermission.add(new AllPermission());
            }
            return allPermission;
        }

        public AllPermissionURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        protected final PermissionCollection getPermissions(CodeSource codeSource) {
            return AllPermissionURLClassLoader.getAllPermissions();
        }

        public String toString() {
            return super.toString() + "[parent=" + this.getParent() + ",urls=" + Arrays.asList((Object[])this.getURLs()) + "]";
        }

        public URL getResource(String string) {
            URL uRL = super.getResource(string);
            if (err.isLoggable(1)) {
                err.log("APURLCL.gR: " + string + " -> " + uRL + " [" + this + "]");
            }
            return uRL;
        }

        public Enumeration findResources(String string) throws IOException {
            try {
                Enumeration<URL> enumeration = super.findResources(string);
                if (err.isLoggable(1)) {
                    ArrayList<URL> arrayList = Collections.list(enumeration);
                    enumeration = Collections.enumeration(arrayList);
                    err.log("APURLCL.fRs: " + string + " -> " + arrayList + " [" + this + "]");
                }
                return enumeration;
            }
            catch (IOException iOException) {
                if (err.isLoggable(1)) {
                    err.notify(1, (Throwable)iOException);
                }
                throw iOException;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase(Locale.US).endsWith(".jar");
        }
    }

    private static final class MiscListener
    implements PropertyChangeListener,
    LookupListener {
        private ModuleInfo[] modules = null;

        MiscListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("antHome".equals(string) || "extraClasspath".equals(string) || "automaticExtraClasspath".equals(string)) {
                err.log("AntBridge got settings change in " + string);
                AntBridge.fireChange();
            } else if ("enabled".equals(string)) {
                err.log("AntBridge got module enablement change on " + propertyChangeEvent.getSource());
                AntBridge.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            err.log("AntModule got ModuleInfo change");
            MiscListener miscListener = this;
            synchronized (miscListener) {
                if (this.modules != null) {
                    for (int i = 0; i < this.modules.length; ++i) {
                        this.modules[i].removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.modules = null;
                }
            }
            AntBridge.fireChange();
        }

        public synchronized ModuleInfo[] getEnabledModules() {
            int n;
            ArrayList<ModuleInfo> arrayList;
            if (this.modules == null) {
                arrayList = modulesResult.allInstances();
                this.modules = arrayList.toArray(new ModuleInfo[arrayList.size()]);
                for (n = 0; n < this.modules.length; ++n) {
                    this.modules[n].addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            arrayList = new ArrayList<ModuleInfo>(this.modules.length);
            for (n = 0; n < this.modules.length; ++n) {
                if (!this.modules[n].isEnabled()) continue;
                arrayList.add(this.modules[n]);
            }
            return arrayList.toArray(new ModuleInfo[arrayList.size()]);
        }
    }
}

