/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.openide.util.Enumerations;

final class AuxClassLoader
extends AntBridge.AllPermissionURLClassLoader {
    private final ClassLoader nbLoader;

    private static boolean masked(String string) {
        return string.startsWith("org.apache.tools.") && !string.startsWith("org.apache.tools.ant.module.");
    }

    public AuxClassLoader(ClassLoader classLoader, ClassLoader classLoader2, URL uRL) {
        super(new URL[]{uRL}, classLoader2);
        this.nbLoader = classLoader;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!AuxClassLoader.masked(string)) {
            try {
                return this.nbLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.findClass(string);
    }

    public URL findResource(String string) {
        URL uRL;
        if (!AuxClassLoader.masked(string) && (uRL = this.nbLoader.getResource(string)) != null) {
            return uRL;
        }
        return super.findResource(string);
    }

    public Enumeration findResources(String string) throws IOException {
        return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(this.nbLoader.getResources(string), (Enumeration)super.findResources(string)));
    }
}

