/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.w3c.dom.Element;

public class AntActionInstance
implements InstanceCookie,
Action,
Presenter.Menu,
Presenter.Toolbar,
ChangeListener {
    private final AntProjectCookie proj;
    private transient PropertyChangeSupport changeSupport;

    public AntActionInstance(AntProjectCookie antProjectCookie) {
        this.proj = antProjectCookie;
        antProjectCookie.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)antProjectCookie));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeSupport = null;
    }

    public Class instanceClass() {
        return AntActionInstance.class;
    }

    public String instanceName() {
        FileObject fileObject = this.proj.getFileObject();
        if (fileObject != null) {
            return fileObject.getName();
        }
        return "";
    }

    public Object instanceCreate() {
        return this;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                TargetExecutor targetExecutor = new TargetExecutor(AntActionInstance.this.proj, null);
                try {
                    targetExecutor.execute();
                }
                catch (IOException iOException) {
                    AntModule.err.notify((Throwable)iOException);
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.proj.getParseException() == null && this.proj.getFile() != null;
    }

    public void setEnabled(boolean bl) {
    }

    public Object getValue(String string) {
        if ("Name".equals(string)) {
            Element element = this.proj.getProjectElement();
            if (element != null) {
                String string2 = element.getAttribute("name");
                return Actions.cutAmpersand((String)string2);
            }
        } else {
            if ("SmallIcon".equals(string)) {
                try {
                    return new ImageIcon(new URL("nbresloc:/org/apache/tools/ant/module/resources/AntIcon.gif"));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new AssertionError((Object)malformedURLException);
                }
            }
            if ("MnemonicKey".equals(string)) {
                String string3;
                int n;
                Element element = this.proj.getProjectElement();
                if (element != null && (n = Mnemonics.findMnemonicAmpersand((String)(string3 = element.getAttribute("name")))) != -1) {
                    return new Integer(string3.charAt(n + 1));
                }
                return new Integer(0);
            }
        }
        return null;
    }

    public void putValue(String string, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        AntActionInstance antActionInstance = this;
        synchronized (antActionInstance) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public JMenuItem getMenuPresenter() {
        return new JMenuItem(this);
    }

    public Component getToolbarPresenter() {
        return new JButton(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange("Name", null, this.getValue("Name"));
        this.changeSupport.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        this.changeSupport.firePropertyChange("MnemonicKey", null, this.getValue("MnemonicKey"));
    }
}

