/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.io.IOException;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AntTargetNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class AntProjectChildren
extends Children.Keys
implements ChangeListener,
Comparator {
    private static Collator SORTER = Collator.getInstance();
    private final AntProjectCookie cookie;
    private SortedSet allTargets;

    public AntProjectChildren(AntProjectCookie antProjectCookie) {
        this.cookie = antProjectCookie;
    }

    protected void addNotify() {
        super.addNotify();
        this.refreshKeys(true);
        this.cookie.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        super.removeNotify();
        this.setKeys(Collections.EMPTY_SET);
        AntProjectChildren antProjectChildren = this;
        synchronized (antProjectChildren) {
            this.allTargets = null;
        }
        this.cookie.removeChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshKeys(boolean bl) {
        try {
            SortedSet sortedSet;
            Set set = TargetLister.getTargets(this.cookie);
            AntProjectChildren antProjectChildren = this;
            synchronized (antProjectChildren) {
                if (this.allTargets == null && !bl) {
                    return;
                }
                this.allTargets = new TreeSet(this);
                this.allTargets.addAll(set);
                Iterator iterator = this.allTargets.iterator();
                while (iterator.hasNext()) {
                    TargetLister.Target target = (TargetLister.Target)iterator.next();
                    if (!target.isOverridden()) continue;
                    iterator.remove();
                }
                sortedSet = this.allTargets;
            }
            if (sortedSet != null) {
                this.setKeys(sortedSet);
            }
        }
        catch (IOException iOException) {
            AntModule.err.notify(1, (Throwable)iOException);
            this.setKeys(Collections.EMPTY_SET);
        }
    }

    protected Node[] createNodes(Object object) {
        TargetLister.Target target = (TargetLister.Target)object;
        return new Node[]{new AntTargetNode(this.cookie, target, this.allTargets)};
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshKeys(false);
    }

    public int compare(Object object, Object object2) {
        TargetLister.Target target = (TargetLister.Target)object;
        TargetLister.Target target2 = (TargetLister.Target)object2;
        int n = SORTER.compare(target.getName(), target2.getName());
        if (n != 0 || target == target2) {
            return n;
        }
        return System.identityHashCode(target) - System.identityHashCode(target2);
    }
}

