/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.Image;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.nodes.AntProjectChildren;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

public final class AntProjectNode
extends DataNode
implements ChangeListener {
    public AntProjectNode(DataObject dataObject) {
        this(dataObject, (AntProjectCookie)dataObject.getCookie(AntProjectCookie.class));
    }

    private AntProjectNode(DataObject dataObject, AntProjectCookie antProjectCookie) {
        super(dataObject, (Children)new AntProjectChildren(antProjectCookie));
        antProjectCookie.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)antProjectCookie));
    }

    public Image getIcon(int n) {
        Image image = this.getBasicIcon();
        try {
            image = this.getDataObject().getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, this.getDataObject().files());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            AntModule.err.notify(1, (Throwable)fileStateInvalidException);
        }
        return image;
    }

    private Image getBasicIcon() {
        AntProjectCookie.ParseStatus parseStatus = (AntProjectCookie.ParseStatus)this.getCookie(AntProjectCookie.ParseStatus.class);
        if (parseStatus.getFile() == null && parseStatus.getFileObject() == null) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIconError.gif");
        }
        if (!parseStatus.isParsed()) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIcon.gif");
        }
        Throwable throwable = parseStatus.getParseException();
        if (throwable != null) {
            return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIconError.gif");
        }
        return Utilities.loadImage((String)"org/apache/tools/ant/module/resources/AntIcon.gif");
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getShortDescription() {
        AntProjectCookie antProjectCookie = (AntProjectCookie)this.getCookie(AntProjectCookie.class);
        if (antProjectCookie.getFile() == null && antProjectCookie.getFileObject() == null) {
            return super.getShortDescription();
        }
        Throwable throwable = antProjectCookie.getParseException();
        if (throwable != null) {
            String string = throwable.getLocalizedMessage();
            if (string != null) {
                return string;
            }
            return throwable.toString();
        }
        Element element = antProjectCookie.getProjectElement();
        if (element != null) {
            String string = element.getAttribute("name");
            if (!string.equals("")) {
                return NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_named_script_description", (Object)string);
            }
            return NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_anon_script_description");
        }
        return super.getShortDescription();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("project");
        set.setDisplayName(NbBundle.getMessage((Class)AntProjectNode.class, (String)"LBL_proj_sheet"));
        set.setShortDescription(NbBundle.getMessage((Class)AntProjectNode.class, (String)"HINT_proj_sheet"));
        this.add2Sheet(set);
        sheet.put(set);
        return sheet;
    }

    private void add2Sheet(Sheet.Set set) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)AntProjectNode.class);
        AntProjectCookie antProjectCookie = (AntProjectCookie)this.getCookie(AntProjectCookie.class);
        AntProperty antProperty = new ProjectNameProperty("name", antProjectCookie);
        antProperty.setName("projectName");
        antProperty.setDisplayName(resourceBundle.getString("PROP_projectName"));
        antProperty.setShortDescription(resourceBundle.getString("HINT_projectName"));
        set.put((Node.Property)antProperty);
        antProperty = new ProjectTargetProperty("default", antProjectCookie);
        antProperty.setDisplayName(resourceBundle.getString("PROP_default"));
        antProperty.setShortDescription(resourceBundle.getString("HINT_default"));
        set.put((Node.Property)antProperty);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                AntProjectNode.this.fireIconChange();
                AntProjectNode.this.fireOpenedIconChange();
                AntProjectNode.this.fireShortDescriptionChange(null, null);
                AntProjectNode.this.fireCookieChange();
                AntProjectNode.this.firePropertyChange(null, null, null);
            }
        });
    }

    private class ProjectTargetProperty
    extends AntProperty {
        public ProjectTargetProperty(String string, AntProjectCookie antProjectCookie) {
            super(string, antProjectCookie);
        }

        protected Element getElement() {
            return ((AntProjectCookie)AntProjectNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = AntProjectNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).getProjectElement();
        }
    }

    private class ProjectNameProperty
    extends AntProperty {
        public ProjectNameProperty(String string, AntProjectCookie antProjectCookie) {
            super(string, antProjectCookie);
        }

        protected Element getElement() {
            return ((AntProjectCookie)AntProjectNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = AntProjectNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).getProjectElement();
        }
    }
}

