/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.apache.tools.ant.module.nodes.AntTargetNode;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class AntTargetNode
extends AbstractNode
implements ChangeListener {
    private final AntProjectCookie project;
    private final TargetLister.Target target;
    private final Set allTargets;
    private boolean attachedCookieListener = false;
    private static String internalTargetColor;
    private final Action EXECUTE = new ExecuteAction();
    private final Action CREATE_SHORTCUT = new CreateShortcutAction();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;

    public AntTargetNode(AntProjectCookie antProjectCookie, TargetLister.Target target, Set set) {
        super(Children.LEAF);
        this.project = antProjectCookie;
        if (!$assertionsDisabled && target.isOverridden()) {
            throw new AssertionError((Object)"Cannot include overridden targets");
        }
        this.target = target;
        this.allTargets = set;
        target.getScript().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)target.getScript()));
        this.setName(target.getQualifiedName());
        this.setDisplayName(target.getName());
        if (target.isDescribed()) {
            this.setShortDescription(target.getElement().getAttribute("description"));
            this.setIconBaseWithExtension("org/apache/tools/ant/module/resources/EmphasizedTargetIcon.gif");
        } else if (target.isDefault()) {
            this.setIconBaseWithExtension("org/apache/tools/ant/module/resources/EmphasizedTargetIcon.gif");
        } else {
            this.setIconBaseWithExtension("org/apache/tools/ant/module/resources/TargetIcon.gif");
        }
        this.getCookieSet().add((Node.Cookie)new TargetOpenCookie(target));
    }

    private static synchronized String getInternalTargetColor() {
        if (internalTargetColor == null) {
            internalTargetColor = UIManager.getDefaults().getColor("Tree.selectionBackground").equals(UIManager.getDefaults().getColor("controlShadow")) ? "Tree.selectionBorderColor" : "controlShadow";
        }
        return internalTargetColor;
    }

    public String getHtmlDisplayName() {
        boolean bl;
        boolean bl2 = bl = this.target.getScript() != this.project;
        if (!(bl || this.target.isDefault() || this.target.isInternal())) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.target.getName());
        if (bl) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (this.target.isDefault()) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (this.target.isInternal()) {
            stringBuffer.insert(0, "'>");
            stringBuffer.insert(0, AntTargetNode.getInternalTargetColor());
            stringBuffer.insert(0, "<font color='!");
            stringBuffer.append("</font>");
        }
        return stringBuffer.toString();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.firePropertyChange(null, null, null);
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public Action[] getActions(boolean bl) {
        if (!this.target.isInternal()) {
            return new Action[]{SystemAction.get((Class)OpenAction.class), null, this.EXECUTE, this.CREATE_SHORTCUT, null, SystemAction.get((Class)PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get((Class)OpenAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get((Class)OpenAction.class);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        if (set == null) {
            set = Sheet.createPropertiesSet();
            sheet.put(set);
        }
        String[] stringArray = new String[]{"name", "description", "depends"};
        for (int i = 0; i < stringArray.length; ++i) {
            AntProperty antProperty = new AntProperty(this.target.getElement(), stringArray[i], this.project);
            antProperty.setDisplayName(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode") : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)("PROP_target_" + stringArray[i])));
            antProperty.setShortDescription(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode") : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)("HINT_target_" + stringArray[i])));
            set.put((Node.Property)antProperty);
        }
        return sheet;
    }

    static {
        $assertionsDisabled = !AntTargetNode.class.desiredAssertionStatus();
        internalTargetColor = null;
    }

    private static final class TargetOpenCookie
    implements OpenCookie {
        private final TargetLister.Target target;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TargetOpenCookie(TargetLister.Target target) {
            this.target = target;
        }

        public void open() {
            LineCookie lineCookie;
            EditorCookie editorCookie;
            Object object;
            if (this.target.getScript().getParseException() != null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            FileObject fileObject = this.target.getScript().getFileObject();
            if (!$assertionsDisabled && fileObject == null) {
                throw new AssertionError((Object)("No build script for " + this.target));
            }
            try {
                object = DataObject.find((FileObject)fileObject);
                editorCookie = (EditorCookie)object.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = AntTargetNode.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                lineCookie = (LineCookie)object.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = AntTargetNode.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie);
                if (!$assertionsDisabled && editorCookie == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && lineCookie == null) {
                    throw new AssertionError();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
            try {
                object = editorCookie.openDocument();
                InputSource inputSource = AntProjectSupport.createInputSource(fileObject, (StyledDocument)object);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                int[] nArray = new int[1];
                String string = this.target.getName();
                class Handler
                extends DefaultHandler {
                    private Locator locator;
                    private final /* synthetic */ int[] val$line;
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ TargetOpenCookie this$0;

                    Handler(TargetOpenCookie targetOpenCookie, int[] nArray, String string) {
                        this.this$0 = targetOpenCookie;
                        this.val$line = nArray;
                        this.val$name = string;
                    }

                    public void setDocumentLocator(Locator locator) {
                        this.locator = locator;
                    }

                    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                        if (this.val$line[0] == 0 && string3.equals("target") && this.val$name.equals(attributes.getValue("name"))) {
                            this.val$line[0] = this.locator.getLineNumber();
                        }
                    }
                }
                sAXParser.parse(inputSource, (DefaultHandler)new Handler(this, nArray, string));
                if (nArray[0] < 1) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                lineCookie.getLineSet().getCurrent(nArray[0] - 1).show(2);
            }
            catch (Exception exception) {
                AntModule.err.notify(1, (Throwable)exception);
                return;
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? (class$org$apache$tools$ant$module$nodes$AntTargetNode = AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode")) : class$org$apache$tools$ant$module$nodes$AntTargetNode).desiredAssertionStatus();
        }
    }

    private final class BuildSequenceProperty
    extends PropertySupport.ReadOnly {
        public BuildSequenceProperty() {
            super("buildSequence", class$java$lang$String == null ? (class$java$lang$String = AntTargetNode.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? (class$org$apache$tools$ant$module$nodes$AntTargetNode = AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode")) : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)"PROP_target_sequence"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? (class$org$apache$tools$ant$module$nodes$AntTargetNode = AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode")) : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)"HINT_target_sequence"));
        }

        public Object getValue() {
            return "XXX BuildSequenceProperty currently unimplemented";
        }
    }

    private final class CreateShortcutAction
    extends AbstractAction {
        CreateShortcutAction() {
            super(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? (class$org$apache$tools$ant$module$nodes$AntTargetNode = AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode")) : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)"LBL_create_shortcut"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutWizard.show(AntTargetNode.this.project, AntTargetNode.this.target.getElement());
        }
    }

    private final class ExecuteAction
    extends AbstractAction {
        ExecuteAction() {
            super(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$AntTargetNode == null ? (class$org$apache$tools$ant$module$nodes$AntTargetNode = AntTargetNode.class$("org.apache.tools.ant.module.nodes.AntTargetNode")) : class$org$apache$tools$ant$module$nodes$AntTargetNode), (String)"LBL_execute_target"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TargetExecutor targetExecutor = new TargetExecutor(AntTargetNode.this.project, new String[]{AntTargetNode.this.target.getName()});
                targetExecutor.execute();
            }
            catch (IOException iOException) {
                AntModule.err.notify((Throwable)iOException);
            }
        }
    }
}

