/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.nodes.AdvancedActionPanel;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public final class RunTargetsAction
extends SystemAction
implements ContextAwareAction {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

    public String getName() {
        return NbBundle.getMessage((Class)RunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Action should never be called without a context");
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static JMenu createMenu(AntProjectCookie antProjectCookie) {
        return new LazyMenu(antProjectCookie);
    }

    static {
        $assertionsDisabled = !RunTargetsAction.class.desiredAssertionStatus();
    }

    private static final class AdvancedAction
    extends AbstractAction {
        private final AntProjectCookie project;
        private final Set allTargets;

        public AdvancedAction(AntProjectCookie antProjectCookie, Set set) {
            super(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced"));
            this.project = antProjectCookie;
            this.allTargets = set;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"TITLE_run_advanced");
            AdvancedActionPanel advancedActionPanel = new AdvancedActionPanel(this.project, this.allTargets);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedActionPanel, string);
            dialogDescriptor.setOptionType(2);
            JButton jButton = new JButton(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced_run"));
            jButton.setDefaultCapable(true);
            JButton jButton2 = new JButton(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_advanced_cancel"));
            dialogDescriptor.setOptions(new Object[]{jButton, jButton2});
            dialogDescriptor.setModal(true);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (object.equals(jButton)) {
                try {
                    advancedActionPanel.run();
                }
                catch (IOException iOException) {
                    AntModule.err.notify((Throwable)iOException);
                }
            }
        }
    }

    private static final class TargetMenuItemHandler
    implements ActionListener,
    Runnable {
        private final AntProjectCookie project;
        private final String target;

        public TargetMenuItemHandler(AntProjectCookie antProjectCookie, String string) {
            this.project = antProjectCookie;
            this.target = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            try {
                TargetExecutor targetExecutor = new TargetExecutor(this.project, new String[]{this.target});
                targetExecutor.execute();
            }
            catch (IOException iOException) {
                AntModule.err.notify((Throwable)iOException);
            }
        }
    }

    private static final class LazyMenu
    extends JMenu {
        private final AntProjectCookie project;
        private boolean initialized = false;

        public LazyMenu(AntProjectCookie antProjectCookie) {
            super(SystemAction.get((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction)).getName());
            this.project = antProjectCookie;
        }

        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                Object object;
                Object object2;
                Set set;
                this.initialized = true;
                try {
                    set = TargetLister.getTargets(this.project);
                }
                catch (IOException iOException) {
                    AntModule.err.notify(1, (Throwable)iOException);
                    set = Collections.EMPTY_SET;
                }
                Object object3 = null;
                TreeSet<Object> treeSet = new TreeSet<Object>(Collator.getInstance());
                TreeSet<Object> treeSet2 = new TreeSet<Object>(Collator.getInstance());
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    TargetLister.Target target = (TargetLister.Target)iterator.next();
                    if (target.isOverridden() || target.isInternal()) continue;
                    object2 = target.getName();
                    if (target.isDefault()) {
                        object3 = object2;
                        continue;
                    }
                    if (target.isDescribed()) {
                        treeSet.add(object2);
                        continue;
                    }
                    treeSet2.add(object2);
                }
                boolean bl = false;
                if (object3 != null) {
                    bl = true;
                    object2 = new JMenuItem((String)object3);
                    ((AbstractButton)object2).addActionListener(new TargetMenuItemHandler(this.project, (String)object3));
                    this.add((JMenuItem)object2);
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                if (!treeSet.isEmpty()) {
                    bl = true;
                    iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        object = new JMenuItem((String)object2);
                        ((AbstractButton)object).addActionListener(new TargetMenuItemHandler(this.project, (String)object2));
                        this.add((JMenuItem)object);
                    }
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                if (!treeSet2.isEmpty()) {
                    bl = true;
                    object2 = new JMenu(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction), (String)"LBL_run_other_targets"));
                    iterator = treeSet2.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        JMenuItem jMenuItem = new JMenuItem((String)object);
                        jMenuItem.addActionListener(new TargetMenuItemHandler(this.project, (String)object));
                        ((JMenu)object2).add(jMenuItem);
                    }
                    this.add((JMenuItem)object2);
                }
                if (bl) {
                    bl = false;
                    this.addSeparator();
                }
                this.add(new AdvancedAction(this.project, set));
            }
            return super.getPopupMenu();
        }
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final AntProjectCookie project;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ContextAction(Lookup lookup) {
            super(SystemAction.get((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction)).getName());
            Collection collection = lookup.lookup(new Lookup.Template(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = RunTargetsAction.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie)).allInstances();
            AntProjectCookie antProjectCookie = null;
            if (collection.size() == 1 && (antProjectCookie = (AntProjectCookie)collection.iterator().next()).getParseException() != null) {
                antProjectCookie = null;
            }
            this.project = antProjectCookie;
            super.setEnabled(this.project != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Action should not be called directly");
            }
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return RunTargetsAction.createMenu(this.project);
            }
            return new Actions.MenuItem((Action)this, false);
        }

        public void setEnabled(boolean bl) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"No modifications to enablement status permitted");
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = RunTargetsAction.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction).desiredAssertionStatus();
        }
    }
}

