/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;

public final class StandardLogger
extends AntLogger {
    private static final ErrorManager ERR;
    private static final boolean LOGGABLE;
    private static final Pattern CARET_SHOWING_COLUMN;
    private final long mockTotalTime;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long l) {
        this.mockTotalTime = l;
    }

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return AntLogger.ALL_TASKS;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        int n = antSession.getVerbosity();
        if (!($assertionsDisabled || n >= 0 && n <= 4)) {
            throw new AssertionError(n);
        }
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private SessionData getSessionData(AntSession antSession) {
        SessionData sessionData = (SessionData)antSession.getCustomData(this);
        if (sessionData == null) {
            sessionData = new SessionData();
            antSession.putCustomData(this, sessionData);
        }
        return sessionData;
    }

    public void buildInitializationFailed(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        Throwable throwable = antEvent.getException();
        if (antEvent.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(throwable, antEvent);
        } else {
            antEvent.getSession().println(throwable.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    private static void deliverBlockOfTextAsLines(String string, AntEvent antEvent, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            antEvent.getSession().deliverMessageLogged(antEvent, string2, n);
        }
    }

    private static void deliverStackTrace(Throwable throwable, AntEvent antEvent) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        StandardLogger.deliverBlockOfTextAsLines(stringWriter.toString(), antEvent, 0);
    }

    public void buildStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        this.getSessionData((AntSession)antEvent.getSession()).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_running_ant", (Object)antEvent.getSession().getDisplayName()));
        antEvent.consume();
    }

    public void buildFinished(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        AntSession antSession = antEvent.getSession();
        Throwable throwable = antEvent.getException();
        long l = System.currentTimeMillis() - this.getSessionData((AntSession)antSession).startTime;
        if (this.mockTotalTime != 0L) {
            l = this.mockTotalTime;
        }
        if (throwable == null) {
            antSession.println(StandardLogger.formatMessageWithTime("FMT_finished_target_printed", l), false, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_finished_target_status", (Object)antSession.getDisplayName()));
        } else {
            if (!antSession.isExceptionConsumed(throwable)) {
                antSession.consumeException(throwable);
                if (throwable.getClass().getName().equals("org.apache.tools.ant.BuildException") && antSession.getVerbosity() < 3) {
                    String string = throwable.toString();
                    StandardLogger.deliverBlockOfTextAsLines(string, antEvent, 0);
                } else if (!(throwable instanceof ThreadDeath) || antEvent.getSession().getVerbosity() >= 3) {
                    StandardLogger.deliverStackTrace(throwable, antEvent);
                }
            }
            antEvent.getSession().println(StandardLogger.formatMessageWithTime("FMT_target_failed_printed", l), true, null);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)StandardLogger.class, (String)"FMT_target_failed_status", (Object)antEvent.getSession().getDisplayName()));
        }
        antEvent.consume();
    }

    private static String formatMessageWithTime(String string, long l) {
        int n = (int)(l / 1000L);
        int n2 = n / 60;
        int n3 = n % 60;
        return NbBundle.getMessage((Class)StandardLogger.class, (String)string, (Object)new Integer(n2), (Object)new Integer(n3));
    }

    public void targetStarted(AntEvent antEvent) {
        if (antEvent.isConsumed()) {
            return;
        }
        String string = antEvent.getTargetName();
        if (string != null) {
            int n;
            int n2 = n = string.length() > 0 && string.charAt(0) == '-' ? 3 : 2;
            if (antEvent.getSession().getVerbosity() >= n) {
                antEvent.getSession().println(NbBundle.getMessage((Class)StandardLogger.class, (String)"MSG_target_started_printed", (Object)string), false, null);
            }
        }
        antEvent.consume();
    }

    public void messageLogged(AntEvent antEvent) {
        Object object;
        if (antEvent.isConsumed()) {
            return;
        }
        antEvent.consume();
        AntSession antSession = antEvent.getSession();
        String string = antEvent.getMessage();
        if (LOGGABLE) {
            ERR.log("Received message: " + string);
        }
        if (string.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(string, antEvent, antEvent.getLogLevel());
            return;
        }
        Matcher matcher = CARET_SHOWING_COLUMN.matcher(string);
        if (matcher.matches()) {
            if (LOGGABLE) {
                ERR.log("Looks like a special caret line");
            }
            object = this.getSessionData(antSession);
            if (object.lastHyperlink != null) {
                object.lastHyperlink.setColumn1(matcher.group(1).length() + 1);
                object.lastHyperlink = null;
                return;
            }
        }
        if ((object = StandardLogger.findHyperlink(antSession, string)) instanceof Hyperlink) {
            this.getSessionData((AntSession)antSession).lastHyperlink = (Hyperlink)object;
        }
        antEvent.getSession().println(string, antEvent.getLogLevel() <= 1, (OutputListener)object);
    }

    public void taskFinished(AntEvent antEvent) {
        this.getSessionData((AntSession)antEvent.getSession()).lastHyperlink = null;
    }

    private static OutputListener findHyperlink(AntSession antSession, String string) {
        String string2;
        int n;
        if (string.startsWith("file:///")) {
            string = string.substring(7);
            if (LOGGABLE) {
                ERR.log("removing file:///");
            }
        } else if (string.startsWith("file:")) {
            string = string.substring(5);
            if (LOGGABLE) {
                ERR.log("removing file:");
            }
        } else if (string.length() > 0 && string.charAt(0) == '/') {
            if (LOGGABLE) {
                ERR.log("result: looks like Unix file");
            }
        } else if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            if (LOGGABLE) {
                ERR.log("result: looks like Windows file");
            }
        } else {
            if (LOGGABLE) {
                ERR.log("result: not a file");
            }
            return null;
        }
        if ((n = string.indexOf(58)) == -1) {
            if (LOGGABLE) {
                ERR.log("result: no colon found");
            }
            return null;
        }
        String string3 = string.substring(0, n);
        File file = FileUtil.normalizeFile((File)new File(string3));
        if (!file.exists()) {
            if (LOGGABLE) {
                ERR.log("result: no FO for " + string3);
            }
            if ((n = string.indexOf(58, n + 1)) == -1) {
                if (LOGGABLE) {
                    ERR.log("result: no second colon found");
                }
                return null;
            }
            string3 = string.substring(0, n);
            file = FileUtil.normalizeFile((File)new File(string3));
            if (!file.exists()) {
                if (LOGGABLE) {
                    ERR.log("result: no FO for " + string3);
                }
                return null;
            }
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = n + 1;
        int n7 = string.indexOf(58, n + 1);
        if (n7 != -1) {
            try {
                n2 = Integer.parseInt(string.substring(n + 1, n7).trim());
                n6 = n7 + 1;
                int n8 = string.indexOf(58, n7 + 1);
                if (n8 != -1) {
                    n3 = Integer.parseInt(string.substring(n7 + 1, n8).trim());
                    n6 = n8 + 1;
                    int n9 = string.indexOf(58, n8 + 1);
                    if (n9 != -1) {
                        n4 = Integer.parseInt(string.substring(n8 + 1, n9).trim());
                        n6 = n9 + 1;
                        int n10 = string.indexOf(58, n9 + 1);
                        if (n10 != -1) {
                            n5 = Integer.parseInt(string.substring(n9 + 1, n10).trim());
                            if (n5 == n3) {
                                n5 = -1;
                            }
                            n6 = n10 + 1;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = string.substring(n6).trim()).length() == 0) {
            string2 = null;
        }
        if (LOGGABLE) {
            ERR.log("Hyperlink: [" + file + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + string2 + "]");
        }
        try {
            return antSession.createStandardHyperlink(file.toURI().toURL(), string2, n2, n3, n4, n5);
        }
        catch (MalformedURLException malformedURLException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)malformedURLException);
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !StandardLogger.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance(StandardLogger.class.getName());
        LOGGABLE = ERR.isLoggable(1);
        CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
    }
}

