/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.StopBuildingAction;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

public final class TargetExecutor
implements Runnable {
    private static final boolean USE_PROGRESS = Boolean.getBoolean("org.apache.tools.ant.module.run.TargetExecutor.USE_PROGRESS");
    private static final Map freeTabs = new WeakHashMap();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getDefault().getVerbosity();
    private Properties properties = (Properties)AntSettings.getDefault().getProperties().clone();
    private List targetNames;
    private String displayName;

    public TargetExecutor(AntProjectCookie antProjectCookie, String[] stringArray) {
        this.pcookie = antProjectCookie;
        this.targetNames = stringArray == null ? null : Arrays.asList((Object[])stringArray);
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = (Properties)properties.clone();
    }

    public synchronized void addProperties(Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Properties properties2 = this.properties;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties2);
        this.properties.putAll((Map<?, ?>)properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        Object object;
        StringBuffer stringBuffer;
        Element element = this.pcookie.getProjectElement();
        String string = element != null ? Actions.cutAmpersand((String)element.getAttribute("name")) : NbBundle.getMessage((Class)TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String string2 = this.pcookie.getFileObject() != null ? this.pcookie.getFileObject().getNameExt() : this.pcookie.getFile().getName();
        if (string.equals("")) {
            string = string2;
        }
        if (this.targetNames != null) {
            stringBuffer = new StringBuffer();
            object = this.targetNames.iterator();
            if (object.hasNext()) {
                stringBuffer.append((String)object.next());
            }
            while (object.hasNext()) {
                stringBuffer.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor") : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"SEP_output_target"));
                stringBuffer.append((String)object.next());
            }
            this.displayName = NbBundle.getMessage((Class)TargetExecutor.class, (String)"TITLE_output_target", (Object)string, (Object)string2, (Object)stringBuffer);
        } else {
            this.displayName = NbBundle.getMessage((Class)TargetExecutor.class, (String)"TITLE_output_notarget", (Object)string, (Object)string2);
        }
        object = this;
        synchronized (object) {
            if (AntSettings.getDefault().getAutoCloseTabs()) {
                Map map = freeTabs;
                synchronized (map) {
                    Iterator iterator = freeTabs.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        InputOutput inputOutput = (InputOutput)entry.getKey();
                        String string3 = (String)entry.getValue();
                        if (this.io == null && string3.equals(this.displayName)) {
                            this.io = inputOutput;
                            this.io.getOut().reset();
                            this.io.getErr().reset();
                            continue;
                        }
                        inputOutput.closeInputOutput();
                    }
                    freeTabs.clear();
                }
            }
            if (this.io == null) {
                this.io = IOProvider.getDefault().getIO(this.displayName, true);
            }
            stringBuffer = ExecutionEngine.getDefault().execute(this.displayName, (Runnable)this, InputOutput.NULL);
        }
        object = new WrapperExecutorTask((ExecutorTask)stringBuffer, this.io);
        RequestProcessor.getDefault().post((Runnable)object);
        return object;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask executorTask = ExecutionEngine.getDefault().execute(NbBundle.getMessage((Class)TargetExecutor.class, (String)"LABEL_execution_name"), (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(executorTask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        ProgressHandle[] progressHandleArray;
        Thread[] threadArray;
        block20: {
            block18: {
                Map map;
                block19: {
                    threadArray = new Thread[1];
                    progressHandleArray = new ProgressHandle[1];
                    try {
                        final boolean[] blArray = new boolean[]{AntSettings.getDefault().getAlwaysShowOutput()};
                        if (this.outputStream == null && blArray[0]) {
                            this.io.select();
                        }
                        if (AntSettings.getDefault().getSaveAll()) {
                            LifecycleManager.getDefault().saveAll();
                        }
                        if (this.outputStream != null) throw new RuntimeException("XXX No support for outputStream currently!");
                        OutputWriter outputWriter = this.io.getOut();
                        OutputWriter outputWriter2 = this.io.getErr();
                        File file = this.pcookie.getFile();
                        if (file == null) {
                            outputWriter2.println(NbBundle.getMessage((Class)TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                            Object var11_7 = null;
                            if (this.io == null) break block18;
                            map = freeTabs;
                            break block19;
                        }
                        Thread.currentThread().setPriority(3);
                        final Runnable runnable = new Runnable(){

                            public void run() {
                                if (!blArray[0]) {
                                    blArray[0] = true;
                                    TargetExecutor.this.io.select();
                                }
                            }
                        };
                        ReaderInputStream readerInputStream = null;
                        if (this.outputStream == null) {
                            try {
                                readerInputStream = new ReaderInputStream(this.io.getIn()){

                                    public int read() throws IOException {
                                        runnable.run();
                                        return super.read();
                                    }

                                    public int read(byte[] byArray) throws IOException {
                                        runnable.run();
                                        return super.read(byArray);
                                    }

                                    public int read(byte[] byArray, int n, int n2) throws IOException {
                                        runnable.run();
                                        return super.read(byArray, n, n2);
                                    }

                                    public long skip(long l) throws IOException {
                                        runnable.run();
                                        return super.skip(l);
                                    }
                                };
                            }
                            catch (IOException iOException) {
                                AntModule.err.notify(1, (Throwable)iOException);
                            }
                        }
                        threadArray[0] = Thread.currentThread();
                        if (USE_PROGRESS) {
                            progressHandleArray[0] = ProgressHandleFactory.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                                public boolean cancel() {
                                    TargetExecutor.stopProcess(threadArray[0]);
                                    return true;
                                }
                            }, (Action)new AbstractAction(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    TargetExecutor.this.io.select();
                                }
                            });
                            progressHandleArray[0].start();
                        }
                        StopBuildingAction.registerProcess(threadArray[0], this.displayName);
                        this.ok = AntBridge.getInterface().run(file, this.targetNames, (InputStream)readerInputStream, outputWriter, outputWriter2, this.properties, this.verbosity, this.displayName, runnable);
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var11_9 = null;
                        if (this.io != null) {
                            Map map2 = freeTabs;
                            synchronized (map2) {
                                freeTabs.put(this.io, this.displayName);
                            }
                        }
                        if (threadArray[0] != null) {
                            StopBuildingAction.unregisterProcess(threadArray[0]);
                        }
                        if (progressHandleArray[0] == null) throw throwable;
                        progressHandleArray[0].finish();
                        throw throwable;
                    }
                }
                synchronized (map) {
                    freeTabs.put(this.io, this.displayName);
                }
            }
            if (threadArray[0] != null) {
                StopBuildingAction.unregisterProcess(threadArray[0]);
            }
            if (progressHandleArray[0] == null) return;
            progressHandleArray[0].finish();
            return;
        }
        Object var11_8 = null;
        if (this.io != null) {
            Map map = freeTabs;
            synchronized (map) {
                freeTabs.put(this.io, this.displayName);
            }
        }
        if (threadArray[0] != null) {
            StopBuildingAction.unregisterProcess(threadArray[0]);
        }
        if (progressHandleArray[0] == null) return;
        progressHandleArray[0].finish();
    }

    static void stopProcess(Thread thread) {
        AntBridge.getInterface().stop(thread);
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask executorTask) {
            this.task = executorTask;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask executorTask, InputOutput inputOutput) {
            super((Runnable)new WrapperRunnable(executorTask));
            this.task = executorTask;
            this.io = inputOutput;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }
}

