/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class IntroPanel
extends JPanel {
    private IntroWizardPanel wiz;
    private JCheckBox customizeCheck;
    private JTextArea hintsArea;
    private JCheckBox keyboardCheck;
    private JCheckBox menuCheck;
    private JCheckBox toolbarCheck;

    public IntroPanel(IntroWizardPanel introWizardPanel) {
        this.wiz = introWizardPanel;
        this.initComponents();
        this.initAccessibility();
        this.setName(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_cfg_basic_opts"));
    }

    public void requestFocus() {
        super.requestFocus();
        this.customizeCheck.requestFocus();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.menuCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IntroPanel.class, (String)"ACS_IP_LBL_add_menu_item"));
        this.toolbarCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IntroPanel.class, (String)"ACS_IP_LBL_add_toolbar_button"));
        this.keyboardCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IntroPanel.class, (String)"ACS_IP_LBL_add_kbd_shortcut"));
        this.customizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)IntroPanel.class, (String)"ACS_IP_LBL_cust_code_checkbox"));
    }

    private void initComponents() {
        this.customizeCheck = new JCheckBox();
        this.menuCheck = new JCheckBox();
        this.toolbarCheck = new JCheckBox();
        this.keyboardCheck = new JCheckBox();
        this.hintsArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.customizeCheck.setText(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_cust_code_checkbox"));
        this.customizeCheck.setMnemonic(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_cust_code_checkbox_mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.customizeCheck, gridBagConstraints);
        this.menuCheck.setText(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_menu_item"));
        this.menuCheck.setMnemonic(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_menu_item_mnem").charAt(0));
        this.menuCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.menuCheck, gridBagConstraints);
        this.toolbarCheck.setText(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_toolbar_button"));
        this.toolbarCheck.setMnemonic(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_toolbar_button_mnem").charAt(0));
        this.toolbarCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.toolbarCheck, gridBagConstraints);
        this.keyboardCheck.setText(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_kbd_shortcut"));
        this.keyboardCheck.setMnemonic(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_LBL_add_kbd_shortcut_mnem").charAt(0));
        this.keyboardCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IntroPanel.this.someCheckboxClicked(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.keyboardCheck, gridBagConstraints);
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setText(NbBundle.getMessage((Class)IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.hintsArea.setBackground(new Color(204, 204, 204));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setForeground(new Color(102, 102, 153));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setOpaque(false);
        this.hintsArea.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.hintsArea, gridBagConstraints);
    }

    private void someCheckboxClicked(ActionEvent actionEvent) {
        this.wiz.fireChangeEvent();
    }

    public static class IntroWizardPanel
    implements WizardDescriptor.Panel {
        private IntroPanel panel = null;
        private ShortcutWizard wiz = null;
        private final Set listeners = new HashSet(1);

        public void initialize(ShortcutWizard shortcutWizard) {
            this.wiz = shortcutWizard;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        private IntroPanel getPanel() {
            if (this.panel == null) {
                this.panel = new IntroPanel(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().menuCheck.isSelected() || this.getPanel().toolbarCheck.isSelected() || this.getPanel().keyboardCheck.isSelected();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener changeListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener changeListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fireChangeEvent() {
            Iterator iterator;
            this.storeSettings((Object)this.wiz);
            Object object = this.listeners;
            synchronized (object) {
                iterator = new HashSet(this.listeners).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }

        public void readSettings(Object object) {
        }

        public void storeSettings(Object object) {
            WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
            wizardDescriptor.putProperty("wizdata.show.cust", (Object)(this.getPanel().customizeCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.menu", (Object)(this.getPanel().menuCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.tool", (Object)(this.getPanel().toolbarCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
            wizardDescriptor.putProperty("wizdata.show.keyb", (Object)(this.getPanel().keyboardCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        }
    }
}

