/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectFolderPanel
extends JPanel
implements DocumentListener {
    private final String prop;
    private final boolean stripAmps;
    private final SelectFolderWizardPanel wiz;
    private final DataFolder top;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JPanel displayNamePanel;
    private JList folderList;
    private JScrollPane folderScrollPane;
    private JTextArea hintsArea;

    public SelectFolderPanel(SelectFolderWizardPanel selectFolderWizardPanel, String string, String string2, String string3, DataFolder dataFolder, boolean bl, String string4) {
        this.wiz = selectFolderWizardPanel;
        this.initComponents();
        this.setName(string);
        this.hintsArea.setText(string2);
        this.initAccessibility(string2);
        this.displayNameLabel.setText(string3);
        this.prop = string4;
        this.top = dataFolder;
        this.stripAmps = bl;
        DefaultListModel<DataFolder> defaultListModel = new DefaultListModel<DataFolder>();
        DataFolder[] dataFolderArray = SelectFolderPanel.findFolders(dataFolder);
        for (int i = 0; i < dataFolderArray.length; ++i) {
            defaultListModel.addElement(dataFolderArray[i]);
        }
        this.folderList.setModel(defaultListModel);
        this.folderList.setCellRenderer(new CellRenderer());
        this.displayNameField.getDocument().addDocumentListener(this);
    }

    ListModel getModel() {
        return this.folderList.getModel();
    }

    private String getDisplayName(DataFolder dataFolder) {
        int n;
        String string = dataFolder.getNodeDelegate().getDisplayName();
        if (this.stripAmps && (n = string.indexOf(38)) != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    String getNestedDisplayName(DataFolder dataFolder) {
        StringBuffer stringBuffer = new StringBuffer();
        for (DataFolder dataFolder2 = dataFolder; dataFolder2 != this.top; dataFolder2 = dataFolder2.getFolder()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, " \u2192 ");
            }
            stringBuffer.insert(0, this.getDisplayName(dataFolder2));
        }
        return stringBuffer.toString();
    }

    private DataFolder getFolder() {
        return (DataFolder)this.folderList.getSelectedValue();
    }

    private void setFolder(DataFolder dataFolder) {
        this.folderList.setSelectedValue(dataFolder, true);
    }

    private static DataFolder[] findFolders(DataFolder dataFolder) {
        ArrayList arrayList = new ArrayList();
        SelectFolderPanel.visit(arrayList, dataFolder);
        arrayList.remove(0);
        return arrayList.toArray(new DataFolder[arrayList.size()]);
    }

    private static void visit(List list, DataFolder dataFolder) {
        list.add(dataFolder);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!(dataObjectArray[i] instanceof DataFolder)) continue;
            SelectFolderPanel.visit(list, (DataFolder)dataObjectArray[i]);
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.folderList.requestFocus();
    }

    private void initAccessibility(String string) {
        this.getAccessibleContext().setAccessibleDescription(string);
    }

    private void initComponents() {
        this.hintsArea = new JTextArea();
        this.folderScrollPane = new JScrollPane();
        this.folderList = new JList();
        this.displayNamePanel = new JPanel();
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.setLayout(new BorderLayout(0, 11));
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setText("<hints>");
        this.hintsArea.setBackground(new Color(204, 204, 204));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setForeground(new Color(102, 102, 153));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setOpaque(false);
        this.hintsArea.setEnabled(false);
        this.add((Component)this.hintsArea, "North");
        this.folderList.setSelectionMode(0);
        this.folderList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SelectFolderPanel.this.folderListValueChanged(listSelectionEvent);
            }
        });
        this.folderScrollPane.setViewportView(this.folderList);
        this.folderList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SelectFolderPanel.class, (String)"ACSN_folderList"));
        this.folderList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SelectFolderPanel.class, (String)"ACSD_folderList"));
        this.add((Component)this.folderScrollPane, "Center");
        this.displayNamePanel.setLayout(new FlowLayout(0));
        this.displayNameLabel.setText("<set display name>");
        this.displayNameLabel.setLabelFor(this.displayNameField);
        this.displayNamePanel.add(this.displayNameLabel);
        this.displayNameField.setColumns(30);
        this.displayNamePanel.add(this.displayNameField);
        this.add((Component)this.displayNamePanel, "South");
    }

    private void folderListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.wiz.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.wiz.fireChangeEvent();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.wiz.fireChangeEvent();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public static class SelectFolderWizardPanel
    implements WizardDescriptor.Panel {
        private SelectFolderPanel panel;
        private String namePanel;
        private String hintPanel;
        private String displayNameLabelText;
        private DataFolder topPanel;
        private boolean stripAmpsPanel;
        private String propPanel;
        private final Set listeners = new HashSet(1);

        public SelectFolderWizardPanel(String string, String string2, String string3, DataFolder dataFolder, boolean bl, String string4) {
            this.namePanel = string;
            this.hintPanel = string2;
            this.displayNameLabelText = string3;
            this.topPanel = dataFolder;
            this.stripAmpsPanel = bl;
            this.propPanel = string4;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        SelectFolderPanel getPanel() {
            if (this.panel == null) {
                this.panel = new SelectFolderPanel(this, this.namePanel, this.hintPanel, this.displayNameLabelText, this.topPanel, this.stripAmpsPanel, this.propPanel);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().getFolder() != null && this.getPanel().displayNameField.getText().length() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener changeListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener changeListener) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fireChangeEvent() {
            Iterator iterator;
            Object object = this.listeners;
            synchronized (object) {
                iterator = new HashSet(this.listeners).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }

        public void readSettings(Object object) {
            WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
            this.getPanel().setFolder((DataFolder)wizardDescriptor.getProperty(this.getPanel().prop));
            String string = (String)wizardDescriptor.getProperty("wizdata.displayName");
            this.getPanel().displayNameField.setText(string != null ? string : "");
        }

        public void storeSettings(Object object) {
            DataFolder dataFolder = this.getPanel().getFolder();
            WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
            wizardDescriptor.putProperty(this.getPanel().prop, (Object)dataFolder);
            wizardDescriptor.putProperty("wizdata.displayName", (Object)this.getPanel().displayNameField.getText());
        }
    }

    private final class CellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataFolder dataFolder = (DataFolder)object;
            String string = SelectFolderPanel.this.getNestedDisplayName(dataFolder);
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

