/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.KeyStroke;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ShortcutWizard
extends WizardDescriptor {
    private static final String PROP_CONTENTS = "wizdata.contents";
    static final String PROP_DISPLAY_NAME = "wizdata.displayName";
    static final String PROP_SHOW_CUST = "wizdata.show.cust";
    static final String PROP_SHOW_MENU = "wizdata.show.menu";
    static final String PROP_SHOW_TOOL = "wizdata.show.tool";
    static final String PROP_SHOW_KEYB = "wizdata.show.keyb";
    static final String PROP_FOLDER_MENU = "wizdata.folder.menu";
    static final String PROP_FOLDER_TOOL = "wizdata.folder.tool";
    static final String PROP_STROKE = "wizdata.stroke";
    private final AntProjectCookie project;
    private final Element target;
    private final ShortcutIterator it;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void show(AntProjectCookie antProjectCookie, Element element) {
        ShortcutWizard shortcutWizard = new ShortcutWizard(antProjectCookie, element, new ShortcutIterator());
        DialogDisplayer.getDefault().createDialog((DialogDescriptor)shortcutWizard).setVisible(true);
        if (shortcutWizard.getValue().equals(WizardDescriptor.FINISH_OPTION)) {
            try {
                shortcutWizard.finish();
            }
            catch (IOException iOException) {
                AntModule.err.notify((Throwable)iOException);
            }
        }
    }

    ShortcutWizard(AntProjectCookie antProjectCookie, Element element, ShortcutIterator shortcutIterator) {
        super((WizardDescriptor.Iterator)shortcutIterator);
        this.project = antProjectCookie;
        this.target = element;
        this.it = shortcutIterator;
        shortcutIterator.initialize(this);
        this.setTitle(NbBundle.getMessage((Class)ShortcutWizard.class, (String)"TITLE_wizard"));
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        String string = element.getAttribute("description");
        this.putProperty(PROP_DISPLAY_NAME, string);
    }

    String getContents() {
        String string = (String)this.getProperty(PROP_CONTENTS);
        if (string == null) {
            string = this.generateContents();
            this.putContents(string);
        }
        return string;
    }

    void putContents(String string) {
        this.putProperty(PROP_CONTENTS, string);
    }

    private String generateContents() {
        try {
            Document document = XMLUtil.createDocument((String)"project", null, null, null);
            Element element = document.getDocumentElement();
            String string = (String)this.getProperty(PROP_DISPLAY_NAME);
            if (string != null && string.length() > 0) {
                element.setAttribute("name", string);
            }
            element.setAttribute("default", "run");
            Element element2 = document.createElement("target");
            element2.setAttribute("name", "run");
            Element element3 = document.createElement("ant");
            element3.setAttribute("antfile", this.project.getFile().getAbsolutePath());
            element3.setAttribute("inheritall", "false");
            element3.setAttribute("target", this.target.getAttribute("name"));
            element2.appendChild(element3);
            element.appendChild(element2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (Exception exception) {
            AntModule.err.notify((Throwable)exception);
            return "";
        }
    }

    void finish() throws IOException {
        if (this.it.showing(PROP_SHOW_MENU)) {
            this.create((DataFolder)this.getProperty(PROP_FOLDER_MENU), null);
        }
        if (this.it.showing(PROP_SHOW_TOOL)) {
            this.create((DataFolder)this.getProperty(PROP_FOLDER_TOOL), null);
        }
        if (this.it.showing(PROP_SHOW_KEYB)) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Shortcuts");
            KeyStroke keyStroke = (KeyStroke)this.getProperty(PROP_STROKE);
            this.create(DataFolder.findFolder((FileObject)fileObject), Utilities.keyToString((KeyStroke)keyStroke));
        }
    }

    private void create(DataFolder dataFolder, String string) throws IOException {
        if (!$assertionsDisabled && dataFolder == null) {
            throw new AssertionError();
        }
        final String string2 = string != null ? string + ".xml" : FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getTargetBaseName(), (String)"xml") + ".xml";
        final String string3 = this.getContents();
        final FileObject fileObject = dataFolder.getPrimaryFile();
        final FileObject[] fileObjectArray = new FileObject[1];
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                fileObjectArray[0] = fileObject.createData(string2);
                FileLock fileLock = fileObjectArray[0].lock();
                try {
                    OutputStream outputStream = fileObjectArray[0].getOutputStream(fileLock);
                    try {
                        outputStream.write(string3.getBytes("UTF-8"));
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        });
    }

    String getTargetBaseName() {
        String string = "";
        Document document = this.project.getDocument();
        if (document != null) {
            string = document.getDocumentElement().getAttribute("name");
        }
        return (string + '-' + this.target.getAttribute("name")).replaceAll("[^a-zA-Z0-9_-]", "-");
    }

    static {
        $assertionsDisabled = !ShortcutWizard.class.desiredAssertionStatus();
    }
}

