/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.ui.TargetMappingPanel;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProjectCustomizer
extends JPanel
implements HelpCtx.Provider {
    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private List panels;
    private AntProjectHelper helper;
    private FreeformProject project;
    private DialogDescriptor dialogDescriptor;
    private static final String GENERAL_ICON = "general.gif";
    private JPanel categoryPanel;
    private JPanel customizerPanel;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public ProjectCustomizer(FreeformProject freeformProject, AntProjectHelper antProjectHelper) {
        this.helper = antProjectHelper;
        this.project = freeformProject;
        this.initComponents();
        HelpCtx.setHelpIDString((JComponent)this.customizerPanel, (String)"org.netbeans.modules.ant.freeform.ui.ProjectCustomizer");
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)new CategoryView(this.createRootNode()), this.fillConstraints);
    }

    void save() {
        Iterator iterator = this.panels.iterator();
        while (iterator.hasNext()) {
            ProjectPropertiesPanel projectPropertiesPanel = (ProjectPropertiesPanel)iterator.next();
            projectPropertiesPanel.storeValues();
        }
    }

    private void initComponents() {
        this.categoryPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.customizerPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer"));
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(new EtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 8, 8);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.categoryPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSN_ProjectCustomizer_categoryPanel"));
        this.categoryPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer_categoryPanel"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.customizerPanel, gridBagConstraints);
        this.customizerPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSN_ProjectCustomizer_customizerPanel"));
        this.customizerPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"ACSD_ProjectCustomizer_customizerPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 8, 8);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage((Class)ProjectCustomizer.class, (String)"LBL_Customizer_Categories"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
    }

    public HelpCtx getHelpCtx() {
        if (this.currentCustomizer != null) {
            return HelpCtx.findHelp((Component)this.currentCustomizer);
        }
        return HelpCtx.findHelp((Component)this.customizerPanel);
    }

    private List getProjectCustomizerPanels() {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)this.project.getLookup().lookup(AuxiliaryConfiguration.class);
        AntProjectHelper antProjectHelper = this.project.helper();
        PropertyEvaluator propertyEvaluator = this.project.evaluator();
        ArrayList<TargetMappingPanel.Panel> arrayList = new ArrayList<TargetMappingPanel.Panel>();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = FreeformProject.PROJECT_NATURES.allInstances().iterator();
        while (iterator.hasNext()) {
            ProjectNature projectNature = (ProjectNature)iterator.next();
            arrayList.addAll(projectNature.getCustomizerPanels(this.project, antProjectHelper, propertyEvaluator, auxiliaryConfiguration));
            arrayList2.addAll(projectNature.getExtraTargets(this.project, antProjectHelper, propertyEvaluator, auxiliaryConfiguration));
        }
        arrayList.add(new TargetMappingPanel.Panel(arrayList2, propertyEvaluator, antProjectHelper));
        Collections.sort(arrayList, new PanelsComparator());
        return arrayList;
    }

    private Node createRootNode() {
        Object object;
        String string = "org/netbeans/modules/ant/freeform/resources/";
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)ProjectCustomizer.class);
        ArrayList<ConfigurationDescription> arrayList = new ArrayList<ConfigurationDescription>();
        this.panels = this.getProjectCustomizerPanels();
        Iterator iterator = this.panels.iterator();
        while (iterator.hasNext()) {
            object = (ProjectPropertiesPanel)iterator.next();
            ConfigurationDescription configurationDescription = new ConfigurationDescription(object.getDisplayName(), object.getDisplayName(), string + GENERAL_ICON, (ProjectPropertiesPanel)object, null);
            arrayList.add(configurationDescription);
        }
        object = new ConfigurationDescription("InvisibleRoot", "InvisibleRoot", null, null, arrayList.toArray(new ConfigurationDescription[arrayList.size()]));
        return new ConfigurationNode((ConfigurationDescription)object);
    }

    private static class ConfigurationChildren
    extends Children.Keys {
        private Collection descriptions;

        public ConfigurationChildren(ConfigurationDescription[] configurationDescriptionArray) {
            this.descriptions = Arrays.asList(configurationDescriptionArray);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object object) {
            return new Node[]{new ConfigurationNode((ConfigurationDescription)object)};
        }
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private ProjectPropertiesPanel panel;
        private final String iconResource;

        public ConfigurationNode(ConfigurationDescription configurationDescription) {
            super((Children)(configurationDescription.children == null ? Children.LEAF : new ConfigurationChildren(configurationDescription.children)));
            this.setName(configurationDescription.name);
            this.setDisplayName(configurationDescription.displayName);
            this.iconResource = configurationDescription.iconResource;
            this.panel = configurationDescription.panel;
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            if (this.panel == null) {
                return null;
            }
            return this.panel.getComponent();
        }

        public Image getIcon(int n) {
            if (this.iconResource != null) {
                return Utilities.loadImage((String)this.iconResource, (boolean)true);
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            if (this.iconResource != null) {
                return Utilities.loadImage((String)this.iconResource, (boolean)true);
            }
            return super.getOpenedIcon(n);
        }
    }

    private static class ConfigurationDescription {
        private String name;
        private String displayName;
        private String iconResource;
        private ProjectPropertiesPanel panel;
        private ConfigurationDescription[] children;

        ConfigurationDescription(String string, String string2, String string3, ProjectPropertiesPanel projectPropertiesPanel, ConfigurationDescription[] configurationDescriptionArray) {
            this.name = string;
            this.displayName = string2;
            this.iconResource = string3;
            this.panel = projectPropertiesPanel;
            this.children = configurationDescriptionArray;
        }
    }

    private static class PanelsComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private PanelsComparator() {
        }

        public int compare(Object object, Object object2) {
            ProjectPropertiesPanel projectPropertiesPanel = (ProjectPropertiesPanel)object;
            ProjectPropertiesPanel projectPropertiesPanel2 = (ProjectPropertiesPanel)object2;
            if (projectPropertiesPanel.getPreferredPosition() == projectPropertiesPanel2.getPreferredPosition()) {
                return 0;
            }
            return projectPropertiesPanel.getPreferredPosition() - projectPropertiesPanel2.getPreferredPosition();
        }

        public boolean equals(Object object) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer == null ? (class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer = ProjectCustomizer.class$("org.netbeans.modules.ant.freeform.ui.ProjectCustomizer")) : class$org$netbeans$modules$ant$freeform$ui$ProjectCustomizer).desiredAssertionStatus();
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private BeanTreeView btv;

        CategoryView(Node node) {
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(dimension);
            this.btv.setPreferredSize(dimension);
            this.btv.setMaximumSize(dimension);
            this.btv.setDragSource(false);
            this.btv.setDragSource(false);
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(node);
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
            this.selectFirstNode();
            this.btv.expandAll();
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void addNotify() {
            super.addNotify();
            this.btv.expandAll();
        }

        private void selectFirstNode() {
            Node[] nodeArray;
            Children children = this.manager.getRootContext().getChildren();
            if (children != null && (nodeArray = children.getNodes()) != null && nodeArray.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    Node[] nodeArray = CategoryView.this.manager.getSelectedNodes();
                    if (nodeArray == null || nodeArray.length <= 0) {
                        return;
                    }
                    Node node = nodeArray[0];
                    if (ProjectCustomizer.this.currentCustomizer != null) {
                        ProjectCustomizer.this.customizerPanel.remove(ProjectCustomizer.this.currentCustomizer);
                    }
                    if (node.hasCustomizer()) {
                        ProjectCustomizer.this.currentCustomizer = node.getCustomizer();
                        ProjectCustomizer.this.customizerPanel.add(ProjectCustomizer.this.currentCustomizer, ProjectCustomizer.this.fillConstraints);
                        ProjectCustomizer.this.customizerPanel.validate();
                        ProjectCustomizer.this.customizerPanel.repaint();
                        if (ProjectCustomizer.this.dialogDescriptor != null) {
                            ProjectCustomizer.this.dialogDescriptor.setHelpCtx(ProjectCustomizer.this.getHelpCtx());
                        }
                    } else {
                        ProjectCustomizer.this.currentCustomizer = null;
                    }
                    return;
                }
            }
        }
    }
}

