/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.ui.ProjectCustomizer;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class ProjectCustomizerProvider
implements CustomizerProvider {
    private final FreeformProject project;
    private final AntProjectHelper antProjectHelper;
    private final PropertyEvaluator evaluator;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private DialogDescriptor dialogDescriptor;
    private Map customizerPerProject = new WeakHashMap();

    public ProjectCustomizerProvider(FreeformProject freeformProject, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.project = freeformProject;
        this.antProjectHelper = antProjectHelper;
        this.evaluator = propertyEvaluator;
    }

    public void showCustomizer() {
        Object[] objectArray;
        if (this.customizerPerProject.containsKey(this.project) && (objectArray = (Object[])this.customizerPerProject.get(this.project)).isShowing()) {
            objectArray.show();
            return;
        }
        objectArray = new JButton[]{new JButton(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        ProjectCustomizer projectCustomizer = new ProjectCustomizer(this.project, this.antProjectHelper);
        OptionListener optionListener = new OptionListener(this.project, projectCustomizer);
        objectArray[0].addActionListener(optionListener);
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"ACSD_Customizer_Ok_Option"));
        objectArray[1].addActionListener(optionListener);
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"ACSD_Customizer_Cancel_Option"));
        this.dialogDescriptor = new DialogDescriptor((Object)projectCustomizer, MessageFormat.format(NbBundle.getMessage((Class)ProjectCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()), false, objectArray, (Object)objectArray[0], 0, null, null);
        projectCustomizer.setDialogDescriptor(this.dialogDescriptor);
        this.dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.customizerPerProject.put(this.project, dialog);
        dialog.show();
    }

    private static class OptionListener
    implements ActionListener {
        private Project project;
        private ProjectCustomizer projectCustomizer;

        private OptionListener(Project project, ProjectCustomizer projectCustomizer) {
            this.project = project;
            this.projectCustomizer = projectCustomizer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ProjectCustomizerProvider.COMMAND_OK.equals(string)) {
                this.projectCustomizer.save();
                try {
                    ProjectManager.getDefault().saveProject(this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }
}

