/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ProjectNodeWrapper
extends FilterNode
implements Runnable,
FileStatusListener,
ChangeListener,
PropertyChangeListener {
    private Set files;
    private Map fileSystemListeners;
    private RequestProcessor.Task task;
    private final Object privateLock = new Object();
    private boolean iconChange;
    private boolean nameChange;
    private ChangeListener sourcesListener;
    private Map groupsListeners;
    public static final Action GENERIC_PROJECTS_ACTIONS_MARKER = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public ProjectNodeWrapper(Node node) {
        super(node);
        this.setProjectFiles();
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = super.getActions(bl);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (int i = 0; i < actionArray.length; ++i) {
            if (actionArray[i] != GENERIC_PROJECTS_ACTIONS_MARKER) {
                arrayList.add(actionArray[i]);
                continue;
            }
            try {
                Repository repository = Repository.getDefault();
                FileSystem fileSystem = repository.getDefaultFileSystem();
                FileObject fileObject = fileSystem.findResource("Projects/Actions");
                if (fileObject == null) continue;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                FolderLookup folderLookup = new FolderLookup((DataObject.Container)((DataFolder)dataObject));
                Lookup.Template template = new Lookup.Template(class$java$lang$Object == null ? ProjectNodeWrapper.class$("java.lang.Object") : class$java$lang$Object);
                Lookup lookup = folderLookup.getLookup();
                Iterator iterator = lookup.lookup(template).allInstances().iterator();
                if (iterator.hasNext()) {
                    arrayList.add(null);
                }
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof Action) {
                        arrayList.add((Action)e);
                        continue;
                    }
                    if (!(e instanceof JSeparator)) continue;
                    arrayList.add(null);
                }
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected final void setProjectFiles() {
        Project project = (Project)this.getLookup().lookup(Project.class);
        if (project != null) {
            this.setProjectFiles(project);
        } else {
            ErrorManager.getDefault().log(1, "Node: " + this.getOriginal() + " wrapped with ProjectNodeWrapper, but does not contain a Project in the lookup!");
        }
    }

    protected final void setProjectFiles(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        if (this.sourcesListener == null) {
            this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
            sources.addChangeListener(this.sourcesListener);
        }
        this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
    }

    private final void setGroups(Collection collection) {
        PropertyChangeListener propertyChangeListener;
        Object object;
        Object object2;
        if (this.groupsListeners != null) {
            object2 = this.groupsListeners.keySet().iterator();
            while (object2.hasNext()) {
                object = (SourceGroup)object2.next();
                propertyChangeListener = (PropertyChangeListener)this.groupsListeners.get(object);
                object.removePropertyChangeListener(propertyChangeListener);
            }
        }
        this.groupsListeners = new HashMap();
        object2 = new HashSet();
        object = collection.iterator();
        while (object.hasNext()) {
            propertyChangeListener = (SourceGroup)object.next();
            PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyChangeListener);
            this.groupsListeners.put(propertyChangeListener, propertyChangeListener2);
            propertyChangeListener.addPropertyChangeListener(propertyChangeListener2);
            FileObject fileObject = propertyChangeListener.getRootFolder();
            object2.add(fileObject);
        }
        this.setFiles((Set)object2);
    }

    protected final void setFiles(Set set) {
        FileStatusListener fileStatusListener;
        Object object;
        Iterator<Object> iterator;
        if (this.fileSystemListeners != null) {
            iterator = this.fileSystemListeners.keySet().iterator();
            while (iterator.hasNext()) {
                object = (FileSystem)iterator.next();
                fileStatusListener = (FileStatusListener)this.fileSystemListeners.get(object);
                object.removeFileStatusListener(fileStatusListener);
            }
        }
        this.fileSystemListeners = new HashMap();
        this.files = set;
        if (set == null) {
            return;
        }
        iterator = set.iterator();
        object = new HashSet();
        while (iterator.hasNext()) {
            ErrorManager errorManager;
            fileStatusListener = (FileObject)iterator.next();
            try {
                FileSystem fileSystem = fileStatusListener.getFileSystem();
                if (object.contains(fileSystem)) continue;
                object.add(fileSystem);
                errorManager = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                fileSystem.addFileStatusListener((FileStatusListener)errorManager);
                this.fileSystemListeners.put(fileSystem, errorManager);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)fileStateInvalidException, "Can not get " + fileStatusListener + " filesystem, ignoring...");
                errorManager.notify(1, (Throwable)fileStateInvalidException);
            }
        }
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = (FileObject)this.files.iterator().next();
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = (FileObject)this.files.iterator().next();
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl;
        boolean bl2;
        Object object = this.privateLock;
        synchronized (object) {
            bl2 = this.iconChange;
            bl = this.nameChange;
            this.iconChange = false;
            this.nameChange = false;
        }
        if (bl2) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
        if (bl) {
            this.fireDisplayNameChange(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        Object object = this.privateLock;
        synchronized (object) {
            if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                Iterator iterator = this.files.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject = (FileObject)iterator.next();
                    if (!fileStatusEvent.hasChanged(fileObject)) continue;
                    this.iconChange |= fileStatusEvent.isIconChange();
                    this.nameChange |= fileStatusEvent.isNameChange();
                }
            }
        }
        this.task.schedule(50);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setProjectFiles();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setProjectFiles();
    }
}

