/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.Actions;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.FreeformProjectGenerator;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.ui.TargetMappingPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class UnboundTargetAlert
extends JPanel {
    private final FreeformProject project;
    private final String command;
    private final String label;
    private JTextArea explanation;
    private JLabel introLabel;
    private JComboBox selectCombo;
    private JLabel selectLabel;

    public UnboundTargetAlert(FreeformProject freeformProject, String string) {
        this.project = freeformProject;
        this.command = string;
        this.label = NbBundle.getMessage((Class)Actions.class, (String)("CMD_" + string));
        this.initComponents();
        this.listTargets();
    }

    public static void main(String[] stringArray) {
        UnboundTargetAlert unboundTargetAlert = new UnboundTargetAlert("Twiddle Project", new String[]{"targ1", "targ2", "targ3"});
        boolean bl = unboundTargetAlert.displayAlert("BazzBuilder");
        System.out.println("accepted=" + bl + " value=" + unboundTargetAlert.selectCombo.getSelectedItem());
        System.exit(0);
    }

    private UnboundTargetAlert(String string, String[] stringArray) {
        this.project = null;
        this.command = null;
        this.label = string;
        this.initComponents();
        this.selectCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.selectCombo.setSelectedItem("");
    }

    private void listTargets() {
        List list;
        FileObject fileObject = FreeformProjectGenerator.getAntScript(this.project.helper(), this.project.evaluator());
        if (fileObject != null && (list = Util.getAntScriptTargetNames(fileObject)) != null) {
            this.selectCombo.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[list.size()])));
            this.selectCombo.setSelectedItem("");
        }
    }

    private boolean displayAlert(String string) {
        String string2 = NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_TITLE", (Object)this.label, (Object)string);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, string2);
        dialogDescriptor.setOptionType(2);
        dialogDescriptor.setMessageType(0);
        dialogDescriptor.setValid(false);
        this.selectCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                dialogDescriptor.setValid(((String)UnboundTargetAlert.this.selectCombo.getSelectedItem()).trim().length() > 0);
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.selectCombo.requestFocusInWindow();
        Dimension dimension = dialog.getSize();
        dialog.setSize(dimension.width, dimension.height + 30);
        dialog.setVisible(true);
        return dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION;
    }

    public boolean accepted() throws IOException {
        String string = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        if (this.displayAlert(string)) {
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                    public Object run() throws IOException {
                        UnboundTargetAlert.this.generateBindingAndAddContextMenuItem();
                        ProjectManager.getDefault().saveProject((Project)UnboundTargetAlert.this.project);
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                throw (IOException)mutexException.getException();
            }
            return true;
        }
        return false;
    }

    void generateBindingAndAddContextMenuItem() {
        List list = FreeformProjectGenerator.getTargetMappings(this.project.helper());
        FreeformProjectGenerator.TargetMapping targetMapping = new FreeformProjectGenerator.TargetMapping();
        targetMapping.name = this.command;
        targetMapping.script = TargetMappingPanel.defaultAntScript(this.project.evaluator());
        targetMapping.targets = Collections.list(new StringTokenizer((String)this.selectCombo.getSelectedItem()));
        list.add(targetMapping);
        FreeformProjectGenerator.putTargetMappings(this.project.helper(), list);
        FreeformProjectGenerator.putContextMenuAction(this.project.helper(), list);
    }

    private void initComponents() {
        this.introLabel = new JLabel();
        this.explanation = new JTextArea();
        this.selectLabel = new JLabel();
        this.selectCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.introLabel, (String)NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_LBL_intro", (Object)this.label));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.introLabel, gridBagConstraints);
        this.explanation.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.explanation.setEditable(false);
        this.explanation.setLineWrap(true);
        this.explanation.setText(NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_TEXT_explanation", (Object)this.label));
        this.explanation.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.explanation, gridBagConstraints);
        this.selectLabel.setLabelFor(this.selectCombo);
        Mnemonics.setLocalizedText((JLabel)this.selectLabel, (String)NbBundle.getMessage((Class)UnboundTargetAlert.class, (String)"UTA_LBL_select", (Object)this.label));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.selectLabel, gridBagConstraints);
        this.selectCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.selectCombo, gridBagConstraints);
    }

    void simulateTargetSelection(String string) {
        this.selectCombo.setSelectedItem(string);
    }
}

