/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.core.SuggestionNodeProperty;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.netbeans.modules.tasklist.core.editors.LocationPropertyEditor;
import org.netbeans.modules.tasklist.core.editors.PriorityPropertyEditor;
import org.netbeans.modules.tasklist.core.editors.StringPropertyEditor;
import org.netbeans.modules.tasklist.core.filter.FilterAction;
import org.netbeans.modules.tasklist.suggestions.EditTypesAction;
import org.netbeans.modules.tasklist.suggestions.FixAction;
import org.netbeans.modules.tasklist.suggestions.ShowSuggestionAction;
import org.netbeans.modules.tasklist.suggestions.SuggestionChildren;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionImplProperties;
import org.openide.actions.PropertiesAction;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class SuggestionNode
extends TaskNode {
    private TaskListView view;

    public SuggestionNode(SuggestionImpl suggestionImpl) {
        this(suggestionImpl, Children.LEAF);
    }

    protected SuggestionNode(SuggestionImpl suggestionImpl, Children children) {
        super((Task)suggestionImpl, children);
    }

    public Action getPreferredAction() {
        if (this.item.getAction() == null) {
            return SystemAction.get((Class)ShowSuggestionAction.class);
        }
        return SystemAction.get((Class)FixAction.class);
    }

    public Node cloneNode() {
        SuggestionNode suggestionNode = new SuggestionNode((SuggestionImpl)this.item);
        if (!suggestionNode.isLeaf()) {
            suggestionNode.setChildren((Children)this.getTaskChildren().clone());
        }
        return suggestionNode;
    }

    protected TaskChildren createChildren() {
        return new SuggestionChildren((SuggestionImpl)this.item);
    }

    protected void updateIcon() {
        this.setIconBase("org/netbeans/modules/tasklist/suggestions/suggTask");
    }

    protected SystemAction[] createActions() {
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        if (this.item.getAction() != null) {
            arrayList.add(SystemAction.get((Class)FixAction.class));
        }
        arrayList.add(SystemAction.get((Class)ShowSuggestionAction.class));
        List list = ((SuggestionImpl)this.item).getSType().getActions();
        if (list != null && list.size() > 0) {
            arrayList.add(null);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        if (!"nb-tasklist-scannedtask".equals(this.item.getType())) {
            arrayList.add(null);
            arrayList.add(SystemAction.get((Class)PropertiesAction.class));
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return new SystemAction[]{SystemAction.get((Class)FilterAction.class), SystemAction.get((Class)EditTypesAction.class)};
        }
        return super.getActions(false);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_SUMMARY));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_DETAILS));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_PRIORITY, PriorityPropertyEditor.class));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_FILENAME, StringPropertyEditor.class));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_LINE_NUMBER, StringPropertyEditor.class));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_CATEGORY));
        set.put((Node.Property)new SuggestionNodeProperty((Suggestion)this.item, SuggestionImplProperties.PROP_LOCATION, LocationPropertyEditor.class));
        return sheet;
    }

    static String getCategoryLabel() {
        return NbBundle.getMessage((Class)SuggestionNode.class, (String)"Category");
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        if (clazz.isAssignableFrom(Suggestion.class)) {
            return (SuggestionImpl)this.item;
        }
        Line line = this.item.getLine();
        if (line != null) {
            DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
            if (dataObject != null) {
                return dataObject.getCookie(clazz);
            }
            return null;
        }
        return null;
    }
}

