/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class SuggestionProviders {
    private List providers = null;
    private List docProviders = null;
    private Map providersByType = null;
    private static Reference instance;
    static Lookup lookup;
    private Lookup.Result lookupResult;

    private SuggestionProviders() {
    }

    public static synchronized SuggestionProviders getDefault() {
        if (instance == null) {
            return SuggestionProviders.createDefault();
        }
        SuggestionProviders suggestionProviders = (SuggestionProviders)instance.get();
        if (suggestionProviders == null) {
            return SuggestionProviders.createDefault();
        }
        return suggestionProviders;
    }

    private static SuggestionProviders createDefault() {
        SuggestionProviders suggestionProviders = new SuggestionProviders();
        instance = new WeakReference<SuggestionProviders>(suggestionProviders);
        return suggestionProviders;
    }

    public synchronized List getProviders() {
        if (this.providers == null) {
            SuggestionProvider[] suggestionProviderArray;
            this.providers = new ArrayList(20);
            Lookup.Template template = new Lookup.Template(SuggestionProvider.class);
            this.lookupResult = lookup.lookup(template);
            this.lookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    SuggestionProviders.this.invalidateCaches();
                }
            });
            Iterator iterator = this.lookupResult.allInstances().iterator();
            ArrayList<SuggestionProvider[]> arrayList = new ArrayList<SuggestionProvider[]>(20);
            while (iterator.hasNext()) {
                suggestionProviderArray = (SuggestionProvider[])iterator.next();
                arrayList.add(suggestionProviderArray);
            }
            suggestionProviderArray = arrayList.toArray(new SuggestionProvider[arrayList.size()]);
            final SuggestionTypes suggestionTypes = SuggestionTypes.getDefault();
            Arrays.sort(suggestionProviderArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    SuggestionProvider suggestionProvider = (SuggestionProvider)object;
                    SuggestionProvider suggestionProvider2 = (SuggestionProvider)object2;
                    try {
                        SuggestionType suggestionType = suggestionTypes.getType(suggestionProvider.getType());
                        SuggestionType suggestionType2 = suggestionTypes.getType(suggestionProvider2.getType());
                        return suggestionType.getPosition() - suggestionType2.getPosition();
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
            });
            for (int i = 0; i < suggestionProviderArray.length; ++i) {
                SuggestionProvider suggestionProvider = suggestionProviderArray[i];
                this.providers.add(suggestionProvider);
            }
        }
        return this.providers;
    }

    public synchronized List getDocProviders() {
        if (this.docProviders == null) {
            this.docProviders = new ArrayList(20);
            Iterator iterator = this.getProviders().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DocumentSuggestionProvider)) continue;
                this.docProviders.add(e);
            }
        }
        return this.docProviders;
    }

    public synchronized SuggestionProvider getProvider(SuggestionType suggestionType) {
        if (this.providersByType == null) {
            SuggestionTypes suggestionTypes = SuggestionTypes.getDefault();
            List list = this.getProviders();
            this.providersByType = new HashMap(100);
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
                String string = suggestionProvider.getType();
                if (string == null) {
                    ErrorManager.getDefault().log("SuggestionProvider " + suggestionProvider + " provides null value to getTypes()");
                    continue;
                }
                SuggestionType suggestionType2 = suggestionTypes.getType(string);
                this.providersByType.put(suggestionType2, suggestionProvider);
            }
        }
        return (SuggestionProvider)this.providersByType.get(suggestionType);
    }

    private synchronized void invalidateCaches() {
        this.providers = null;
        this.docProviders = null;
        this.providersByType = null;
    }

    static {
        lookup = Lookup.getDefault();
    }
}

