/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;

public final class SuggestionTypesFolder
extends FolderInstance {
    private static final String FOLDER = "Suggestions/Types";
    private static SuggestionTypesFolder folder;
    private Map suggestionTypes;
    private FileObject fo;

    private SuggestionTypesFolder(FileObject fileObject, DataFolder dataFolder) {
        super(dataFolder);
        this.recreate();
        this.instanceFinished();
        this.fo = fileObject;
    }

    public static synchronized SuggestionTypesFolder getSuggestionTypesFolder() {
        if (folder != null) {
            return folder;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
        if (fileObject == null) {
            return null;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = (DataFolder)dataObject.getCookie(DataFolder.class);
            if (dataFolder != null) {
                folder = new SuggestionTypesFolder(fileObject, dataFolder);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            return null;
        }
        return folder;
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        this.suggestionTypes = new HashMap(instanceCookieArray.length * 4 / 3);
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Object object = instanceCookieArray[i].instanceCreate();
            if (!(object instanceof SuggestionType)) continue;
            SuggestionType suggestionType = (SuggestionType)object;
            suggestionType.setPosition(i);
            this.suggestionTypes.put(suggestionType.getName(), suggestionType);
        }
        SuggestionTypes.getDefault().setTypes(this.suggestionTypes);
        return null;
    }
}

