/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.apihole.tasklist.SPIHole;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionProviders;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SuggestionsScanner
implements Cancellable {
    private ScanProgress progressMonitor;
    private final Set scanned = new HashSet();
    private SuggestionList list;
    private ProviderAcceptor typeFilter;
    private final SuggestionManagerImpl manager = (SuggestionManagerImpl)((Object)Lookup.getDefault().lookup(SuggestionManager.class));
    private final SuggestionProviders registry = SuggestionProviders.getDefault();
    private static Reference instance;
    private volatile boolean interrupted;
    private int suggestionsCounter;
    private int usabilityLimit = 503;
    private boolean workaround38476;
    private List cummulateInList;
    private static boolean lowMemoryWarning;
    private static int lowMemoryWarningCount;
    private static int MB;
    private static int REQUIRED_PER_ITERATION;
    private static int REQUIRED_PER_FULL_GC;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuggestionsScanner() {
    }

    public static SuggestionsScanner getDefault() {
        if (instance == null) {
            return SuggestionsScanner.createDefault();
        }
        SuggestionsScanner suggestionsScanner = (SuggestionsScanner)instance.get();
        if (suggestionsScanner == null) {
            return SuggestionsScanner.createDefault();
        }
        return suggestionsScanner;
    }

    private static SuggestionsScanner createDefault() {
        SuggestionsScanner suggestionsScanner = new SuggestionsScanner();
        instance = new WeakReference<SuggestionsScanner>(suggestionsScanner);
        return suggestionsScanner;
    }

    public final synchronized void scan(DataObject.Container[] containerArray, SuggestionList suggestionList, ScanProgress scanProgress) {
        this.scan(containerArray, suggestionList, scanProgress, ProviderAcceptor.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void scan(DataObject.Container[] containerArray, SuggestionList suggestionList, ScanProgress scanProgress, ProviderAcceptor providerAcceptor) {
        try {
            this.typeFilter = providerAcceptor;
            this.progressMonitor = scanProgress;
            this.scan(containerArray, suggestionList, true);
            Object var6_5 = null;
            this.typeFilter = null;
            this.progressMonitor = null;
            if (scanProgress != null) {
                scanProgress.scanFinished();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.typeFilter = null;
            this.progressMonitor = null;
            if (scanProgress != null) {
                scanProgress.scanFinished();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void scan(DataObject.Container[] containerArray, SuggestionList suggestionList, boolean bl) {
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        this.interrupted = false;
        this.assureMemory(REQUIRED_PER_ITERATION, true);
        this.suggestionsCounter = 0;
        try {
            int n;
            this.list = suggestionList;
            this.workaround38476 = true;
            this.scanPreferred(containerArray, bl);
            this.workaround38476 = false;
            if (this.progressMonitor != null) {
                n = -1;
                this.progressMonitor.estimate(n);
                for (int i = 0; i < containerArray.length; ++i) {
                    FileObject fileObject = ((DataObject)containerArray[i]).getPrimaryFile();
                    n += SuggestionsScanner.countFolders(fileObject);
                }
                this.progressMonitor.estimate(n);
                this.progressMonitor.scanStarted();
            }
            for (n = 0; n < containerArray.length; ++n) {
                if (this.shouldStop()) {
                    return;
                }
                DataObject.Container container = containerArray[n];
                this.scanFolder(container, bl);
            }
        }
        finally {
            this.scanned.clear();
        }
    }

    static TopComponent[] openedTopComponents() {
        final Object[] objectArray = new Object[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                Mode mode = WindowManager.getDefault().findMode("editor");
                if (mode == null) {
                    return new TopComponent[0];
                }
                return mode.getTopComponents();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Mode mode = WindowManager.getDefault().findMode("editor");
                    objectArray[0] = mode == null ? new TopComponent[0] : mode.getTopComponents();
                }
            });
            return (TopComponent[])objectArray[0];
        }
        catch (InterruptedException interruptedException) {
            return new TopComponent[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            return new TopComponent[0];
        }
    }

    private void scanPreferred(DataObject.Container[] containerArray, boolean bl) {
        TopComponent[] topComponentArray = SuggestionsScanner.openedTopComponents();
        DataObject[] dataObjectArray = null;
        block0: for (int i = 0; i < topComponentArray.length; ++i) {
            Node[] nodeArray = topComponentArray[i].getActivatedNodes();
            if (nodeArray == null) continue;
            for (int j = 0; j < nodeArray.length; ++j) {
                DataObject dataObject = (DataObject)nodeArray[j].getCookie(class$org$openide$loaders$DataObject == null ? SuggestionsScanner.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) continue;
                if (dataObjectArray == null) {
                    HashSet<DataObject> hashSet = new HashSet<DataObject>();
                    for (int k = 0; k < containerArray.length; ++k) {
                        DataObject[] dataObjectArray2 = containerArray[k].getChildren();
                        for (int i2 = 0; i2 < dataObjectArray2.length; ++i2) {
                            hashSet.add(dataObjectArray2[i2]);
                        }
                    }
                    dataObjectArray = hashSet.toArray(new DataObject[hashSet.size()]);
                }
                this.scanPreferred(dataObject, dataObjectArray, bl);
                continue block0;
            }
        }
    }

    private void scanPreferred(DataObject dataObject, DataObject[] dataObjectArray, boolean bl) {
        FileObject fileObject = dataObject.getPrimaryFile();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            FileObject fileObject2 = dataObjectArray[i].getPrimaryFile();
            if (!fileObject2.equals(fileObject) && !(bl ? FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) : fileObject.getParent().equals(fileObject2))) continue;
            this.scanLeaf(dataObject);
            this.scanned.add(dataObject);
            break;
        }
    }

    private void scanFolder(DataObject.Container container, boolean bl) {
        DataObject[] dataObjectArray = container.getChildren();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (this.shouldStop()) {
                return;
            }
            DataObject dataObject = dataObjectArray[i];
            if (dataObject instanceof DataObject.Container) {
                String string;
                if (!bl || "CVS".equals(string = dataObject.getPrimaryFile().getNameExt()) || "SCCS".equals(string) || ".svn".equals(string)) continue;
                if (this.progressMonitor == null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$SuggestionsScanner == null ? SuggestionsScanner.class$("org.netbeans.modules.tasklist.suggestions.SuggestionsScanner") : class$org$netbeans$modules$tasklist$suggestions$SuggestionsScanner), (String)"ScanningFolder", (Object)dataObject.getPrimaryFile().getNameExt()));
                } else {
                    this.progressMonitor.folderEntered(dataObject.getPrimaryFile());
                }
                this.scanFolder((DataObject.Container)dataObject, true);
                if (this.progressMonitor == null) continue;
                this.progressMonitor.folderScanned(dataObject.getPrimaryFile());
                continue;
            }
            this.scanLeaf(dataObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized List scanTopComponent(TopComponent topComponent, ProviderAcceptor providerAcceptor) {
        List list = Collections.EMPTY_LIST;
        try {
            this.cummulateInList = new LinkedList();
            this.progressMonitor = null;
            this.scanned.clear();
            this.workaround38476 = topComponent.isOpened();
            this.suggestionsCounter = 0;
            this.interrupted = false;
            this.typeFilter = providerAcceptor;
            Node[] nodeArray = topComponent.getActivatedNodes();
            if (nodeArray == null) {
                List list2 = list;
                return list2;
            }
            int n = 0;
            if (n < nodeArray.length) {
                DataObject dataObject = (DataObject)nodeArray[n].getCookie(DataObject.class);
                if (dataObject == null) {
                    List list3 = list;
                    return list3;
                }
                this.scanLeaf(dataObject);
            }
            list = this.cummulateInList;
        }
        finally {
            this.cummulateInList = null;
            this.typeFilter = null;
        }
        return list;
    }

    private void scanLeaf(DataObject dataObject) {
        if (!dataObject.isValid()) {
            return;
        }
        if (this.scanned.contains(dataObject)) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (!VisibilityQuery.getDefault().isVisible(fileObject)) {
            return;
        }
        String string = fileObject.getExt();
        boolean bl = "java".equals(string) || "properties".equals(string);
        boolean bl2 = editorCookie.getDocument() == null && !bl;
        SuggestionContext suggestionContext = SPIHole.createSuggestionContext((DataObject)dataObject);
        this.scanLeaf(suggestionContext);
        if (bl2 && editorCookie.getOpenedPanes() == null && !this.workaround38476) {
            editorCookie.close();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.fileScanned(dataObject.getPrimaryFile());
        }
    }

    private void scanLeaf(SuggestionContext suggestionContext) {
        List list = this.registry.getProviders();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (this.interrupted) {
                return;
            }
            this.interrupted = Thread.interrupted();
            SuggestionProvider suggestionProvider = (SuggestionProvider)listIterator.next();
            if (!$assertionsDisabled && this.typeFilter == null) {
                throw new AssertionError();
            }
            if (!this.typeFilter.accept(suggestionProvider) || !(suggestionProvider instanceof DocumentSuggestionProvider)) continue;
            List list2 = null;
            String string = null;
            try {
                string = suggestionProvider.getType();
                list2 = ((DocumentSuggestionProvider)suggestionProvider).scan(suggestionContext);
            }
            catch (RuntimeException runtimeException) {
                ErrorManager.getDefault().annotate((Throwable)runtimeException, "Skipping faulty provider (" + suggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Error error) {
                ErrorManager.getDefault().annotate((Throwable)error, "Skipping faulty provider (" + suggestionProvider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)error);
            }
            if (list2 == null || list2.size() <= 0) continue;
            this.suggestionsCounter += list2.size();
            if (this.cummulateInList == null) {
                this.manager.register(string, list2, null, this.list, true);
                continue;
            }
            this.cummulateInList.addAll(list2);
        }
    }

    private void assureMemory(int n, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.maxMemory();
        long l3 = Math.max(l / 13L, (long)(n + REQUIRED_PER_FULL_GC));
        if (l == l2 && runtime.freeMemory() < l3) {
            if (bl) {
                try {
                    byte[] byArray = new byte[(int)l3];
                    byArray[0] = 75;
                    byArray = null;
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.handleNoMemory();
                }
            } else {
                lowMemoryWarning = true;
            }
        } else if (lowMemoryWarning) {
            lowMemoryWarning = false;
            ++lowMemoryWarningCount;
        }
        if (lowMemoryWarningCount > 7 || l == l2 && runtime.freeMemory() < (long)REQUIRED_PER_FULL_GC) {
            this.handleNoMemory();
        }
    }

    private void handleNoMemory() {
        this.interrupted = true;
        if (this.progressMonitor != null) {
            this.progressMonitor.scanTerminated(-1);
        }
    }

    private boolean shouldStop() {
        if (this.interrupted) {
            return true;
        }
        this.interrupted = Thread.interrupted();
        if (this.interrupted) {
            return true;
        }
        this.assureMemory(REQUIRED_PER_ITERATION, false);
        if (this.interrupted) {
            return true;
        }
        if (this.suggestionsCounter > this.getCountLimit()) {
            this.interrupted = true;
            if (this.progressMonitor != null) {
                this.progressMonitor.scanTerminated(-3);
            }
        }
        return this.interrupted;
    }

    private int getCountLimit() {
        return this.usabilityLimit;
    }

    private static int countFolders(FileObject fileObject) {
        int n = 0;
        if (Thread.currentThread().isInterrupted()) {
            return n;
        }
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            String string = fileObject2.getNameExt();
            if ("CVS".equals(string) || "SCCS".equals(string) || ".svn".equals(string)) continue;
            ++n;
            n += SuggestionsScanner.countFolders(fileObject2);
        }
        return n;
    }

    public boolean cancel() {
        this.interrupted = true;
        if (this.progressMonitor != null) {
            this.progressMonitor.scanTerminated(-2);
        }
        return true;
    }

    public void setUsabilityLimit(int n) {
        this.usabilityLimit = n;
    }

    static {
        $assertionsDisabled = !SuggestionsScanner.class.desiredAssertionStatus();
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        MB = 0x100000;
        REQUIRED_PER_ITERATION = 2 * MB;
        REQUIRED_PER_FULL_GC = 7 * MB;
    }

    public static interface ScanProgress {
        public void estimate(int var1);

        public void scanStarted();

        public void folderEntered(FileObject var1);

        public void fileScanned(FileObject var1);

        public void folderScanned(FileObject var1);

        public void scanFinished();

        public void scanTerminated(int var1);
    }
}

