/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class TypesCustomizer
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTable typesTable;
    private JScrollPane jScrollPane1;
    private JTextArea descTextArea;
    private JLabel activeLabel;
    private JLabel typeDescLabel;
    private JScrollPane jScrollPane3;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$suggestions$TypesCustomizer$SuggTypesTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TypesCustomizer() {
        this.initComponents();
        this.initA11y();
        this.typesTable.setSelectionMode(0);
        this.typesTable.setModel(new SuggTypesTableModel());
        TableColumnModel tableColumnModel = this.typesTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(50);
        tableColumnModel.getColumn(2).setPreferredWidth(300);
        this.typesTable.getSelectionModel().addListSelectionListener(this);
        this.typesTable.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void initComponents() {
        this.activeLabel = new JLabel();
        this.typeDescLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.descTextArea = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.typesTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.activeLabel.setLabelFor(this.typesTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.activeLabel, gridBagConstraints);
        this.typeDescLabel.setLabelFor(this.descTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.typeDescLabel, gridBagConstraints);
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setPreferredSize(new Dimension(400, 100));
        this.jScrollPane1.setViewportView(this.descTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.typesTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane3, gridBagConstraints);
    }

    private void initA11y() {
        Mnemonics.setLocalizedText((JLabel)this.activeLabel, (String)NbBundle.getMessage((Class)TypesCustomizer.class, (String)"ActiveTypes"));
        Mnemonics.setLocalizedText((JLabel)this.typeDescLabel, (String)NbBundle.getMessage((Class)TypesCustomizer.class, (String)"TypeDesc"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TypesCustomizer.class, (String)"ACSD_TypesCustomizer"));
        this.typesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TypesCustomizer.class, (String)"ACSD_Enabled"));
        this.descTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TypesCustomizer.class, (String)"ACSD_TypeDesc"));
    }

    public void apply() {
        SuggTypesTableModel suggTypesTableModel = (SuggTypesTableModel)this.typesTable.getModel();
        suggTypesTableModel.save();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.typesTable.getSelectedRow();
        if (n < 0) {
            this.descTextArea.setText("");
        } else {
            SuggTypesTableModel suggTypesTableModel = (SuggTypesTableModel)this.typesTable.getModel();
            this.descTextArea.setText(suggTypesTableModel.getType(n).getDescription());
        }
    }

    private static class SuggTypesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static String[] columnNames;
        private SuggestionType[] types;
        private boolean[] enabled;
        private boolean[] confirm;

        public SuggTypesTableModel() {
            Collection collection = SuggestionTypes.getDefault().getAllTypes();
            Iterator iterator = collection.iterator();
            SuggestionManagerImpl suggestionManagerImpl = (SuggestionManagerImpl)SuggestionManager.getDefault();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            this.types = arrayList.toArray(new SuggestionType[arrayList.size()]);
            this.enabled = new boolean[arrayList.size()];
            this.confirm = new boolean[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                SuggestionType suggestionType = (SuggestionType)arrayList.get(i);
                this.enabled[i] = suggestionManagerImpl.isEnabled(suggestionType.getName());
                this.confirm[i] = suggestionManagerImpl.isConfirm(suggestionType);
            }
        }

        public void save() {
            SuggestionManagerImpl suggestionManagerImpl = (SuggestionManagerImpl)SuggestionManager.getDefault();
            for (int i = 0; i < this.types.length; ++i) {
                suggestionManagerImpl.setEnabled(this.types[i].getName(), this.enabled[i], true);
                suggestionManagerImpl.setConfirm(this.types[i], this.confirm[i], i != this.types.length - 1);
            }
        }

        public SuggestionType getType(int n) {
            return this.types[n];
        }

        public boolean getConfirmation(int n) {
            return this.confirm[n];
        }

        public void setConfirmation(int n, boolean bl) {
            this.confirm[n] = bl;
            this.fireTableCellUpdated(n, 1);
        }

        public int getRowCount() {
            return this.types.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return class$java$lang$String == null ? (class$java$lang$String = TypesCustomizer.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypesCustomizer.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 2;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.enabled[n] ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return this.confirm[n] ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return this.types[n].getLocalizedName();
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.enabled[n] = (Boolean)object;
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
                case 1: {
                    this.confirm[n] = (Boolean)object;
                    this.fireTableCellUpdated(n, n2);
                }
            }
        }

        static {
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$tasklist$suggestions$TypesCustomizer$SuggTypesTableModel == null ? (class$org$netbeans$modules$tasklist$suggestions$TypesCustomizer$SuggTypesTableModel = TypesCustomizer.class$("org.netbeans.modules.tasklist.suggestions.TypesCustomizer$SuggTypesTableModel")) : class$org$netbeans$modules$tasklist$suggestions$TypesCustomizer$SuggTypesTableModel));
            columnNames = new String[]{resourceBundle.getString("Active"), resourceBundle.getString("Confirmation"), resourceBundle.getString("Name")};
        }
    }
}

