/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions.settings;

import java.beans.IntrospectionException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ManagerSettings
implements Node.Handle {
    private static final long serialVersionUID = 1L;
    public static final String AFTER_OPEN_SCAN_DELAY = "showScanDelay";
    public static final String AFTER_EDIT_SCAN_DELAY = "editScanDelay";
    public static final String AFTER_SAVE_SCAN_DELAY = "saveScanDelay";
    private int showScanDelay = 500;
    private int editScanDelay = 1000;
    private int saveScanDelay = 1000;
    private static final int DEFAULT_SHOW_SCAN_DELAY = 500;
    private static final int DEFAULT_EDIT_SCAN_DELAY = 1000;
    private static final int DEFAULT_SAVE_SCAN_DELAY = 1000;
    private static final boolean DEFAULT_SCAN_ON_SHOW = true;
    private static final boolean DEFAULT_SCAN_ON_EDIT = true;
    private static final boolean DEFAULT_SCAN_ON_SAVE = false;
    private boolean registryRead = false;
    private Set disabled = null;
    private Set noconfirm = null;
    private Set expandedTypes = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ManagerSettings() {
    }

    public static ManagerSettings getDefault() {
        ManagerSettings managerSettings = (ManagerSettings)Lookup.getDefault().lookup(ManagerSettings.class);
        if (!$assertionsDisabled && managerSettings == null) {
            throw new AssertionError((Object)"#45809 default lookup has failed to locate ...suggestions.settings.ManagerSettings!");
        }
        return managerSettings;
    }

    public static ManagerSettings layerEntryPoint() {
        return new ManagerSettings();
    }

    public void store() {
        this.writeTypeRegistry();
    }

    public int getShowScanDelay() {
        return this.showScanDelay;
    }

    public void setShowScanDelay(int n) {
        if (n < 0) {
            n = 500;
        }
        this.showScanDelay = n;
    }

    public int getEditScanDelay() {
        return this.editScanDelay;
    }

    public void setEditScanDelay(int n) {
        if (n < 0) {
            n = 1000;
        }
        this.editScanDelay = n;
    }

    public int getSaveScanDelay() {
        return this.saveScanDelay;
    }

    public void setSaveScanDelay(int n) {
        if (n < 0) {
            n = 500;
        }
        this.saveScanDelay = n;
    }

    public boolean isScanOnShow() {
        return this.getShowScanDelay() != 0;
    }

    public boolean isScanOnEdit() {
        return this.getEditScanDelay() != 0;
    }

    public boolean isScanOnSave() {
        return this.getSaveScanDelay() != 0;
    }

    private File getRegistryFile(boolean bl) {
        String string = System.getProperty("netbeans.user") + File.separatorChar + "system" + File.separatorChar + "TaskList" + File.separatorChar + "suggestiontype-registry.xml";
        File file = new File(string);
        if (bl && !file.exists()) {
            File file2 = file.getParentFile();
            file2.mkdirs();
        }
        return file;
    }

    private boolean readTypeRegistry() {
        if (this.registryRead) {
            return true;
        }
        this.registryRead = true;
        File file = this.getRegistryFile(false);
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false);
                    TypeXMLHandler typeXMLHandler = new TypeXMLHandler();
                    xMLReader.setContentHandler(typeXMLHandler);
                    xMLReader.setErrorHandler(typeXMLHandler);
                    xMLReader.setEntityResolver(typeXMLHandler);
                    xMLReader.parse(new InputSource(bufferedReader));
                    this.disabled = typeXMLHandler.getDisabled();
                    this.noconfirm = typeXMLHandler.getNoConfirm();
                    this.expandedTypes = typeXMLHandler.getExpanded();
                    this.showScanDelay = typeXMLHandler.getShowScanDelay();
                    this.editScanDelay = typeXMLHandler.getEditScanDelay();
                    this.saveScanDelay = typeXMLHandler.getSaveScanDelay();
                    return true;
                }
                catch (SAXException sAXException) {
                    ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                    ((Reader)bufferedReader).close();
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return false;
    }

    public synchronized boolean isEnabled(String string) {
        if (this.disabled == null) {
            this.readTypeRegistry();
            if (this.disabled == null) {
                this.disabled = new HashSet(40);
            }
        }
        return !this.disabled.contains(string);
    }

    boolean writeTypeRegistry() {
        File file = this.getRegistryFile(true);
        try {
            Object object;
            Iterator iterator;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\"?>\n");
            bufferedWriter.write("<!DOCTYPE suggestionregistry PUBLIC '-//NetBeans//DTD suggestion registry 1.0//EN' 'http://www.netbeans.org/dtds/suggestion-registry-1_0.dtd'>\n");
            bufferedWriter.write("<typeregistry>\n");
            if (this.disabled != null && (iterator = this.disabled.iterator()).hasNext()) {
                bufferedWriter.write("  <disabled>\n");
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    bufferedWriter.write("    <type id=\"");
                    bufferedWriter.write((String)object);
                    bufferedWriter.write("\"/>\n");
                }
                bufferedWriter.write("  </disabled>\n");
            }
            if (this.noconfirm != null && (iterator = this.noconfirm.iterator()).hasNext()) {
                bufferedWriter.write("  <noconfirm>\n");
                while (iterator.hasNext()) {
                    object = (SuggestionType)iterator.next();
                    bufferedWriter.write("    <type id=\"");
                    bufferedWriter.write(((SuggestionType)object).getName());
                    bufferedWriter.write("\"/>\n");
                }
                bufferedWriter.write("  </noconfirm>\n");
            }
            if (this.expandedTypes != null && (iterator = this.expandedTypes.iterator()).hasNext()) {
                bufferedWriter.write("  <expanded>\n");
                while (iterator.hasNext()) {
                    object = (SuggestionType)iterator.next();
                    bufferedWriter.write("    <type id=\"");
                    bufferedWriter.write(((SuggestionType)object).getName());
                    bufferedWriter.write("\"/>\n");
                }
                bufferedWriter.write("  </expanded>\n");
            }
            if (!this.isScanOnShow() || this.showScanDelay != 500) {
                bufferedWriter.write("  <scan-preference event=\"show\" enabled=\"");
                bufferedWriter.write(this.isScanOnShow() ? "on" : "off");
                bufferedWriter.write("\" delay=\"");
                bufferedWriter.write(Integer.toString(this.showScanDelay));
                bufferedWriter.write("\"/>\n");
            }
            if (!this.isScanOnEdit() || this.editScanDelay != 1000) {
                bufferedWriter.write("  <scan-preference event=\"edit\" enabled=\"");
                bufferedWriter.write(this.isScanOnEdit() ? "on" : "off");
                bufferedWriter.write("\" delay=\"");
                bufferedWriter.write(Integer.toString(this.editScanDelay));
                bufferedWriter.write("\"/>\n");
            }
            if (this.isScanOnSave() || this.saveScanDelay != 1000) {
                bufferedWriter.write("  <scan-preference event=\"save\" enabled=\"");
                bufferedWriter.write(this.isScanOnSave() ? "on" : "off");
                bufferedWriter.write("\" delay=\"");
                bufferedWriter.write(Integer.toString(this.saveScanDelay));
                bufferedWriter.write("\"/>\n");
            }
            bufferedWriter.write("</typeregistry>\n");
            ((Writer)bufferedWriter).close();
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return false;
        }
    }

    public synchronized void setEnabled(String string, boolean bl) {
        if (this.disabled == null) {
            this.disabled = new HashSet(40);
        }
        if (bl) {
            this.disabled.remove(string);
        } else {
            this.disabled.add(string);
        }
    }

    public synchronized boolean isConfirm(SuggestionType suggestionType) {
        if (this.noconfirm == null) {
            this.readTypeRegistry();
            if (this.noconfirm == null) {
                this.noconfirm = new HashSet(40);
            }
        }
        return !this.noconfirm.contains(suggestionType);
    }

    public synchronized void setConfirm(SuggestionType suggestionType, boolean bl) {
        if (this.noconfirm == null) {
            this.noconfirm = new HashSet(40);
        }
        if (bl) {
            this.noconfirm.remove(suggestionType);
        } else {
            this.noconfirm.add(suggestionType);
        }
    }

    public boolean isExpandedType(SuggestionType suggestionType) {
        this.readTypeRegistry();
        if (this.expandedTypes == null) {
            return suggestionType.getName() == "nb-java-errors";
        }
        return this.expandedTypes.contains(suggestionType);
    }

    public void setExpandedType(SuggestionType suggestionType, boolean bl) {
        this.readTypeRegistry();
        if (this.expandedTypes == null) {
            this.expandedTypes = new HashSet(2 * SuggestionTypes.getDefault().getCount());
            SuggestionType suggestionType2 = SuggestionTypes.getDefault().getType("nb-java-errors");
            if (suggestionType2 != null) {
                this.expandedTypes.add(suggestionType2);
            }
        }
        if (bl) {
            this.expandedTypes.add(suggestionType);
        } else {
            this.expandedTypes.remove(suggestionType);
        }
    }

    public Node getNode() throws IOException {
        try {
            BeanNode beanNode = new BeanNode((Object)ManagerSettings.getDefault());
            return beanNode;
        }
        catch (IntrospectionException introspectionException) {
            IOException iOException = new IOException();
            iOException.initCause(introspectionException);
            throw iOException;
        }
    }

    static {
        $assertionsDisabled = !ManagerSettings.class.desiredAssertionStatus();
    }

    private static class TypeXMLHandler
    extends DefaultHandler {
        private boolean parsingDisabled = false;
        private boolean parsingNoConfirm = false;
        private boolean parsingExpanded = false;
        private Set disabled = null;
        private Set noconfirm = null;
        private Set expanded = null;
        private int showScanDelay = 500;
        private int editScanDelay = 1000;
        private int saveScanDelay = 1000;
        private boolean scanOnShow = true;
        private boolean scanOnEdit = true;
        private boolean scanOnSave = false;

        TypeXMLHandler() {
        }

        public Set getDisabled() {
            return this.disabled;
        }

        public Set getNoConfirm() {
            return this.noconfirm;
        }

        public Set getExpanded() {
            return this.expanded;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("type")) {
                if (this.parsingDisabled) {
                    String string4 = attributes.getValue("id");
                    if (this.disabled == null) {
                        this.disabled = new HashSet(50);
                    }
                    this.disabled.add(string4);
                } else if (this.parsingNoConfirm) {
                    String string5 = attributes.getValue("id");
                    if (this.noconfirm == null) {
                        this.noconfirm = new HashSet(50);
                    }
                    SuggestionType suggestionType = SuggestionTypes.getDefault().getType(string5);
                    this.noconfirm.add(suggestionType);
                } else if (this.parsingExpanded) {
                    String string6 = attributes.getValue("id");
                    if (this.expanded == null) {
                        this.expanded = new HashSet(50);
                    }
                    SuggestionType suggestionType = SuggestionTypes.getDefault().getType(string6);
                    this.expanded.add(suggestionType);
                } else {
                    ErrorManager.getDefault().log(16, "SuggestionType Registry Parsing Error: " + string3 + ", " + attributes);
                }
            } else if (string3.equals("disabled")) {
                this.parsingDisabled = true;
            } else if (string3.equals("noconfirm")) {
                this.parsingNoConfirm = true;
            } else if (string3.equals("expanded")) {
                this.parsingExpanded = true;
            } else if (string3.equals("scan-preference")) {
                String string7 = attributes.getValue("event");
                String string8 = attributes.getValue("enabled");
                String string9 = attributes.getValue("delay");
                if (string7 == null || string8 == null || string9 == null) {
                    ErrorManager.getDefault().log(16, "Got scan-preference event=" + string7 + ", enabled=" + string8 + ", " + string9);
                    return;
                }
                boolean bl = "on".equals(string8);
                int n = -1;
                try {
                    n = Integer.parseInt(string9);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if ("show".equals(string7)) {
                    this.scanOnShow = bl;
                    this.showScanDelay = n;
                } else if ("save".equals(string7)) {
                    this.scanOnSave = bl;
                    this.saveScanDelay = n;
                } else if ("edit".equals(string7)) {
                    this.scanOnEdit = bl;
                    this.editScanDelay = n;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("disabled")) {
                this.parsingDisabled = false;
            } else if (string3.equals("noconfirm")) {
                this.parsingNoConfirm = false;
            } else if (string3.equals("expanded")) {
                this.parsingExpanded = false;
            }
        }

        public int getShowScanDelay() {
            return this.showScanDelay;
        }

        public int getEditScanDelay() {
            return this.editScanDelay;
        }

        public int getSaveScanDelay() {
            return this.saveScanDelay;
        }

        public boolean isScanOnShow() {
            return this.scanOnShow;
        }

        public boolean isScanOnEdit() {
            return this.scanOnEdit;
        }

        public boolean isScanOnSave() {
            return this.scanOnSave;
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

