/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;

abstract class OverviewPanel
extends PlotterPanel {
    private static final Dimension PREFERRED_PLOTTER_SIZE = new Dimension(300, 200);
    private static final Dimension MINIMUM_PLOTTER_SIZE = new Dimension(200, 150);
    static final int VIEW_RANGE = -1;
    static Color PLOTTER_COLOR = JConsole.IS_GTK ? new Color(231, 111, 80) : null;
    private JLabel infoLabel;

    public OverviewPanel(String string) {
        this(string, null, null, null);
    }

    public OverviewPanel(String string, String string2, String string3, Plotter.Unit unit) {
        super(string);
        this.setLayout(new BorderLayout(0, 0));
        if (string2 != null && string3 != null) {
            Plotter plotter = new Plotter();
            plotter.setPreferredSize(PREFERRED_PLOTTER_SIZE);
            plotter.setMinimumSize(MINIMUM_PLOTTER_SIZE);
            plotter.setViewRange(-1);
            if (unit != null) {
                plotter.setUnit(unit);
            }
            plotter.createSequence(string2, string3, PLOTTER_COLOR, true);
            Utilities.setAccessibleName(plotter, Resources.getText("OverviewPanel.plotter.accessibleName", string));
            this.setPlotter(plotter);
        }
    }

    public JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel("", 0){

                public void setText(String string) {
                    if (string.startsWith("<html>")) {
                        StringBuilder stringBuilder = new StringBuilder();
                        char[] cArray = string.toCharArray();
                        int n = cArray.length;
                        for (int i = 0; i < n; ++i) {
                            if (cArray[i] == ' ' && (i < n - 1 && cArray[i + 1] == ' ' || (i == 0 || cArray[i - 1] != ' ') && (i == n - 1 || cArray[i + 1] != ' '))) {
                                stringBuilder.append("&nbsp;");
                                continue;
                            }
                            stringBuilder.append(cArray[i]);
                        }
                        string = stringBuilder.toString();
                    }
                    super.setText(string);
                }
            };
            if (JConsole.IS_GTK) {
                JPanel jPanel = new JPanel(new BorderLayout());
                JSeparator jSeparator = new JSeparator(0);
                jPanel.add((Component)jSeparator, "North");
                jPanel.add((Component)this.infoLabel, "South");
                this.add((Component)jPanel, "South");
            } else {
                this.add((Component)this.infoLabel, "South");
            }
        }
        return this.infoLabel;
    }
}

