/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.JSR45DebuggerEngineProvider;
import org.netbeans.modules.debugger.jpda.JavaEngineProvider;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.modules.debugger.jpda.models.ObjectTranslation;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.ErrorManager;

public class JPDADebuggerImpl
extends JPDADebugger {
    private static final boolean startVerbose = System.getProperty("netbeans.debugger.start") != null;
    private VirtualMachine virtualMachine = null;
    private Exception exception;
    private Thread startingThread;
    private int state = 0;
    private Operator operator;
    private PropertyChangeSupport pcs;
    private JPDAThreadImpl currentThread;
    private CallStackFrame currentCallStackFrame;
    private int suspend = 2;
    public final Object LOCK = new Object();
    private final Object LOCK2 = new Object();
    private boolean starting;
    private JavaEngineProvider javaEngineProvider;
    private Set languages;
    private String lastStratumn;
    private ContextProvider lookupProvider;
    private ObjectTranslation threadsTranslation;
    private ObjectTranslation localsTranslation;
    private StackFrame altCSF = null;
    private Boolean canBeModified;
    private Object canBeModifiedLock = new Object();
    private SmartSteppingFilter smartSteppingFilter;
    private InvalidExpressionException methodCallsUnsupportedExc;
    private static final Pattern jvmVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?(-\\w+)?");
    private static Method tcGenericSignatureMethod;
    private static Method lvGenericSignatureMethod;
    private SourcePath engineContext;
    private LocalsTreeModel localsTreeModel;
    private Set jsr45EngineProviders;

    public JPDADebuggerImpl(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.pcs = new PropertyChangeSupport((Object)this);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof JavaEngineProvider)) continue;
            this.javaEngineProvider = (JavaEngineProvider)((Object)list.get(i));
        }
        if (this.javaEngineProvider == null) {
            throw new IllegalArgumentException("JavaEngineProvider have to be used to start JPDADebugger!");
        }
        this.languages = new HashSet();
        this.languages.add("Java");
        this.threadsTranslation = ObjectTranslation.createThreadTranslation(this);
        this.localsTranslation = ObjectTranslation.createLocalsTranslation(this);
    }

    public int getState() {
        return this.state;
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        if (n == this.suspend) {
            return;
        }
        int n2 = this.suspend;
        this.suspend = n;
        this.firePropertyChange("suspend", new Integer(n2), new Integer(n));
    }

    public JPDAThread getCurrentThread() {
        return this.currentThread;
    }

    public synchronized CallStackFrame getCurrentCallStackFrame() {
        if (this.currentCallStackFrame != null) {
            try {
                if (!this.currentCallStackFrame.getThread().isSuspended()) {
                    this.currentCallStackFrame = null;
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                this.currentCallStackFrame = null;
            }
        }
        if (this.currentCallStackFrame == null && this.currentThread != null) {
            try {
                this.currentCallStackFrame = this.currentThread.getCallStack()[0];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.currentCallStackFrame;
    }

    public Variable evaluate(String string) throws InvalidExpressionException {
        Value value = this.evaluateIn(string);
        return this.getLocalsTreeModel().getVariable(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRunning() throws DebuggerStartException {
        Object object = this.LOCK2;
        synchronized (object) {
            if (this.getState() == 4) {
                if (this.exception != null) {
                    throw new DebuggerStartException((Throwable)this.exception);
                }
                return;
            }
            if (!this.starting && this.state != 1) {
                return;
            }
            try {
                this.LOCK2.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new DebuggerStartException((Throwable)interruptedException);
            }
            if (this.exception != null) {
                throw new DebuggerStartException((Throwable)this.exception);
            }
            return;
        }
    }

    public boolean canPopFrames() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return virtualMachine.canPopFrames();
    }

    public boolean canFixClasses() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return virtualMachine.canRedefineClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixClasses(Map map) {
        Object object = this.LOCK;
        synchronized (object) {
            DebuggerEngine debuggerEngine;
            String string;
            HashMap hashMap = new HashMap();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                debuggerEngine = this.getVirtualMachine().classesByName(string);
                int n = debuggerEngine.size();
                for (int i = 0; i < n; ++i) {
                    hashMap.put((ReferenceType)debuggerEngine.get(i), map.get(string));
                }
            }
            this.getVirtualMachine().redefineClasses(hashMap);
            string = (Session)this.lookupProvider.lookupFirst(null, Session.class);
            debuggerEngine = string.getEngineForLanguage("Java");
            BreakpointsEngineListener breakpointsEngineListener = (BreakpointsEngineListener)debuggerEngine.lookupFirst(null, LazyActionsManagerListener.class);
            breakpointsEngineListener.fixBreakpointImpls();
            JPDAThread jPDAThread = this.getCurrentThread();
            if (jPDAThread != null && jPDAThread.isSuspended()) {
                CallStackFrame callStackFrame = this.getCurrentCallStackFrame();
                if (jPDAThread.getStackDepth() < 2 && callStackFrame.isObsolete()) {
                    return;
                }
                try {
                    if (!callStackFrame.equals(jPDAThread.getCallStack(0, 1)[0])) {
                        return;
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    return;
                }
                if (callStackFrame.isObsolete() && ((CallStackFrameImpl)callStackFrame).canPop()) {
                    callStackFrame.popFrame();
                    this.setState(2);
                    this.updateCurrentCallStackFrame(jPDAThread);
                    this.setState(3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeModified() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        Object object = this.canBeModifiedLock;
        synchronized (object) {
            if (this.canBeModified == null) {
                try {
                    Method method = VirtualMachine.class.getMethod("canBeModified", new Class[0]);
                    Object object2 = method.invoke((Object)virtualMachine, new Object[0]);
                    this.canBeModified = (Boolean)object2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.canBeModified = Boolean.TRUE;
                }
            }
            return this.canBeModified;
        }
    }

    public SmartSteppingFilter getSmartSteppingFilter() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
            this.smartSteppingFilter.addExclusionPatterns((Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        }
        return this.smartSteppingFilter;
    }

    public void fireBreakpointEvent(JPDABreakpoint jPDABreakpoint, JPDABreakpointEvent jPDABreakpointEvent) {
        super.fireBreakpointEvent(jPDABreakpoint, jPDABreakpointEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(ThreadReference threadReference, StackFrame stackFrame) {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                threadReference.popFrames(stackFrame);
                this.setState(2);
                this.updateCurrentCallStackFrame(this.getThread(threadReference));
                this.setState(3);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                incompatibleThreadStateException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception exception) {
        Object object = this.LOCK2;
        synchronized (object) {
            this.exception = exception;
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    public void setCurrentThread(JPDAThread jPDAThread) {
        JPDAThreadImpl jPDAThreadImpl = this.currentThread;
        this.currentThread = (JPDAThreadImpl)jPDAThread;
        if (jPDAThread != jPDAThreadImpl) {
            this.pcs.firePropertyChange("currentThread", jPDAThreadImpl, this.currentThread);
        }
        this.updateCurrentCallStackFrame(jPDAThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2;
        JPDADebuggerImpl jPDADebuggerImpl = this;
        synchronized (jPDADebuggerImpl) {
            if (callStackFrame == this.currentCallStackFrame) {
                return;
            }
            callStackFrame2 = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        this.pcs.firePropertyChange("currentCallStackFrame", callStackFrame2, callStackFrame);
    }

    public Value evaluateIn(String string) throws InvalidExpressionException {
        Expression expression = null;
        try {
            expression = Expression.parse(string, "1.5.0");
            return this.evaluateIn(expression);
        }
        catch (ParseException parseException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException(parseException.getMessage());
            invalidExpressionException.initCause((Throwable)parseException);
            throw invalidExpressionException;
        }
    }

    public void setAltCSF(StackFrame stackFrame) {
        this.altCSF = stackFrame;
    }

    public StackFrame getAltCSF() {
        return this.altCSF;
    }

    public Value evaluateIn(Expression expression) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.getCurrentCallStackFrame();
            if (callStackFrameImpl != null) {
                try {
                    return this.evaluateIn(expression, callStackFrameImpl.getStackFrame());
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    return null;
                }
            }
            if (this.altCSF != null) {
                try {
                    if (this.altCSF.thread().isSuspended()) {
                        return this.evaluateIn(expression, this.altCSF);
                    }
                    this.altCSF = null;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.altCSF = null;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    return null;
                }
            }
            throw new InvalidExpressionException("No current context (stack frame)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value evaluateIn(Expression expression, final StackFrame stackFrame) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            if (stackFrame == null) {
                throw new InvalidExpressionException("No current context");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList arrayList2 = new ArrayList();
            arrayList.add("java.lang.*");
            try {
                Value value;
                JPDAThreadImpl[] jPDAThreadImplArray;
                List[] listArray;
                block13: {
                    arrayList.addAll(Arrays.asList(EditorContextBridge.getImports(this.getEngineContext().getURL(stackFrame, "Java"))));
                    listArray = new List[]{null};
                    jPDAThreadImplArray = new JPDAThreadImpl[]{null};
                    EvaluationContext evaluationContext = new EvaluationContext(stackFrame, arrayList, arrayList2, this.methodCallsUnsupportedExc == null, new Runnable(){

                        public void run() {
                            if (listArray[0] == null) {
                                listArray[0] = JPDADebuggerImpl.this.disableAllBreakpoints();
                                ThreadReference threadReference = stackFrame.thread();
                                jPDAThreadImplArray[0] = (JPDAThreadImpl)JPDADebuggerImpl.this.getThread(threadReference);
                                jPDAThreadImplArray[0].notifyToBeRunning();
                            }
                        }
                    });
                    Evaluator evaluator = expression.evaluator(evaluationContext);
                    try {
                        value = evaluator.evaluate();
                        Object var12_15 = null;
                        if (this.methodCallsUnsupportedExc != null || evaluationContext.canInvokeMethods()) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (this.methodCallsUnsupportedExc == null && !evaluationContext.canInvokeMethods()) {
                            this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                        }
                        if (listArray[0] != null) {
                            this.enableAllBreakpoints(listArray[0]);
                        }
                        if (jPDAThreadImplArray[0] != null) {
                            jPDAThreadImplArray[0].notifySuspended();
                        }
                        throw throwable;
                    }
                    this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                }
                if (listArray[0] != null) {
                    this.enableAllBreakpoints(listArray[0]);
                }
                if (jPDAThreadImplArray[0] != null) {
                    jPDAThreadImplArray[0].notifySuspended();
                }
                return value;
            }
            catch (EvaluationException evaluationException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)evaluationException);
                invalidExpressionException.initCause((Throwable)evaluationException);
                throw invalidExpressionException;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
                IllegalStateException illegalStateException = new IllegalStateException(incompatibleThreadStateException.getLocalizedMessage());
                illegalStateException.initCause(incompatibleThreadStateException);
                throw illegalStateException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value invokeMethod(ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray) throws InvalidExpressionException {
        if (this.currentThread == null) {
            throw new InvalidExpressionException("No current context");
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.methodCallsUnsupportedExc != null) {
                throw this.methodCallsUnsupportedExc;
            }
            List list = this.disableAllBreakpoints();
            ThreadReference threadReference = this.getEvaluationThread();
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getThread(threadReference);
            boolean bl = jPDAThreadImpl.isSuspended();
            jPDAThreadImpl.notifyToBeRunning();
            try {
                Value value = Evaluator.invokeVirtual(objectReference, method, threadReference, Arrays.asList(valueArray));
                return value;
            }
            catch (InvalidExpressionException invalidExpressionException) {
                if (invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                    this.methodCallsUnsupportedExc = invalidExpressionException;
                }
                throw invalidExpressionException;
            }
            finally {
                if (bl) {
                    jPDAThreadImpl.notifySuspended();
                }
                this.enableAllBreakpoints(list);
            }
        }
    }

    public static String getGenericSignature(TypeComponent typeComponent) {
        if (tcGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)tcGenericSignatureMethod.invoke((Object)typeComponent, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public static String getGenericSignature(LocalVariable localVariable) {
        if (lvGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)lvGenericSignatureMethod.invoke((Object)localVariable, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setStarting() {
        this.setState(1);
    }

    public void setStartingThread(Thread thread) {
        this.startingThread = thread;
    }

    public void unsetStartingThread() {
        this.startingThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(VirtualMachine virtualMachine, Operator operator) {
        if (startVerbose) {
            System.out.println("\nS JPDADebuggerImpl.setRunning ()");
            JPDAUtils.printFeatures(virtualMachine);
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = true;
        }
        this.virtualMachine = virtualMachine;
        object = this.canBeModifiedLock;
        synchronized (object) {
            this.canBeModified = null;
        }
        this.initGenericsSupport();
        this.operator = operator;
        this.setState(2);
        object = this.LOCK;
        synchronized (object) {
            this.virtualMachine.resume();
        }
        if (startVerbose) {
            System.out.println("\nS JPDADebuggerImpl.setRunning () - end");
        }
        object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedState(ThreadReference threadReference) {
        Object object = this.LOCK;
        synchronized (object) {
            JPDAThread jPDAThread = this.getThread(threadReference);
            this.checkJSR45Languages(jPDAThread);
            this.setCurrentThread(jPDAThread);
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object;
        block19: {
            if (startVerbose) {
                System.out.println("\nS StartActionProvider.finish ()");
            }
            AbstractDICookie abstractDICookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
            if (this.getState() == 4) {
                return;
            }
            if (this.startingThread != null) {
                this.startingThread.interrupt();
            }
            this.startingThread = null;
            Operator operator = this.getOperator();
            if (operator != null) {
                operator.stop();
            }
            try {
                this.waitRunning();
            }
            catch (DebuggerStartException debuggerStartException) {
                // empty catch block
            }
            try {
                if (this.virtualMachine != null) {
                    if (abstractDICookie instanceof AttachingDICookie) {
                        if (startVerbose) {
                            System.out.println("\nS StartActionProvider.finish () VM dispose");
                        }
                        this.virtualMachine.dispose();
                    } else {
                        if (startVerbose) {
                            System.out.println("\nS StartActionProvider.finish () VM exit");
                        }
                        this.virtualMachine.exit(0);
                    }
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                if (!startVerbose) break block19;
                System.out.println("\nS StartActionProvider.finish () VM exception " + vMDisconnectedException);
            }
        }
        this.virtualMachine = null;
        this.setState(4);
        if (this.jsr45EngineProviders != null) {
            object = this.jsr45EngineProviders.iterator();
            while (object.hasNext()) {
                JSR45DebuggerEngineProvider jSR45DebuggerEngineProvider = (JSR45DebuggerEngineProvider)((Object)object.next());
                jSR45DebuggerEngineProvider.getDesctuctor().killEngine();
            }
            this.jsr45EngineProviders = null;
        }
        this.javaEngineProvider.getDestructor().killEngine();
        if (startVerbose) {
            System.out.println("\nS StartActionProvider.finish () end ");
        }
        object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.getState() == 3) {
                return;
            }
            if (this.virtualMachine != null) {
                this.virtualMachine.suspend();
            }
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.virtualMachine != null) {
                this.virtualMachine.resume();
            }
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDAThreadGroup[] getTopLevelThreadGroups() {
        JPDAThreadGroup[] jPDAThreadGroupArray = this.LOCK;
        synchronized (this.LOCK) {
            if (this.virtualMachine == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return new JPDAThreadGroup[0];
            }
            List<ThreadGroupReference> list = this.virtualMachine.topLevelThreadGroups();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            jPDAThreadGroupArray = new JPDAThreadGroup[list.size()];
            for (int i = 0; i < jPDAThreadGroupArray.length; ++i) {
                jPDAThreadGroupArray[i] = this.getThreadGroup(list.get(i));
            }
            return jPDAThreadGroupArray;
        }
    }

    public JPDAThread getThread(ThreadReference threadReference) {
        return (JPDAThread)this.threadsTranslation.translate(threadReference);
    }

    public JPDAThreadGroup getThreadGroup(ThreadGroupReference threadGroupReference) {
        return (JPDAThreadGroup)this.threadsTranslation.translate(threadGroupReference);
    }

    public Variable getLocalVariable(LocalVariable localVariable, Value value) {
        return (Variable)this.localsTranslation.translate(localVariable, value);
    }

    public Variable getVariable(Value value) {
        return this.getLocalsTreeModel().getVariable(value);
    }

    private void initGenericsSupport() {
        int n;
        Matcher matcher;
        tcGenericSignatureMethod = null;
        if (Bootstrap.virtualMachineManager().minorInterfaceVersion() >= 5 && (matcher = jvmVersionPattern.matcher(this.virtualMachine.version())).matches() && (n = Integer.parseInt(matcher.group(2))) >= 5) {
            try {
                tcGenericSignatureMethod = TypeComponent.class.getMethod("genericSignature", new Class[0]);
                lvGenericSignatureMethod = LocalVariable.class.getMethod("genericSignature", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void setState(int n) {
        if (n == this.state) {
            return;
        }
        int n2 = this.state;
        this.state = n;
        this.firePropertyChange("state", new Integer(n2), new Integer(n));
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(n != 4));
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public synchronized SourcePath getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        }
        return this.engineContext;
    }

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private ThreadReference getEvaluationThread() {
        if (this.currentThread != null) {
            return this.currentThread.getThreadReference();
        }
        if (this.virtualMachine == null) {
            return null;
        }
        List<ThreadReference> list = this.virtualMachine.allThreads();
        if (list.size() < 1) {
            return null;
        }
        int n = list.size();
        ThreadReference threadReference = null;
        for (int i = 0; i < n; ++i) {
            ThreadReference threadReference2 = list.get(i);
            if (!threadReference2.isSuspended()) continue;
            threadReference = threadReference2;
            if (!threadReference2.name().equals("Finalizer")) continue;
            return threadReference2;
        }
        return threadReference;
    }

    private void updateCurrentCallStackFrame(JPDAThread jPDAThread) {
        if (jPDAThread == null || jPDAThread.getStackDepth() < 1) {
            this.setCurrentCallStackFrame(null);
        } else {
            try {
                this.setCurrentCallStackFrame(jPDAThread.getCallStack(0, 1)[0]);
            }
            catch (AbsentInformationException absentInformationException) {
                this.setCurrentCallStackFrame(null);
            }
        }
    }

    private List disableAllBreakpoints() {
        ArrayList<EventRequest> arrayList = new ArrayList<EventRequest>();
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return arrayList;
        }
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        arrayList.addAll(eventRequestManager.accessWatchpointRequests());
        arrayList.addAll(eventRequestManager.breakpointRequests());
        arrayList.addAll(eventRequestManager.classPrepareRequests());
        arrayList.addAll(eventRequestManager.classUnloadRequests());
        arrayList.addAll(eventRequestManager.exceptionRequests());
        arrayList.addAll(eventRequestManager.methodEntryRequests());
        arrayList.addAll(eventRequestManager.methodExitRequests());
        arrayList.addAll(eventRequestManager.modificationWatchpointRequests());
        arrayList.addAll(eventRequestManager.threadDeathRequests());
        arrayList.addAll(eventRequestManager.threadStartRequests());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!((EventRequest)arrayList.get(i)).isEnabled()) {
                arrayList.remove(i);
                continue;
            }
            ((EventRequest)arrayList.get(i)).disable();
        }
        return arrayList;
    }

    private void enableAllBreakpoints(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                ((EventRequest)list.get(i)).enable();
                continue;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
                // empty catch block
            }
        }
    }

    private void checkJSR45Languages(JPDAThread jPDAThread) {
        if (jPDAThread.getStackDepth() > 0) {
            try {
                String string;
                CallStackFrame callStackFrame = jPDAThread.getCallStack(0, 1)[0];
                List list = callStackFrame.getAvailableStrata();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (this.languages.contains(list.get(i))) continue;
                    string = (String)list.get(i);
                    DebuggerManager.getDebuggerManager().startDebugging(this.createJSR45DI(string));
                    this.languages.add(string);
                }
                string = callStackFrame.getDefaultStratum();
                if (string != null && !string.equals(this.lastStratumn)) {
                    this.javaEngineProvider.getSession().setCurrentLanguage(string);
                }
                this.lastStratumn = string;
            }
            catch (AbsentInformationException absentInformationException) {
                System.out.println("NoInformationException");
            }
        }
    }

    private DebuggerInfo createJSR45DI(String string) {
        if (this.jsr45EngineProviders == null) {
            this.jsr45EngineProviders = new HashSet(1);
        }
        JSR45DebuggerEngineProvider jSR45DebuggerEngineProvider = new JSR45DebuggerEngineProvider(string);
        this.jsr45EngineProviders.add(jSR45DebuggerEngineProvider);
        return DebuggerInfo.create((String)("netbeans-jpda-JSR45DICookie-" + string), (Object[])new Object[]{new DelegatingSessionProvider(){

            public Session getSession(DebuggerInfo debuggerInfo) {
                return JPDADebuggerImpl.this.javaEngineProvider.getSession();
            }
        }, jSR45DebuggerEngineProvider});
    }

    public JPDAStep createJPDAStep(int n, int n2) {
        return new JPDAStepImpl(this, n, n2);
    }
}

