/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.StackFrame;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;

public class SourcePath {
    private ContextProvider lookupProvider;
    private SourcePathProvider contextProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    private SourcePathProvider getContext() {
        if (this.contextProvider == null) {
            List list = this.lookupProvider.lookup(null, SourcePathProvider.class);
            this.contextProvider = (SourcePathProvider)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                this.contextProvider = new CompoundContextProvider((SourcePathProvider)list.get(i), this.contextProvider);
            }
        }
        return this.contextProvider;
    }

    public String getRelativePath(String string, char c, boolean bl) {
        return this.getContext().getRelativePath(string, c, bl);
    }

    public String getURL(String string, boolean bl) {
        return this.getContext().getURL(string, bl);
    }

    public String getURL(StackFrame stackFrame, String string) {
        try {
            return this.getURL(SourcePath.convertSlash(stackFrame.location().sourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(stackFrame.location().declaringType().name()), true);
        }
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public void setSourceRoots(String[] stringArray) {
        this.getContext().setSourceRoots(stringArray);
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    public boolean sourceAvailable(String string) {
        return this.getURL(string, true) != null;
    }

    public boolean sourceAvailable(JPDAThread jPDAThread, String string) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(jPDAThread.getSourcePath(string)));
        }
        catch (AbsentInformationException absentInformationException) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()));
        }
    }

    public boolean sourceAvailable(Field field) {
        String string = field.getClassName();
        return this.sourceAvailable(string);
    }

    public boolean sourceAvailable(CallStackFrame callStackFrame, String string) {
        try {
            return this.sourceAvailable(SourcePath.convertSlash(callStackFrame.getSourcePath(string)));
        }
        catch (AbsentInformationException absentInformationException) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()));
        }
    }

    public String getURL(CallStackFrame callStackFrame, String string) {
        try {
            return this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true);
        }
        catch (AbsentInformationException absentInformationException) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true);
        }
    }

    public boolean showSource(JPDAThread jPDAThread, String string) {
        int n = jPDAThread.getLineNumber(string);
        if (n < 1) {
            n = 1;
        }
        try {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertSlash(jPDAThread.getSourcePath(string)), true), n, this.debugger);
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()), true), n, this.debugger);
        }
    }

    public boolean showSource(CallStackFrame callStackFrame, String string) {
        int n = callStackFrame.getLineNumber(string);
        if (n < 1) {
            n = 1;
        }
        try {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true), n, this.debugger);
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.showSource(this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true), n, this.debugger);
        }
    }

    public boolean showSource(Field field) {
        String string = field.getName();
        String string2 = field.getClassName();
        String string3 = this.getURL(EditorContextBridge.getRelativePath(string2), true);
        if (string3 == null) {
            return false;
        }
        int n = EditorContextBridge.getFieldLineNumber(string3, string2, string);
        if (n < 1) {
            n = 1;
        }
        return EditorContextBridge.showSource(string3, n, this.debugger);
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    public Object annotate(JPDAThread jPDAThread, String string) {
        int n = jPDAThread.getLineNumber(string);
        if (n < 1) {
            return null;
        }
        try {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertSlash(jPDAThread.getSourcePath(string)), true), n, EditorContext.CURRENT_LINE_ANNOTATION_TYPE, this.debugger);
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertClassNameToRelativePath(jPDAThread.getClassName()), true), n, EditorContext.CURRENT_LINE_ANNOTATION_TYPE, this.debugger);
        }
    }

    public Object annotate(CallStackFrame callStackFrame, String string) {
        int n = callStackFrame.getLineNumber(string);
        if (n < 1) {
            return null;
        }
        try {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertSlash(callStackFrame.getSourcePath(string)), true), n, EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE, this.debugger);
        }
        catch (AbsentInformationException absentInformationException) {
            return EditorContextBridge.annotate(this.getURL(SourcePath.convertClassNameToRelativePath(callStackFrame.getClassName()), true), n, EditorContext.CALL_STACK_FRAME_ANNOTATION_TYPE, this.debugger);
        }
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        CompoundAnnotation() {
        }
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider sourcePathProvider, SourcePathProvider sourcePathProvider2) {
            this.cp1 = sourcePathProvider;
            this.cp2 = sourcePathProvider2;
        }

        public String getURL(String string, boolean bl) {
            String string2 = this.cp1.getURL(string, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getURL(string, bl);
        }

        public String getRelativePath(String string, char c, boolean bl) {
            String string2 = this.cp1.getRelativePath(string, c, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getRelativePath(string, c, bl);
        }

        public String[] getSourceRoots() {
            String[] stringArray = this.cp1.getSourceRoots();
            String[] stringArray2 = this.cp2.getSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public String[] getOriginalSourceRoots() {
            String[] stringArray = this.cp1.getOriginalSourceRoots();
            String[] stringArray2 = this.cp2.getOriginalSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void setSourceRoots(String[] stringArray) {
            this.cp1.setSourceRoots(stringArray);
            this.cp2.setSourceRoots(stringArray);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

