/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

abstract class JPDADebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebuggerImpl debugger;
    private static RequestProcessor actionsRequestProcessor;
    private static Set providersToDisableOnLazyActions;
    private volatile boolean disabled;

    JPDADebuggerActionProvider(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        jPDADebuggerImpl.addPropertyChangeListener("state", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.debugger.getState() == 4) {
            Class clazz = JPDADebuggerActionProvider.class;
            synchronized (clazz) {
                if (actionsRequestProcessor != null) {
                    actionsRequestProcessor.stop();
                    actionsRequestProcessor = null;
                }
            }
        }
        this.checkEnabled(this.debugger.getState());
    }

    protected abstract void checkEnabled(int var1);

    public boolean isEnabled(Object object) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(object);
    }

    JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    void removeStepRequests(ThreadReference threadReference) {
        try {
            VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
            if (virtualMachine == null) {
                return;
            }
            EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
            ArrayList<StepRequest> arrayList = new ArrayList<StepRequest>(eventRequestManager.stepRequests());
            Iterator<StepRequest> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                StepRequest stepRequest = iterator.next();
                if (!stepRequest.thread().equals(threadReference)) continue;
                eventRequestManager.deleteEventRequest(stepRequest);
                break;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            illegalThreadStateException.printStackTrace();
        }
        catch (InvalidRequestStateException invalidRequestStateException) {
            invalidRequestStateException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProviderToDisableOnLazyAction(JPDADebuggerActionProvider jPDADebuggerActionProvider) {
        Class clazz = JPDADebuggerActionProvider.class;
        synchronized (clazz) {
            providersToDisableOnLazyActions.add(jPDADebuggerActionProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Runnable runnable) {
        HashSet hashSet;
        Object object = JPDADebuggerActionProvider.class;
        synchronized (object) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("JPDA Processor", 1);
            }
            hashSet = new HashSet(providersToDisableOnLazyActions);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            JPDADebuggerActionProvider jPDADebuggerActionProvider = (JPDADebuggerActionProvider)object.next();
            Set set = jPDADebuggerActionProvider.getActions();
            jPDADebuggerActionProvider.disabled = true;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                jPDADebuggerActionProvider.setEnabled(e, false);
            }
        }
        actionsRequestProcessor.post(new Runnable(){

            public void run() {
                try {
                    runnable.run();
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        JPDADebuggerActionProvider jPDADebuggerActionProvider = (JPDADebuggerActionProvider)iterator.next();
                        Set set = jPDADebuggerActionProvider.getActions();
                        jPDADebuggerActionProvider.disabled = false;
                        jPDADebuggerActionProvider.checkEnabled(JPDADebuggerActionProvider.this.debugger.getState());
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        providersToDisableOnLazyActions = new WeakSet();
    }
}

