/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;

public class SmartSteppingFilterImpl
implements SmartSteppingFilter {
    private HashSet filter = new HashSet();
    private ArrayList exact = new ArrayList();
    private ArrayList start = new ArrayList();
    private ArrayList end = new ArrayList();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public SmartSteppingFilterImpl() {
        this.addExclusionPatterns((Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
    }

    public void addExclusionPatterns(Set set) {
        HashSet hashSet = new HashSet(set);
        hashSet.removeAll(this.filter);
        if (hashSet.size() < 1) {
            return;
        }
        this.filter.addAll(hashSet);
        this.refreshFilters(hashSet);
        this.pcs.firePropertyChange("exclusionPatterns", null, hashSet);
    }

    public void removeExclusionPatterns(Set set) {
        this.filter.removeAll(set);
        this.exact = new ArrayList();
        this.start = new ArrayList();
        this.end = new ArrayList();
        this.refreshFilters(this.filter);
        this.pcs.firePropertyChange("exclusionPatterns", set, null);
    }

    public String[] getExclusionPatterns() {
        String[] stringArray = new String[this.filter.size()];
        return this.filter.toArray(stringArray);
    }

    public boolean stopHere(String string) {
        int n;
        int n2 = this.exact.size();
        for (n = 0; n < n2; ++n) {
            if (!this.exact.get(n).equals(string)) continue;
            return false;
        }
        n2 = this.start.size();
        for (n = 0; n < n2; ++n) {
            if (!string.startsWith((String)this.start.get(n))) continue;
            return false;
        }
        n2 = this.end.size();
        for (n = 0; n < n2; ++n) {
            if (!string.endsWith((String)this.end.get(n))) continue;
            return false;
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void refreshFilters(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("*")) {
                this.end.add(string.substring(1));
                continue;
            }
            if (string.endsWith("*")) {
                this.start.add(string.substring(0, string.length() - 1));
                continue;
            }
            this.exact.add(string);
        }
    }
}

