/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.StepRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private StepRequest stepRequest;
    private ContextProvider lookupProvider;
    private static boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private static boolean verbose = System.getProperty("netbeans.debugger.jdievents") != null;
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object object) {
        if (object == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (object == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = contextProvider;
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object object) {
        this.runAction(object);
    }

    public void postAction(final Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.runAction(object);
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object object) {
        Object object2 = this.getDebuggerImpl().LOCK;
        synchronized (object2) {
            try {
                ThreadReference threadReference = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
                this.removeStepRequests(threadReference);
                VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
                if (virtualMachine == null) {
                    return;
                }
                this.stepRequest = virtualMachine.eventRequestManager().createStepRequest(threadReference, -2, StepActionProvider.getJDIAction(object));
                this.stepRequest.addCountFilter(1);
                this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
                this.stepRequest.enable();
                if (verbose) {
                    System.out.println("JDI Request: " + this.stepRequest);
                }
                this.getDebuggerImpl().resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)vMDisconnectedException, NbBundle.getMessage((Class)StepActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    protected void checkEnabled(int n) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.getDebuggerImpl();
            this.setEnabled(e, n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event event) {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            LocatableEvent locatableEvent = (LocatableEvent)event;
            String string = locatableEvent.location().declaringType().name();
            ThreadReference threadReference = locatableEvent.thread();
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (jPDAThreadImpl != null && !jPDAThreadImpl.getThreadReference().equals(threadReference)) {
                return true;
            }
            try {
                if (jPDAThreadImpl.getThreadReference().frame(0).location().method().isSynthetic()) {
                    this.removeStepRequests(jPDAThreadImpl.getThreadReference());
                    int n = ((StepRequest)event.request()).depth();
                    this.stepRequest = this.getDebuggerImpl().getVirtualMachine().eventRequestManager().createStepRequest(jPDAThreadImpl.getThreadReference(), -2, n);
                    this.stepRequest.addCountFilter(1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
                    this.stepRequest.enable();
                    return true;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
            }
            boolean bl = this.getSmartSteppingFilterImpl().stopHere(string);
            if (ssverbose) {
                System.out.println("SS  SmartSteppingFilter.stopHere (" + string + ") ? " + bl);
            }
            if (bl) {
                JPDAThread jPDAThread = this.getDebuggerImpl().getThread(threadReference);
                if (this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, jPDAThread, this.getSmartSteppingFilterImpl())) {
                    this.getDebuggerImpl().setStoppedState(threadReference);
                    return false;
                }
            }
            if (ssverbose) {
                System.out.println("\nSS:  SMART STEPPING START! ********** ");
            }
            boolean bl2 = ((StepRequest)event.request()).depth() == 1;
            this.getStepIntoActionProvider().doAction(ActionsManager.ACTION_STEP_INTO);
            return true;
        }
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            List list = this.lookupProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepIntoActionProvider)) continue;
                this.stepIntoActionProvider = (StepIntoActionProvider)list.get(i);
            }
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

