/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider
implements Executor,
PropertyChangeListener {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    private static final boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private StepRequest stepRequest;
    private String position;
    private ContextProvider contextProvider;
    private boolean smartSteppingStepOut;
    private StepActionProvider stepActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.contextProvider = contextProvider;
        this.getSmartSteppingFilterImpl().addPropertyChangeListener(this);
        SourcePath sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        sourcePath.addPropertyChangeListener(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey(SS_STEP_OUT);
        }
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object object) {
        this.runAction();
    }

    public void postAction(Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepIntoActionProvider.this.runAction();
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction() {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            JPDAThread jPDAThread;
            if (ssverbose) {
                System.out.println("\nSS:  STEP INTO !!! *************");
            }
            if ((jPDAThread = this.getDebuggerImpl().getCurrentThread()) == null || !jPDAThread.isSuspended()) {
                return;
            }
            this.setStepRequest(1);
            this.position = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null);
            try {
                this.getDebuggerImpl().resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)vMDisconnectedException, NbBundle.getMessage((Class)StepIntoActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    protected void checkEnabled(int n) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            this.setEnabled(iterator.next(), n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "exclusionPatterns") {
            if (propertyChangeEvent.getOldValue() != null) {
                if (ssverbose) {
                    System.out.println("\nSS:  exclusion patterns removed");
                }
                ThreadReference threadReference = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
                this.removeStepRequests(threadReference);
            } else {
                if (ssverbose) {
                    if (this.stepRequest == null) {
                        System.out.println("SS:  exclusion patterns has been added");
                    } else {
                        System.out.println("\nSS:    add exclusion patterns:");
                    }
                }
                this.addPatternsToRequest(((Set)propertyChangeEvent.getNewValue()).toArray(new String[((Set)propertyChangeEvent.getNewValue()).size()]));
            }
        } else if (propertyChangeEvent.getPropertyName() == "sourceRoots") {
            JPDAThreadImpl jPDAThreadImpl;
            if (ssverbose) {
                System.out.println("\nSS:  source roots changed");
            }
            if ((jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()) != null) {
                ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                this.removeStepRequests(threadReference);
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event event) {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            String string;
            if (this.stepRequest != null) {
                this.stepRequest.disable();
            }
            LocatableEvent locatableEvent = (LocatableEvent)event;
            ThreadReference threadReference = locatableEvent.thread();
            try {
                if (threadReference.frame(0).location().method().isSynthetic()) {
                    this.setStepRequest(1);
                    return true;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                // empty catch block
            }
            JPDAThread jPDAThread = this.getDebuggerImpl().getThread(threadReference);
            boolean bl = this.getCompoundSmartSteppingListener().stopHere(this.contextProvider, jPDAThread, this.getSmartSteppingFilterImpl());
            if (bl && this.position.equals(string = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null))) {
                bl = false;
                this.setStepRequest(1);
                return true;
            }
            if (bl) {
                this.removeStepRequests(locatableEvent.thread());
                this.getDebuggerImpl().setStoppedState(threadReference);
            } else {
                if (ssverbose) {
                    System.out.println("SS:  => do next step!");
                }
                if (this.smartSteppingStepOut) {
                    this.setStepRequest(3);
                } else if (this.stepRequest != null) {
                    this.stepRequest.enable();
                } else {
                    this.setStepRequest(1);
                }
            }
            if (ssverbose && bl) {
                System.out.println("SS  FINISH IN CLASS " + jPDAThread.getClassName() + " ********\n");
            }
            return !bl;
        }
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List list = this.contextProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)list.get(i);
            }
        }
        return this.stepActionProvider;
    }

    void removeStepRequests(ThreadReference threadReference) {
        super.removeStepRequests(threadReference);
        this.stepRequest = null;
        if (ssverbose) {
            System.out.println("SS:    remove all patterns");
        }
    }

    private void setStepRequest(int n) {
        ThreadReference threadReference = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
        this.removeStepRequests(threadReference);
        this.stepRequest = this.getDebuggerImpl().getVirtualMachine().eventRequestManager().createStepRequest(threadReference, -2, n);
        this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
        this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
        if (ssverbose) {
            System.out.println("SS:    set patterns:");
        }
        this.addPatternsToRequest(this.getSmartSteppingFilterImpl().getExclusionPatterns());
        this.stepRequest.enable();
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.contextProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] stringArray) {
        if (this.stepRequest == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.stepRequest.addClassExclusionFilter(stringArray[i]);
            if (!ssverbose) continue;
            System.out.println("SS:      " + stringArray[i]);
        }
    }
}

