/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.util.Executor;

public abstract class BreakpointImpl
implements Executor,
PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private final Session session;
    private Expression compiledCondition;
    private List requests = new ArrayList();

    protected BreakpointImpl(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        this.debugger = jPDADebuggerImpl;
        this.reader = breakpointsReader;
        this.breakpoint = jPDABreakpoint;
        this.session = session;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled()) {
            this.setRequests();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("disposed".equals(propertyChangeEvent.getPropertyName())) {
            this.remove();
        } else {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            this.update();
        }
    }

    protected abstract void setRequests();

    protected final void remove() {
        this.removeAllEventRequests();
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            throw new VMDisconnectedException();
        }
        return virtualMachine.eventRequestManager();
    }

    protected synchronized void addEventRequest(EventRequest eventRequest) {
        if (verbose) {
            System.out.println("B   addEventRequest: " + eventRequest);
        }
        this.requests.add(eventRequest);
        this.getDebugger().getOperator().register(eventRequest, this);
        if (eventRequest instanceof ClassPrepareRequest) {
            eventRequest.setSuspendPolicy(1);
        } else if (this.getBreakpoint().getSuspend() == 2) {
            eventRequest.setSuspendPolicy(2);
        } else {
            eventRequest.setSuspendPolicy(1);
        }
        eventRequest.enable();
    }

    private synchronized void removeAllEventRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        if (this.getDebugger().getVirtualMachine() == null) {
            return;
        }
        int n = this.requests.size();
        try {
            for (int i = 0; i < n; ++i) {
                EventRequest eventRequest = (EventRequest)this.requests.get(i);
                if (verbose) {
                    System.out.println("B   removeEventRequest: " + eventRequest);
                }
                this.getDebugger().getVirtualMachine().eventRequestManager().deleteEventRequest(eventRequest);
                this.getDebugger().getOperator().unregister(eventRequest);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests = new LinkedList();
    }

    public boolean perform(String string, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        boolean bl;
        try {
            this.getDebugger().setAltCSF(threadReference.frame(0));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            incompatibleThreadStateException.printStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            JPDABreakpointEvent jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 0, this.debugger.getThread(threadReference), referenceType, this.debugger.getVariable(value));
            this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
            boolean bl2 = bl = this.getBreakpoint().getSuspend() == 0 || jPDABreakpointEvent.getResume();
            if (verbose) {
                System.out.println("B perform breakpoint (no condition): " + this + " resume: " + bl);
            }
        } else {
            bl = this.evaluateCondition(string, threadReference, referenceType, value);
            bl = this.getBreakpoint().getSuspend() == 0 || bl;
        }
        this.getDebugger().setAltCSF(null);
        if (!bl) {
            DebuggerManager.getDebuggerManager().setCurrentSession(this.session);
            this.getDebugger().setStoppedState(threadReference);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(String string, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        try {
            try {
                JPDABreakpointEvent jPDABreakpointEvent;
                boolean bl;
                Object object = this.debugger.LOCK;
                synchronized (object) {
                    StackFrame stackFrame = threadReference.frame(0);
                    bl = this.evaluateConditionIn(string, stackFrame);
                    jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, bl ? 1 : 2, this.debugger.getThread(threadReference), referenceType, this.debugger.getVariable(value));
                }
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                if (verbose) {
                    System.out.println("B perform breakpoint (condition = " + bl + "): " + this + " resume: " + (!bl || jPDABreakpointEvent.getResume()));
                }
                return !bl || jPDABreakpointEvent.getResume();
            }
            catch (ParseException parseException) {
                JPDABreakpointEvent jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)parseException, this.debugger.getThread(threadReference), referenceType, this.debugger.getVariable(value));
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                if (verbose) {
                    System.out.println("B perform breakpoint (bad condition): " + this + " resume: " + jPDABreakpointEvent.getResume());
                }
                return jPDABreakpointEvent.getResume();
            }
            catch (InvalidExpressionException invalidExpressionException) {
                JPDABreakpointEvent jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, (Throwable)invalidExpressionException, this.debugger.getThread(threadReference), referenceType, this.debugger.getVariable(value));
                this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
                return jPDABreakpointEvent.getResume();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            incompatibleThreadStateException.printStackTrace();
            return false;
        }
    }

    private boolean evaluateConditionIn(String string, StackFrame stackFrame) throws ParseException, InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(string)) {
            this.compiledCondition = Expression.parse(string, "1.5.0");
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, stackFrame);
        try {
            return ((BooleanValue)value).booleanValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidExpressionException((Throwable)classCastException);
        }
    }

    static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }
}

