/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.PersistenceManager;

public class BreakpointsReader
implements Properties.Reader {
    private Map cachedClassNames = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public String[] getSupportedClassNames() {
        return new String[]{JPDABreakpoint.class.getName()};
    }

    synchronized String findCachedClassName(JPDABreakpoint jPDABreakpoint) {
        return (String)this.cachedClassNames.get(jPDABreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeCachedClassName(JPDABreakpoint jPDABreakpoint, String string) {
        BreakpointsReader breakpointsReader = this;
        synchronized (breakpointsReader) {
            this.cachedClassNames.put(jPDABreakpoint, string);
        }
        PersistenceManager.storeBreakpoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String string, Properties properties) {
        LineBreakpoint lineBreakpoint;
        LineBreakpoint lineBreakpoint2 = null;
        if (string.equals(LineBreakpoint.class.getName()) || string.equals(LineBreakpoint.class.getName() + "$LineBreakpointImpl")) {
            lineBreakpoint = LineBreakpoint.create((String)properties.getString(LineBreakpoint.PROP_URL, null), (int)properties.getInt(LineBreakpoint.PROP_LINE_NUMBER, 1));
            lineBreakpoint.setCondition(properties.getString(LineBreakpoint.PROP_CONDITION, ""));
            BreakpointsReader breakpointsReader = this;
            synchronized (breakpointsReader) {
                this.cachedClassNames.put(lineBreakpoint, properties.getString("className", null));
            }
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(MethodBreakpoint.class.getName())) {
            lineBreakpoint = MethodBreakpoint.create();
            lineBreakpoint.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            lineBreakpoint.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            lineBreakpoint.setMethodName(properties.getString("methodName", ""));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            lineBreakpoint.setBreakpointType(properties.getInt("breakpointtType", 1));
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ClassLoadUnloadBreakpoint.class.getName())) {
            lineBreakpoint = ClassLoadUnloadBreakpoint.create((int)properties.getInt("breakpointType", 1));
            lineBreakpoint.setClassFilters((String[])properties.getArray("classFilters", (Object[])new String[0]));
            lineBreakpoint.setClassExclusionFilters((String[])properties.getArray("classExclusionFilters", (Object[])new String[0]));
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ExceptionBreakpoint.class.getName())) {
            lineBreakpoint = ExceptionBreakpoint.create((String)properties.getString("exceptionClassName", null), (int)properties.getInt("catchType", 3));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(FieldBreakpoint.class.getName())) {
            lineBreakpoint = FieldBreakpoint.create((String)properties.getString("className", null), (String)properties.getString("fieldName", null), (int)properties.getInt("breakpointType", 1));
            lineBreakpoint.setCondition(properties.getString("condition", ""));
            lineBreakpoint2 = lineBreakpoint;
        }
        if (string.equals(ThreadBreakpoint.class.getName())) {
            lineBreakpoint = ThreadBreakpoint.create();
            lineBreakpoint.setBreakpointType(properties.getInt("breakpointtType", 3));
            lineBreakpoint2 = lineBreakpoint;
        }
        if (!$assertionsDisabled && lineBreakpoint2 == null) {
            throw new AssertionError((Object)("Unknown breakpoint type: \"" + string + "\""));
        }
        lineBreakpoint2.setPrintText(properties.getString("printText", ""));
        lineBreakpoint2.setGroupName(properties.getString("groupName", ""));
        lineBreakpoint2.setSuspend(properties.getInt("suspend", 2));
        if (properties.getBoolean("enabled", true)) {
            lineBreakpoint2.enable();
        } else {
            lineBreakpoint2.disable();
        }
        return lineBreakpoint2;
    }

    public void write(Object object, Properties properties) {
        JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)object;
        properties.setString("printText", jPDABreakpoint.getPrintText());
        properties.setString("groupName", jPDABreakpoint.getGroupName());
        properties.setInt("suspend", jPDABreakpoint.getSuspend());
        properties.setBoolean("enabled", jPDABreakpoint.isEnabled());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            properties.setString(LineBreakpoint.PROP_URL, lineBreakpoint.getURL());
            properties.setInt(LineBreakpoint.PROP_LINE_NUMBER, lineBreakpoint.getLineNumber());
            properties.setString(LineBreakpoint.PROP_CONDITION, lineBreakpoint.getCondition());
            String string = this.findCachedClassName((JPDABreakpoint)lineBreakpoint);
            properties.setString("className", string);
            return;
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            properties.setArray("classFilters", (Object[])methodBreakpoint.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])methodBreakpoint.getClassExclusionFilters());
            properties.setString("methodName", methodBreakpoint.getMethodName());
            properties.setString("condition", methodBreakpoint.getCondition());
            properties.setInt("breakpointtType", methodBreakpoint.getBreakpointType());
            return;
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            properties.setArray("classFilters", (Object[])classLoadUnloadBreakpoint.getClassFilters());
            properties.setArray("classExclusionFilters", (Object[])classLoadUnloadBreakpoint.getClassExclusionFilters());
            properties.setInt("breakpointType", classLoadUnloadBreakpoint.getBreakpointType());
            return;
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            properties.setString("exceptionClassName", exceptionBreakpoint.getExceptionClassName());
            properties.setInt("catchType", exceptionBreakpoint.getCatchType());
            properties.setString("condition", exceptionBreakpoint.getCondition());
            return;
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            properties.setString("className", fieldBreakpoint.getClassName());
            properties.setString("fieldName", fieldBreakpoint.getFieldName());
            properties.setString("condition", fieldBreakpoint.getCondition());
            properties.setInt("breakpointType", fieldBreakpoint.getBreakpointType());
            return;
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            properties.setInt("breakpointtType", threadBreakpoint.getBreakpointType());
            return;
        }
    }

    static {
        $assertionsDisabled = !BreakpointsReader.class.desiredAssertionStatus();
    }
}

