/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.util.Iterator;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;

public abstract class ClassBasedBreakpoint
extends BreakpointImpl {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, null, jPDADebuggerImpl, session);
    }

    public ClassBasedBreakpoint(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super(jPDABreakpoint, breakpointsReader, jPDADebuggerImpl, session);
    }

    protected void setClassRequests(String[] stringArray, String[] stringArray2, int n) {
        try {
            EventRequest eventRequest;
            int n2;
            int n3;
            if ((n & 1) != 0) {
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest = this.getEventRequestManager().createClassPrepareRequest();
                    eventRequest.addClassFilter(stringArray[n2]);
                    if (verbose) {
                        System.out.println("B     set class load request: " + stringArray[n2]);
                    }
                    this.addEventRequest(eventRequest);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest = this.getEventRequestManager().createClassPrepareRequest();
                    eventRequest.addClassExclusionFilter(stringArray2[n2]);
                    if (verbose) {
                        System.out.println("B     set class load exclusion request: " + stringArray2[n2]);
                    }
                    this.addEventRequest(eventRequest);
                }
            }
            if ((n & 2) != 0) {
                n3 = stringArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest = this.getEventRequestManager().createClassUnloadRequest();
                    eventRequest.addClassFilter(stringArray[n2]);
                    if (verbose) {
                        System.out.println("B     set class unload request: " + stringArray[n2]);
                    }
                    this.addEventRequest(eventRequest);
                }
                n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    eventRequest = this.getEventRequestManager().createClassUnloadRequest();
                    eventRequest.addClassExclusionFilter(stringArray2[n2]);
                    if (verbose) {
                        System.out.println("B     set class unload exclusion request: " + stringArray2[n2]);
                    }
                    this.addEventRequest(eventRequest);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected boolean checkLoadedClasses(String string, boolean bl) {
        VirtualMachine virtualMachine;
        if (verbose) {
            System.out.println("B   check loaded classes: " + string + " : " + bl);
        }
        if ((virtualMachine = this.getVirtualMachine()) == null) {
            return false;
        }
        boolean bl2 = false;
        try {
            Iterator<ReferenceType> iterator = null;
            iterator = bl ? virtualMachine.allClasses().iterator() : virtualMachine.classesByName(string).iterator();
            while (iterator.hasNext()) {
                String string2;
                ReferenceType referenceType = iterator.next();
                if (iterator == null || !ClassBasedBreakpoint.match(string2 = referenceType.name(), string)) continue;
                if (verbose) {
                    System.out.println("B       cls loaded! " + referenceType);
                }
                this.classLoaded(referenceType);
                bl2 = true;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return bl2;
    }

    public boolean exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            this.classLoaded(((ClassPrepareEvent)event).referenceType());
        } else {
            this.classUnloaded(((ClassUnloadEvent)event).className());
        }
        return true;
    }

    protected void classLoaded(ReferenceType referenceType) {
    }

    protected void classUnloaded(String string) {
    }
}

