/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private LineBreakpoint breakpoint;
    private SourcePath sourcePath;
    private int lineNumber;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session, SourcePath sourcePath) {
        super((JPDABreakpoint)lineBreakpoint, breakpointsReader, jPDADebuggerImpl, session);
        this.reader = breakpointsReader;
        this.breakpoint = lineBreakpoint;
        this.sourcePath = sourcePath;
        this.lineNumber = lineBreakpoint.getLineNumber();
        this.set();
    }

    void fixed() {
        if (verbose) {
            System.out.println("B fix breakpoint impl: " + this);
        }
        this.lineNumber = this.breakpoint.getLineNumber();
        super.fixed();
    }

    protected void setRequests() {
        this.lineNumber = this.breakpoint.getLineNumber();
        String string = this.reader.findCachedClassName((JPDABreakpoint)this.breakpoint);
        if (string == null && (string = EditorContextBridge.getClassName(this.breakpoint.getURL(), this.lineNumber)) != null) {
            this.reader.storeCachedClassName((JPDABreakpoint)this.breakpoint, string);
        }
        if (string == null) {
            string = this.breakpoint.getURL();
            this.setClassRequests(new String[]{string}, new String[0], 1);
            this.checkLoadedClasses(string, true);
        } else {
            int n = string.indexOf(36);
            if (n > 0 && Character.isDigit(string.charAt(n + 1))) {
                string = string.substring(0, n);
            }
            this.setClassRequests(new String[]{string, string + ".*", string + "$*"}, new String[0], 1);
            this.checkLoadedClasses(string, false);
        }
    }

    protected void classLoaded(ReferenceType referenceType) {
        List list;
        if (verbose) {
            System.out.println("B class loaded: " + referenceType);
        }
        if ((list = LineBreakpointImpl.getLocations(referenceType, this.breakpoint.getStratum(), this.breakpoint.getSourceName(), this.breakpoint.getSourcePath(), this.lineNumber)).isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Location location = (Location)iterator.next();
            try {
                BreakpointRequest breakpointRequest = this.getEventRequestManager().createBreakpointRequest(location);
                this.addEventRequest(breakpointRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
    }

    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        return super.exec(event);
    }

    private static List getLocations(ReferenceType referenceType, String string, String string2, String string3, int n) {
        try {
            Object object;
            Object object2;
            List<Location> list = new ArrayList<Location>(referenceType.locationsOfLine(string, string2, n));
            if (verbose) {
                System.out.println("B   get location: referenceType=" + referenceType + " stratum=" + string + " source name=" + string2 + " lineNumber " + n + " (#" + list.size() + ")");
            }
            if (!list.isEmpty()) {
                if (string3 == null) {
                    return list;
                }
                string3 = string3.replace(File.separatorChar, '/');
                if (verbose) {
                    System.out.println("B   source path: " + string3);
                }
                object2 = new ArrayList();
                object = list.iterator();
                while (object.hasNext()) {
                    Location location = (Location)object.next();
                    String string4 = location.sourcePath().replace(File.separatorChar, '/');
                    if (!(string4 = LineBreakpointImpl.normalize(string4)).equals(string3)) continue;
                    ((ArrayList)object2).add(location);
                }
                if (verbose) {
                    System.out.println("B   relevant location(s) for path '" + string3 + "': " + object2);
                }
                if (!((ArrayList)object2).isEmpty()) {
                    return object2;
                }
            }
            object2 = referenceType.nestedTypes().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                list = object.locationsOfLine(string, string2, n);
                if (verbose) {
                    System.out.println("B   get location2: referenceType=" + referenceType + " stratum=" + string + " source name=" + string2 + " lineNumber" + n + ":= " + list.size());
                }
                if (list.isEmpty()) continue;
                return list;
            }
        }
        catch (AbsentInformationException absentInformationException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            ErrorManager.getDefault().notify(65536, (Throwable)classNotPreparedException);
        }
        catch (InternalException internalException) {
            ErrorManager.getDefault().annotate((Throwable)internalException, NbBundle.getMessage((Class)LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            ErrorManager.getDefault().notify((Throwable)internalException);
        }
        return new ArrayList();
    }

    private static String normalize(String string) {
        Pattern pattern = Pattern.compile("(/|\\A)\\./");
        Pattern pattern2 = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = pattern.matcher(string);
        }
        matcher = pattern2.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = pattern2.matcher(string);
        }
        return string;
    }
}

