/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;

public class MethodBreakpointImpl
extends ClassBasedBreakpoint {
    private static final boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;
    private MethodBreakpoint breakpoint;

    public MethodBreakpointImpl(MethodBreakpoint methodBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)methodBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = methodBreakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), 1);
        this.checkLoadedClasses(this.breakpoint.getClassFilters()[0], false);
    }

    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(this.breakpoint.getCondition(), ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        return super.exec(event);
    }

    protected void classLoaded(ReferenceType referenceType) {
        Object object;
        if (verbose) {
            System.out.println("B class loaded: " + referenceType);
        }
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Iterator<Method> iterator = referenceType.methods().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!MethodBreakpointImpl.match(object.name(), this.breakpoint.getMethodName()) && !this.breakpoint.getMethodName().equals("") || object.location() == null) continue;
            arrayList.add(object.location());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Location location = (Location)object.next();
            try {
                BreakpointRequest breakpointRequest = this.getEventRequestManager().createBreakpointRequest(location);
                this.addEventRequest(breakpointRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
    }
}

