/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.jpda.expr.Identifier;
import org.netbeans.modules.debugger.jpda.expr.JavaParserTreeConstants;
import org.netbeans.modules.debugger.jpda.expr.SimpleNode;
import org.openide.util.NbBundle;

public class EvaluationException
extends RuntimeException {
    private SimpleNode node;
    private String reason;
    private Object[] params;
    private String message;

    public EvaluationException(SimpleNode simpleNode, String string, Object[] objectArray) {
        this.node = simpleNode;
        this.reason = string;
        this.params = objectArray;
    }

    public String getMessage() {
        try {
            return this.getMessageImpl();
        }
        catch (Exception exception) {
            this.message = this.formatMessage("CTL_EvalError_unknownInternalError", null);
            return this.message;
        }
    }

    public String getMessageImpl() {
        if (this.message != null) {
            return this.message;
        }
        String[] stringArray = null;
        if (this.reason.equals("unknownNonterminal")) {
            stringArray = new String[]{JavaParserTreeConstants.jjtNodeName[this.node.jjtGetID()]};
        } else if (this.reason.equals("internalError")) {
            stringArray = new String[]{JavaParserTreeConstants.jjtNodeName[this.node.jjtGetID()]};
        } else if (this.reason.equals("invalidArrayInitializer")) {
            stringArray = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("arraySizeBadType")) {
            stringArray = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("arrayCreateError")) {
            stringArray = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("instantiateInterface")) {
            stringArray = new String[]{this.params[0] == null ? null : this.params[0].toString()};
        } else if (this.reason.equals("castToBooleanRequired")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("castFromBooleanRequired")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("castError")) {
            stringArray = new String[]{this.params[0].toString(), this.params[1].toString()};
        } else if (this.reason.equals("badOperandForPostfixOperator")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("postfixOperatorEvaluationError")) {
            stringArray = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("badOperandForPrefixOperator")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("prefixOperatorEvaluationError")) {
            stringArray = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("badOperandForUnaryOperator")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("unaryOperatorEvaluationError")) {
            stringArray = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("unknownType")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("internalErrorResolvingType")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("instanceOfLeftOperandNotAReference")) {
            stringArray = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("conditionalOrAndBooleanOperandRequired")) {
            stringArray = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("conditionalQuestionMarkBooleanOperandRequired")) {
            stringArray = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("thisObjectUnavailable")) {
            stringArray = null;
        } else if (this.reason.equals("objectReferenceRequiredOnDereference")) {
            stringArray = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("badArgument")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("argumentsBadSyntax")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("ambigousMethod")) {
            stringArray = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("noSuchMethod")) {
            stringArray = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("callException")) {
            stringArray = new String[]{((Identifier)this.params[1]).typeContext.name(), ((Identifier)this.params[1]).identifier, this.params[0].toString()};
        } else if (this.reason.equals("calleeException")) {
            stringArray = new String[]{((Identifier)this.params[1]).typeContext.name(), ((Identifier)this.params[1]).identifier, ((InvocationException)this.params[0]).exception().toString()};
        } else if (this.reason.equals("identifierNotAReference")) {
            stringArray = new String[]{((Value)this.params[0]).type().name()};
        } else if (this.reason.equals("notarray")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("arrayIndexNAN")) {
            stringArray = new String[]{this.params[1].toString()};
        } else if (this.reason.equals("arrayIndexOutOfBounds")) {
            stringArray = new String[]{this.params[1].toString(), Integer.toString(((ArrayReference)this.params[0]).length() - 1)};
        } else if (this.reason.equals("unknownVariable")) {
            stringArray = new String[]{((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("integerLiteralTooBig")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("badFormatOfIntegerLiteral")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("unknownLiteralType")) {
            stringArray = new String[]{this.params[0].toString()};
        } else if (this.reason.equals("evaluateError")) {
            stringArray = new String[]{this.params[1].toString(), this.params[0].toString(), this.params[2].toString()};
        } else if (this.reason.equals("notEnclosingType")) {
            stringArray = new String[]{((Identifier)this.params[0]).typeContext.name(), ((Identifier)this.params[0]).superQualifier};
        } else if (this.reason.equals("accessInstanceVariableFromStaticContext")) {
            stringArray = new String[]{((Identifier)this.params[0]).identifier};
        } else if (this.reason.equals("methodCallOnNull")) {
            stringArray = new String[]{this.params[0].toString()};
        } else {
            this.reason = "unknownInternalError";
            stringArray = null;
        }
        this.message = this.formatMessage("CTL_EvalError_" + this.reason, stringArray);
        return this.message;
    }

    private String formatMessage(String string, String[] stringArray) {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)EvaluationException.class);
        string = resourceBundle.getString(string);
        return MessageFormat.format(string, stringArray);
    }
}

