/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.expr.JavaParserTreeConstants;
import org.netbeans.modules.debugger.jpda.expr.JavaParserVisitor;
import org.netbeans.modules.debugger.jpda.expr.Node;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    private Map attributes;

    public SimpleNode(int n) {
        this.id = n;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(JavaParserVisitor javaParserVisitor, Object object) {
        return javaParserVisitor.visit(this, object);
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public Object[] getAttributes(String string) {
        if (this.attributes == null) {
            return null;
        }
        List list = this.getAttributeList(string);
        return list.toArray(new Object[list.size()]);
    }

    public void addAttribute(String string, Object object) {
        this.getAttributeList(string).add(object);
    }

    public void setAttribute(String string, Object object) {
        this.getAttributeMap().put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes == null ? null : this.attributes.get(string);
    }

    private Map getAttributeMap() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    private List getAttributeList(String string) {
        this.getAttributeMap();
        ArrayList arrayList = (ArrayList)this.attributes.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.attributes.put(string, arrayList);
        }
        return arrayList;
    }

    public int jjtGetID() {
        return this.id;
    }
}

