/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;

class AbstractVariable
implements ObjectVariable,
Customizer {
    private Value value;
    private JPDADebuggerImpl debugger;
    private String id;
    private String genericType;
    private org.netbeans.api.debugger.jpda.Field[] fields;
    private org.netbeans.api.debugger.jpda.Field[] staticFields;
    private org.netbeans.api.debugger.jpda.Field[] inheritedFields;
    private Set listeners = new HashSet();

    AbstractVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string) {
        this.debugger = jPDADebuggerImpl;
        this.value = value;
        this.id = string;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    AbstractVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string, String string2) {
        this.debugger = jPDADebuggerImpl;
        this.value = value;
        try {
            if (string != null) {
                this.genericType = AbstractVariable.getTypeDescription(new PushbackReader(new StringReader(string), 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.id = string2;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        Value value = this.getInnerValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof VoidValue) {
            return "void";
        }
        if (value instanceof CharValue) {
            return "'" + AbstractVariable.convertToCharInitializer(value.toString()) + "'";
        }
        if (value instanceof PrimitiveValue) {
            return value.toString();
        }
        if (value instanceof StringReference) {
            return "\"" + AbstractVariable.convertToStringInitializer(((StringReference)value).value()) + "\"";
        }
        if (value instanceof ClassObjectReference) {
            return "class " + ((ClassObjectReference)value).reflectedType().name();
        }
        if (value instanceof ArrayReference) {
            return "#" + ((ArrayReference)value).uniqueID() + "(length=" + ((ArrayReference)value).length() + ")";
        }
        return "#" + ((ObjectReference)value).uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string) throws InvalidExpressionException {
        Object[] objectArray;
        Value value = this.debugger.evaluateIn(string);
        this.setValue(value);
        this.setInnerValue(value);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", null, value);
        Set set = this.listeners;
        synchronized (set) {
            objectArray = this.listeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((PropertyChangeListener)objectArray[i]).propertyChange(propertyChangeEvent);
        }
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        throw new InternalError();
    }

    public void setObject(Object object) {
        try {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("" + object);
            }
            this.setValue((String)object);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invalidExpressionException.getLocalizedMessage());
            illegalArgumentException.initCause(invalidExpressionException);
            throw illegalArgumentException;
        }
    }

    public int getFieldsCount() {
        Value value = this.getInnerValue();
        if (value == null) {
            return 0;
        }
        if (value instanceof ArrayReference) {
            return ((ArrayReference)value).length();
        }
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields.length;
    }

    public org.netbeans.api.debugger.jpda.Field getField(String string) {
        if (this.getInnerValue() == null) {
            return null;
        }
        Field field = ((ReferenceType)this.getInnerValue().type()).fieldByName(string);
        if (field == null) {
            return null;
        }
        return this.getField(field, (ObjectReference)this.getInnerValue(), this.getID());
    }

    public org.netbeans.api.debugger.jpda.Field[] getFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (value instanceof ArrayReference && (n > 0 || n2 < ((ArrayReference)value).length())) {
            Type type = value.type();
            ReferenceType referenceType = (ReferenceType)type;
            if (n2 == 0) {
                n2 = ((ArrayReference)value).length();
            }
            org.netbeans.api.debugger.jpda.Field[] fieldArray = this.getFieldsOfArray((ArrayReference)value, ((ArrayType)referenceType).componentTypeName(), this.getID(), n, n2);
            return fieldArray;
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.fields.length, n2);
            n = Math.min(this.fields.length, n);
            org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n2 - n];
            System.arraycopy(this.fields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.fields;
    }

    public org.netbeans.api.debugger.jpda.Field[] getAllStaticFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null || value instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.staticFields.length, n2);
            n = Math.min(this.staticFields.length, n);
            org.netbeans.api.debugger.jpda.Field[] fieldArray = new FieldVariable[n2 - n];
            System.arraycopy(this.staticFields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.staticFields;
    }

    public org.netbeans.api.debugger.jpda.Field[] getInheritedFields(int n, int n2) {
        Value value = this.getInnerValue();
        if (value == null || value instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (n2 != 0) {
            n2 = Math.min(this.inheritedFields.length, n2);
            n = Math.min(this.inheritedFields.length, n);
            org.netbeans.api.debugger.jpda.Field[] fieldArray = new FieldVariable[n2 - n];
            System.arraycopy(this.inheritedFields, n, fieldArray, 0, n2 - n);
            return fieldArray;
        }
        return this.inheritedFields;
    }

    public Super getSuper() {
        if (this.getInnerValue() == null) {
            return null;
        }
        Type type = this.getInnerValue().type();
        if (!(type instanceof ClassType)) {
            return null;
        }
        ClassType classType = ((ClassType)type).superclass();
        if (classType == null) {
            return null;
        }
        return new SuperVariable(this.debugger, (ObjectReference)this.getInnerValue(), classType, this.id);
    }

    public String getToStringValue() throws InvalidExpressionException {
        try {
            Value value = this.getInnerValue();
            if (value == null) {
                return null;
            }
            if (!(value.type() instanceof ClassType)) {
                return this.getValue();
            }
            if (value instanceof CharValue) {
                return "'" + AbstractVariable.convertToCharInitializer(value.toString()) + "'";
            }
            if (value instanceof StringReference) {
                return "\"" + AbstractVariable.convertToStringInitializer(((StringReference)value).value()) + "\"";
            }
            Method method = ((ClassType)value.type()).concreteMethodByName("toString", "()Ljava/lang/String;");
            StringReference stringReference = (StringReference)this.debugger.invokeMethod((ObjectReference)value, method, new Value[0]);
            if (stringReference == null) {
                return null;
            }
            return stringReference.value();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public Variable invokeMethod(String string, String string2, Variable[] variableArray) throws NoSuchMethodException, InvalidExpressionException {
        try {
            int n;
            int n2;
            Object object;
            if (this.getInnerValue() == null) {
                return null;
            }
            Method method = null;
            if (string2 != null) {
                method = ((ClassType)this.getInnerValue().type()).concreteMethodByName(string, string2);
            } else {
                object = ((ClassType)this.getInnerValue().type()).methodsByName(string);
                n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    if (((Method)object.get(n)).isAbstract() || ((Method)object.get(n)).argumentTypeNames().size() != 0) continue;
                    method = (Method)object.get(n);
                    break;
                }
            }
            if (method == null) {
                object = ((ClassType)this.getInnerValue().type()).methodsByName(string);
                n2 = object.size();
                for (n = 0; n < n2; ++n) {
                    System.out.println(((Method)object.get(n)).signature());
                }
                throw new NoSuchMethodException(this.getInnerValue().type().name() + "." + string + " : " + string2);
            }
            object = new Value[variableArray.length];
            n2 = variableArray.length;
            for (n = 0; n < n2; ++n) {
                object[n] = ((AbstractVariable)variableArray[n]).getInnerValue();
            }
            Value value = this.debugger.invokeMethod((ObjectReference)this.getInnerValue(), method, (Value[])object);
            if (value instanceof ObjectReference) {
                return new AbstractVariable(this.debugger, (ObjectReference)value, this.id + method + "^");
            }
            return new AbstractVariable(this.debugger, value, this.id + method);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
    }

    public String getType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        if (this.getInnerValue() == null) {
            return "";
        }
        try {
            return this.getInnerValue().type().name();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public boolean equals(Object object) {
        return object instanceof AbstractVariable && this.id.equals(((AbstractVariable)object).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected Value getInnerValue() {
        return this.value;
    }

    protected void setInnerValue(Value value) {
        this.value = value;
        this.fields = null;
        this.staticFields = null;
        this.inheritedFields = null;
    }

    protected final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    String getID() {
        return this.id;
    }

    private static String getTypeDescription(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        switch (n) {
            case 90: {
                return "boolean";
            }
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 91: {
                int n2 = 1;
                while (true) {
                    if ((n = pushbackReader.read()) != 91) break;
                    ++n2;
                }
                pushbackReader.unread(n);
                return AbstractVariable.getTypeDescription(pushbackReader) + " " + AbstractVariable.brackets(n2);
            }
            case 76: {
                StringBuffer stringBuffer = new StringBuffer(50);
                while (true) {
                    if ((n = pushbackReader.read()) == 59) {
                        int n3 = stringBuffer.lastIndexOf("/");
                        return n3 == -1 ? stringBuffer.toString() : stringBuffer.substring(n3 + 1);
                    }
                    if (n == 60) {
                        int n4 = stringBuffer.lastIndexOf("/");
                        if (n4 != -1) {
                            stringBuffer.delete(0, n4 + 1);
                        }
                        stringBuffer.append("<");
                        while (true) {
                            String string = AbstractVariable.getTypeDescription(pushbackReader);
                            stringBuffer.append(string);
                            n = pushbackReader.read();
                            if (n == 62) break;
                            pushbackReader.unread(n);
                            stringBuffer.append(',');
                        }
                        pushbackReader.read();
                        stringBuffer.append(">");
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)n);
                }
            }
        }
        throw new IOException();
    }

    private static String brackets(int n) {
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        do {
            stringBuffer.append("[]");
        } while (--n > 0);
        return stringBuffer.toString();
    }

    private void initFields() {
        Value value = this.getInnerValue();
        Type type = value != null ? this.getInnerValue().type() : null;
        if (!(this.getInnerValue() instanceof ObjectReference) || !(type instanceof ReferenceType)) {
            this.fields = new org.netbeans.api.debugger.jpda.Field[0];
            this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
            this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
        } else {
            ObjectReference objectReference = (ObjectReference)this.getInnerValue();
            ReferenceType referenceType = (ReferenceType)type;
            if (objectReference instanceof ArrayReference) {
                this.fields = this.getFieldsOfArray((ArrayReference)objectReference, ((ArrayType)referenceType).componentTypeName(), this.getID(), 0, ((ArrayReference)objectReference).length());
                this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
                this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
            } else {
                this.initFieldsOfClass(objectReference, referenceType, this.getID());
            }
        }
    }

    private org.netbeans.api.debugger.jpda.Field[] getFieldsOfArray(ArrayReference arrayReference, String string, String string2, int n, int n2) {
        List<Value> list = arrayReference.getValues(n, n2 - n);
        int n3 = list.size();
        org.netbeans.api.debugger.jpda.Field[] fieldArray = new org.netbeans.api.debugger.jpda.Field[n3];
        for (int i = 0; i < n3; ++i) {
            Value value = list.get(i);
            fieldArray[i] = value instanceof ObjectReference ? new ObjectArrayFieldVariable(this.debugger, (ObjectReference)value, string, arrayReference, n + i, n2 - 1, string2) : new ArrayFieldVariable(this.debugger, value, string, arrayReference, n + i, n2 - 1, string2);
        }
        return fieldArray;
    }

    private void initFieldsOfClass(ObjectReference objectReference, ReferenceType referenceType, String string) {
        ArrayList<FieldVariable> arrayList = new ArrayList<FieldVariable>();
        ArrayList<FieldVariable> arrayList2 = new ArrayList<FieldVariable>();
        ArrayList<FieldVariable> arrayList3 = new ArrayList<FieldVariable>();
        List<Field> list = referenceType.allFields();
        HashSet<Field> hashSet = new HashSet<Field>(referenceType.fields());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Field field = list.get(i);
            FieldVariable fieldVariable = this.getField(field, objectReference, this.getID());
            if (field.isStatic()) {
                arrayList2.add(fieldVariable);
                continue;
            }
            if (hashSet.contains(field)) {
                arrayList.add(fieldVariable);
                continue;
            }
            arrayList3.add(fieldVariable);
        }
        this.fields = arrayList.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList.size()]);
        this.inheritedFields = arrayList3.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList3.size()]);
        this.staticFields = arrayList2.toArray(new org.netbeans.api.debugger.jpda.Field[arrayList2.size()]);
    }

    FieldVariable getField(Field field, ObjectReference objectReference, String string) {
        Value value = objectReference.getValue(field);
        if (value == null || value instanceof ObjectReference) {
            return new ObjectFieldVariable(this.debugger, (ObjectReference)value, field, string, JPDADebuggerImpl.getGenericSignature(field), objectReference);
        }
        return new FieldVariable(this.debugger, value, field, string, objectReference);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    public String toString() {
        return "ObjectVariable ";
    }

    private static String convertToStringInitializer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String convertToCharInitializer(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block9;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }
}

