/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;

class ArrayFieldVariable
extends AbstractVariable
implements Field {
    private final ArrayReference array;
    private int index;
    private int maxIndexLog;
    private String declaredType;
    private static final String ZEROS = "            ";

    ArrayFieldVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string, ArrayReference arrayReference, int n, int n2, String string2) {
        super(jPDADebuggerImpl, value, string2 + '.' + n + (value instanceof ObjectReference ? "^" : ""));
        this.index = n;
        this.maxIndexLog = ArrayFieldVariable.log10(n2);
        this.declaredType = string;
        this.array = arrayReference;
    }

    public String getName() {
        int n = this.maxIndexLog - ArrayFieldVariable.log10(this.index);
        if (n > 0) {
            return "[" + ArrayFieldVariable.zeros(n) + this.index + "]";
        }
        return "[" + this.index + "]";
    }

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getClassName() {
        return this.getType();
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            this.array.setValue(this.index, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    public String toString() {
        return "FieldVariable " + this.getName();
    }
}

