/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;

public class CallStackFrameImpl
implements CallStackFrame {
    private StackFrame sf;
    private int depth;
    private JPDADebuggerImpl debugger;
    private boolean valid;
    private Integer hashCode;

    public CallStackFrameImpl(StackFrame stackFrame, int n, JPDADebuggerImpl jPDADebuggerImpl) {
        this.sf = stackFrame;
        this.depth = n;
        this.debugger = jPDADebuggerImpl;
        this.valid = true;
    }

    public synchronized int getLineNumber(String string) {
        if (!this.valid) {
            return 0;
        }
        try {
            return this.getStackFrame().location().lineNumber(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return 0;
        }
    }

    public synchronized String getMethodName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().method().name();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getClassName() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().name();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getDefaultStratum() {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().declaringType().defaultStratum();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
    }

    public synchronized List getAvailableStrata() {
        if (!this.valid) {
            return Collections.EMPTY_LIST;
        }
        try {
            return this.getStackFrame().location().declaringType().availableStrata();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return Collections.EMPTY_LIST;
        }
    }

    public synchronized String getSourceName(String string) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourceName(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
    }

    public synchronized String getSourcePath(String string) throws AbsentInformationException {
        if (!this.valid) {
            return "";
        }
        try {
            return this.getStackFrame().location().sourcePath(string);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return "";
        }
    }

    public org.netbeans.api.debugger.jpda.LocalVariable[] getLocalVariables() throws AbsentInformationException {
        try {
            String string = this.getStackFrame().location().declaringType().name();
            List<LocalVariable> list = this.getStackFrame().visibleVariables();
            int n = list.size();
            org.netbeans.api.debugger.jpda.LocalVariable[] localVariableArray = new org.netbeans.api.debugger.jpda.LocalVariable[n];
            for (int i = 0; i < n; ++i) {
                LocalVariable localVariable = list.get(i);
                Value value = this.getStackFrame().getValue(localVariable);
                Local local = (Local)this.debugger.getLocalVariable(localVariable, value);
                local.setFrame(this);
                local.setInnerValue(value);
                local.setClassName(string);
                localVariableArray[i] = local;
            }
            return localVariableArray;
        }
        catch (NativeMethodException nativeMethodException) {
            throw new AbsentInformationException("native method");
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new AbsentInformationException("thread is running");
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new org.netbeans.api.debugger.jpda.LocalVariable[0];
        }
    }

    public synchronized This getThisVariable() {
        ObjectReference objectReference;
        if (!this.valid) {
            return null;
        }
        try {
            objectReference = this.getStackFrame().thisObject();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            this.valid = false;
            return null;
        }
        if (objectReference == null) {
            return null;
        }
        return new ThisVariable(this.debugger, objectReference, "");
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public synchronized boolean isObsolete() {
        return this.getStackFrame().location().method().isObsolete();
    }

    public boolean canPop() {
        if (!this.debugger.canPopFrames()) {
            return false;
        }
        ThreadReference threadReference = this.getStackFrame().thread();
        try {
            if (threadReference.frameCount() <= 1) {
                return false;
            }
            List<StackFrame> list = threadReference.frames(0, 2);
            if (list.get(0).location().method().isNative() || list.get(1).location().method().isNative()) {
                return false;
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            return false;
        }
        return true;
    }

    public void popFrame() {
        this.debugger.popFrames(this.sf.thread(), this.getStackFrame());
    }

    public JPDAThread getThread() {
        return this.debugger.getThread(this.sf.thread());
    }

    public StackFrame getStackFrame() {
        return this.sf;
    }

    public int getFrameDepth() {
        return this.depth;
    }

    public boolean equals(Object object) {
        try {
            return object instanceof CallStackFrameImpl && this.sf.equals(((CallStackFrameImpl)object).sf);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            return this.sf == ((CallStackFrameImpl)object).sf;
        }
    }

    public synchronized int hashCode() {
        if (this.hashCode == null) {
            try {
                this.hashCode = new Integer(this.sf.hashCode());
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                this.valid = false;
                this.hashCode = new Integer(super.hashCode());
            }
        }
        return this.hashCode;
    }
}

