/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;

class FieldVariable
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.Field {
    protected Field field;
    private ObjectReference objectReference;

    FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, Field field, String string, ObjectReference objectReference) {
        super(jPDADebuggerImpl, value, string + '.' + field.name() + (value instanceof ObjectReference ? "^" : ""));
        this.field = field;
        this.objectReference = objectReference;
    }

    FieldVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, Field field, String string, String string2) {
        super(jPDADebuggerImpl, value, string2, string + '.' + field.name() + (value instanceof ObjectReference ? "^" : ""));
        this.field = field;
    }

    public String getName() {
        return this.field.name();
    }

    public String getClassName() {
        return this.field.declaringType().name();
    }

    public String getDeclaredType() {
        return this.field.typeName();
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            this.objectReference.setValue(this.field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    public String toString() {
        return "FieldVariable " + this.field.name();
    }
}

