/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class JPDAObjectWatchImpl
extends AbstractVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, ObjectReference objectReference) {
        super(jPDADebuggerImpl, objectReference, "" + watch + (objectReference instanceof ObjectReference ? "^" : ""));
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, String string) {
        super(jPDADebuggerImpl, null, "" + watch);
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.exceptionDescription = string;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String string) {
        this.watch.setExpression(string);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        Mirror mirror;
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (callStackFrameImpl == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        try {
            mirror = callStackFrameImpl.getStackFrame().visibleVariableByName(this.getExpression());
            if (mirror != null) {
                try {
                    callStackFrameImpl.getStackFrame().setValue((LocalVariable)mirror, value);
                    return;
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new InvalidExpressionException((Throwable)invalidTypeException);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new InvalidExpressionException((Throwable)classNotLoadedException);
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        mirror = callStackFrameImpl.getStackFrame().thisObject();
        if (mirror == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        Field field = mirror.referenceType().fieldByName(this.getExpression());
        if (field == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        try {
            mirror.setValue(field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.exceptionDescription = null;
    }

    void setException(String string) {
        super.setInnerValue(null);
        this.exceptionDescription = string;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }
}

