/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;

public final class JPDAThreadImpl
implements JPDAThread {
    public static final String PROP_SUSPENDED = "suspended";
    private ThreadReference threadReference;
    private JPDADebuggerImpl debugger;
    private boolean suspended;
    private PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private Object lastBottomSF;

    public JPDAThreadImpl(ThreadReference threadReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.threadReference = threadReference;
        this.debugger = jPDADebuggerImpl;
        this.suspended = threadReference.isSuspended();
    }

    public String getName() {
        try {
            return this.threadReference.name();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return "";
        }
    }

    public JPDAThreadGroup getParentThreadGroup() {
        try {
            ThreadGroupReference threadGroupReference = this.threadReference.threadGroup();
            if (threadGroupReference == null) {
                return null;
            }
            return this.debugger.getThreadGroup(threadGroupReference);
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
    }

    public int getLineNumber(String string) {
        try {
            if (this.threadReference.frameCount() < 1) {
                return -1;
            }
            return this.threadReference.frame(0).location().lineNumber(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public int getState() {
        try {
            return this.threadReference.status();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return -1;
    }

    public boolean isSuspended() {
        try {
            return this.threadReference.isSuspended();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return false;
    }

    public String getClassName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().declaringType().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getMethodName() {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().method().name();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourceName(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourceName(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public String getSourcePath(String string) throws AbsentInformationException {
        try {
            if (this.threadReference.frameCount() < 1) {
                return "";
            }
            return this.threadReference.frame(0).location().sourcePath(string);
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return "";
    }

    public CallStackFrame[] getCallStack() throws AbsentInformationException {
        return this.getCallStack(0, this.getStackDepth());
    }

    public CallStackFrame[] getCallStack(int n, int n2) throws AbsentInformationException {
        try {
            int n3 = this.threadReference.frameCount();
            n = Math.min(n, n3);
            n2 = Math.min(n2, n3);
            List<StackFrame> list = this.threadReference.frames(n, n2 - n);
            int n4 = list.size();
            CallStackFrame[] callStackFrameArray = new CallStackFrame[n4];
            for (int i = 0; i < n4; ++i) {
                callStackFrameArray[i] = new CallStackFrameImpl(list.get(i), n + i, this.debugger);
            }
            return callStackFrameArray;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(incompatibleThreadStateException.getLocalizedMessage());
            absentInformationException.initCause(incompatibleThreadStateException);
            throw absentInformationException;
        }
        catch (ObjectCollectedException objectCollectedException) {
            AbsentInformationException absentInformationException = new AbsentInformationException(objectCollectedException.getLocalizedMessage());
            absentInformationException.initCause(objectCollectedException);
            throw absentInformationException;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new CallStackFrame[0];
        }
    }

    public int getStackDepth() {
        try {
            return this.threadReference.frameCount();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (!this.isSuspended()) {
                    this.threadReference.suspend();
                    bl = Boolean.TRUE;
                }
                this.suspended = true;
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            try {
                if (this.isSuspended()) {
                    for (int i = this.threadReference.suspendCount(); i > 0; --i) {
                        this.threadReference.resume();
                    }
                    bl = Boolean.FALSE;
                }
                this.suspended = false;
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyToBeRunning() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (this.suspended) {
                this.suspended = false;
                bl = Boolean.FALSE;
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySuspended() {
        Boolean bl = null;
        JPDAThreadImpl jPDAThreadImpl = this;
        synchronized (jPDAThreadImpl) {
            if (!this.suspended && this.isSuspended()) {
                this.suspended = true;
                bl = Boolean.TRUE;
            }
        }
        if (bl != null) {
            this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(bl == false ? 1 : 0), bl);
        }
    }

    public void interrupt() {
        try {
            if (this.isSuspended()) {
                return;
            }
            this.threadReference.interrupt();
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void makeCurrent() {
        this.debugger.setCurrentThread(this);
    }

    public ObjectVariable getContendedMonitor() {
        try {
            ObjectReference objectReference = this.threadReference.currentContendedMonitor();
            if (objectReference == null) {
                return null;
            }
            return new ThisVariable(this.debugger, objectReference, "");
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return null;
    }

    public ObjectVariable[] getOwnedMonitors() {
        try {
            List<ObjectReference> list = this.threadReference.ownedMonitors();
            int n = list.size();
            ObjectVariable[] objectVariableArray = new ObjectVariable[n];
            for (int i = 0; i < n; ++i) {
                objectVariableArray[i] = new ThisVariable(this.debugger, list.get(i), "");
            }
            return objectVariableArray;
        }
        catch (ObjectCollectedException objectCollectedException) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new ObjectVariable[0];
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pch.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireSuspended(boolean bl) {
        this.pch.firePropertyChange(PROP_SUSPENDED, (Object)(!bl ? 1 : 0), (Object)bl);
    }
}

