/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class JPDAWatchImpl
extends AbstractVariable
implements JPDAWatch {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;
    private Reference nodeRef;

    JPDAWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, Value value, Object object) {
        super(jPDADebuggerImpl, value, "" + watch + (value instanceof ObjectReference ? "^" : ""));
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.nodeRef = new WeakReference<Object>(object);
    }

    JPDAWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, Exception exception, Object object) {
        super(jPDADebuggerImpl, null, "" + watch);
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.exceptionDescription = exception.getLocalizedMessage();
        if (this.exceptionDescription == null) {
            this.exceptionDescription = exception.getMessage();
        }
        this.nodeRef = new WeakReference<Object>(object);
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String string) {
        this.watch.setExpression(string);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.exceptionDescription = null;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (callStackFrameImpl == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        LocalVariable localVariable = null;
        try {
            localVariable = callStackFrameImpl.getStackFrame().visibleVariableByName(this.getExpression());
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        if (localVariable == null) {
            throw new InvalidExpressionException("Can not set value to expression.");
        }
        try {
            callStackFrameImpl.getStackFrame().setValue(localVariable, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
    }

    void setException(String string) {
        this.setInnerValue(null);
        this.exceptionDescription = string;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }
}

