/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(108) >= 0;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = 100;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private Map cachedLocals = new WeakHashMap();
    private Map cachedArrayChildren = new WeakHashMap();

    public LocalsTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTableValueChangedChanged(propertyChangeEvent.getSource(), null);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray = this.getChildrenImpl(object, n, n2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Customizer)) continue;
            ((Customizer)objectArray[i]).addPropertyChangeListener(this);
        }
        return objectArray;
    }

    public Object[] getChildrenImpl(Object object, int n, int n2) throws UnknownTypeException {
        try {
            if (object.equals("Root")) {
                Object[] objectArray = this.getLocalVariables(n, n2);
                return objectArray;
            }
            if (object instanceof AbstractVariable) {
                AbstractVariable abstractVariable = (AbstractVariable)object;
                boolean bl = abstractVariable.getInnerValue() instanceof ArrayReference;
                if (bl) {
                    n2 = abstractVariable.getFieldsCount();
                }
                if (bl && n2 - n > 100) {
                    ArrayChildrenNode arrayChildrenNode = (ArrayChildrenNode)this.cachedArrayChildren.get(abstractVariable.getInnerValue());
                    if (arrayChildrenNode == null) {
                        arrayChildrenNode = new ArrayChildrenNode(abstractVariable);
                        this.cachedArrayChildren.put(abstractVariable.getInnerValue(), arrayChildrenNode);
                    } else {
                        arrayChildrenNode.update(abstractVariable);
                    }
                    return arrayChildrenNode.getChildren();
                }
                return abstractVariable.getFields(n, n2);
            }
            if (object instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)object).getChildren();
            }
            throw new UnknownTypeException(object);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new Object[0];
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChildrenCount(Object var1_1) throws UnknownTypeException {
        block15: {
            if (!var1_1.equals("Root")) ** GOTO lbl31
            var2_2 = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (var2_2 == null) {
                return 1;
            }
            var3_5 = var2_2.getStackFrame();
            if (var3_5 != null) break block15;
            return 1;
            {
                catch (VMDisconnectedException var2_4) {
                    return 0;
                }
            }
        }
        try {
            var4_6 = 0;
            try {
                var4_6 = var3_5.visibleVariables().size();
            }
            catch (AbsentInformationException var5_11) {
                ++var4_6;
            }
            if (var3_5.thisObject() != null) {
                ++var4_6;
            }
            return var4_6;
        }
        catch (NativeMethodException var4_7) {
            return 1;
            catch (InternalException var4_8) {
                return 1;
            }
            catch (InvalidStackFrameException var4_9) {
                return 1;
            }
            catch (VMDisconnectedException var4_10) {
                return 0;
            }
lbl31:
            // 1 sources

            if (var1_1 instanceof AbstractVariable) {
                var2_3 = (AbstractVariable)var1_1;
                if (var2_3.getInnerValue() instanceof ArrayReference) {
                    return Math.min(var2_3.getFieldsCount(), 100);
                }
                return var2_3.getFieldsCount();
            }
            if (var1_1 instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)var1_1).getChildren().length;
            }
            throw new UnknownTypeException(var1_1);
        }
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof AbstractVariable) {
            return !(((AbstractVariable)object).getInnerValue() instanceof ObjectReference);
        }
        if (object.toString().startsWith("SubArray")) {
            return false;
        }
        if (object.equals("NoInfo")) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTableValueChangedChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int n, int n2) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrameImpl == null) {
                return new String[]{"No current thread"};
            }
            StackFrame stackFrame = callStackFrameImpl.getStackFrame();
            if (stackFrame == null) {
                return new String[]{"No current thread"};
            }
            try {
                ObjectReference objectReference = stackFrame.thisObject();
                if (objectReference == null) {
                    Object var7_8 = null;
                    try {
                        return this.getLocalVariables(callStackFrameImpl, stackFrame, n, n2);
                    }
                    catch (AbsentInformationException absentInformationException) {
                        return new String[]{"NoInfo"};
                    }
                }
                Object[] objectArray = null;
                try {
                    objectArray = this.getLocalVariables(callStackFrameImpl, stackFrame, Math.max(n - 1, 0), Math.max(n2 - 1, 0));
                }
                catch (AbsentInformationException absentInformationException) {
                    objectArray = new Object[]{"NoInfo"};
                }
                Object[] objectArray2 = new Object[objectArray.length + 1];
                if (n < 1) {
                    objectArray2[0] = new ThisVariable(this.debugger, objectReference, "");
                }
                System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                return objectArray2;
            }
            catch (InternalException internalException) {
                return new String[]{internalException.getMessage()};
            }
        }
    }

    LocalVariable[] getLocalVariables(CallStackFrameImpl callStackFrameImpl, StackFrame stackFrame, int n, int n2) throws AbsentInformationException {
        LocalVariable[] localVariableArray = callStackFrameImpl.getLocalVariables();
        int n3 = localVariableArray.length;
        n2 = Math.min(n3, n2);
        if ((n = Math.min(n3, n)) != 0 || n2 != n3) {
            LocalVariable[] localVariableArray2 = new LocalVariable[n2 - n];
            for (int i = n; i < n2; ++i) {
                localVariableArray2[i - n] = localVariableArray[i];
            }
            localVariableArray = localVariableArray2;
        }
        return localVariableArray;
    }

    public Variable getVariable(Value value) {
        if (value instanceof ObjectReference) {
            return new AbstractVariable(this.debugger, (ObjectReference)value, null);
        }
        return new AbstractVariable(this.debugger, value, null);
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static final class ArrayChildrenNode {
        private AbstractVariable var;
        private int from = 0;
        private int length;
        private int maxIndexLog;

        public ArrayChildrenNode(AbstractVariable abstractVariable) {
            this(abstractVariable, 0, abstractVariable.getFieldsCount(), -1);
        }

        private ArrayChildrenNode(AbstractVariable abstractVariable, int n, int n2, int n3) {
            this.var = abstractVariable;
            this.from = n;
            this.length = n2;
            if (n3 < 0) {
                n3 = n + n2 - 1;
            }
            this.maxIndexLog = ArrayFieldVariable.log10(n3);
        }

        private static int pow(int n, int n2) {
            if (n2 == 0) {
                return 1;
            }
            int n3 = n;
            for (int i = 1; i < n2; ++i) {
                n3 *= n;
            }
            return n3;
        }

        public Object[] getChildren() {
            if (this.length > 100) {
                int n = (int)Math.ceil(Math.log(this.length) / Math.log(100.0) - 1.0);
                int n2 = ArrayChildrenNode.pow(100, n);
                int n3 = (int)Math.ceil((double)this.length / (double)n2);
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    int n4 = n2;
                    if (i == n3 - 1 && (n4 = this.length % n2) == 0) {
                        n4 = n2;
                    }
                    objectArray[i] = new ArrayChildrenNode(this.var, this.from + i * n2, n4, this.from + this.length - 1);
                }
                return objectArray;
            }
            return this.var.getFields(this.from, this.from + this.length);
        }

        public void update(AbstractVariable abstractVariable) {
            this.var = abstractVariable;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ArrayChildrenNode)) {
                return false;
            }
            ArrayChildrenNode arrayChildrenNode = (ArrayChildrenNode)object;
            return arrayChildrenNode.var.equals(this.var) && arrayChildrenNode.from == this.from && arrayChildrenNode.length == this.length;
        }

        public int hashCode() {
            return this.var.hashCode() + this.from + this.length;
        }

        public String toString() {
            int n = this.maxIndexLog - ArrayFieldVariable.log10(this.from);
            String string = n > 0 ? ArrayFieldVariable.zeros(2 * n) + this.from : Integer.toString(this.from);
            int n2 = this.from + this.length - 1;
            n = this.maxIndexLog - ArrayFieldVariable.log10(n2);
            String string2 = n > 0 ? ArrayFieldVariable.zeros(2 * n) + n2 : Integer.toString(n2);
            return "SubArray" + string + "-" + string2;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel localsTreeModel, JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            this.model = new WeakReference<LocalsTreeModel>(localsTreeModel);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel localsTreeModel = (LocalsTreeModel)this.model.get();
            if (localsTreeModel == null) {
                this.destroy();
            }
            return localsTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName() == "currentCallStackFrame" || propertyChangeEvent.getPropertyName() == "state") && this.debugger.getState() == 3) {
                LocalsTreeModel localsTreeModel = this.getModel();
                if (localsTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("LTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(this, localsTreeModel){
                    private final /* synthetic */ LocalsTreeModel val$ltm;
                    private final /* synthetic */ Listener this$0;
                    {
                        this.this$0 = listener;
                        this.val$ltm = localsTreeModel;
                    }

                    public void run() {
                        if (Listener.access$100(this.this$0).getState() != 3) {
                            if (LocalsTreeModel.access$000()) {
                                System.out.println("LTM cancel started task " + Listener.access$200(this.this$0));
                            }
                            return;
                        }
                        if (LocalsTreeModel.access$000()) {
                            System.out.println("LTM do task " + Listener.access$200(this.this$0));
                        }
                        this.val$ltm.fireTreeChanged();
                    }
                }, 500);
                if (verbose) {
                    System.out.println("LTM  create task " + this.task);
                }
            } else if (propertyChangeEvent.getPropertyName() == "state" && this.debugger.getState() != 3 && this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel task " + this.task);
                }
                this.task = null;
            }
        }

        static /* synthetic */ JPDADebugger access$100(Listener listener) {
            return listener.debugger;
        }

        static /* synthetic */ RequestProcessor.Task access$200(Listener listener) {
            return listener.task;
        }
    }
}

