/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadGroupImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;

public final class ObjectTranslation {
    private static final int THREAD_ID = 0;
    private static final int LOCALS_ID = 2;
    private JPDADebuggerImpl debugger;
    private int translationID;
    private WeakHashMap cache = new WeakHashMap();

    private ObjectTranslation(JPDADebuggerImpl jPDADebuggerImpl, int n) {
        this.debugger = jPDADebuggerImpl;
        this.translationID = n;
    }

    private Object createTranslation(Object object) {
        switch (this.translationID) {
            case 0: {
                if (object instanceof ThreadReference) {
                    return new JPDAThreadImpl((ThreadReference)object, this.debugger);
                }
                if (object instanceof ThreadGroupReference) {
                    return new JPDAThreadGroupImpl((ThreadGroupReference)object, this.debugger);
                }
                return null;
            }
        }
        throw new IllegalStateException("" + object);
    }

    private Object createTranslation(Object object, Object object2) {
        switch (this.translationID) {
            case 2: {
                if (!(object instanceof LocalVariable) || object2 != null && !(object2 instanceof Value)) break;
                LocalVariable localVariable = (LocalVariable)object;
                Local local = object2 instanceof ObjectReference ? new ObjectLocalVariable(this.debugger, (Value)object2, null, localVariable, JPDADebuggerImpl.getGenericSignature(localVariable), null) : new Local(this.debugger, (Value)object2, null, localVariable, null);
                return local;
            }
        }
        throw new IllegalStateException("" + object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object translate(Mirror mirror) {
        Object object = null;
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            WeakReference weakReference = (WeakReference)this.cache.get(mirror);
            if (weakReference != null) {
                object = weakReference.get();
            }
            if (object == null) {
                object = this.createTranslation(mirror);
                this.cache.put(mirror, new WeakReference<Object>(object));
            }
        }
        return object;
    }

    public Object translate(Mirror mirror, Object object) {
        Object object2 = null;
        WeakReference weakReference = (WeakReference)this.cache.get(mirror);
        if (weakReference != null) {
            object2 = weakReference.get();
        }
        if (object2 == null) {
            object2 = this.createTranslation(mirror, object);
            this.cache.put(mirror, new WeakReference<Object>(object2));
        }
        return object2;
    }

    public static ObjectTranslation createThreadTranslation(JPDADebuggerImpl jPDADebuggerImpl) {
        return new ObjectTranslation(jPDADebuggerImpl, 0);
    }

    public static ObjectTranslation createLocalsTranslation(JPDADebuggerImpl jPDADebuggerImpl) {
        return new ObjectTranslation(jPDADebuggerImpl, 2);
    }
}

