/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(116) >= 0;
    private JPDADebuggerImpl debugger;
    private Map childrenCache = new WeakHashMap();
    private Listener listener;
    private Collection listeners = new HashSet();

    public ThreadsTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray;
        Object[] objectArray2;
        Map map = this.childrenCache;
        synchronized (map) {
            objectArray2 = (Object[])this.childrenCache.get(object);
            objectArray = objectArray2 != null ? objectArray2.getChildren() : null;
        }
        if (objectArray == null) {
            objectArray = this.computeChildren(object);
            if (objectArray == null) {
                throw new UnknownTypeException(object);
            }
            map = this.childrenCache;
            synchronized (map) {
                objectArray2 = new ChildrenTree(object);
                objectArray2.setChildren(objectArray);
                this.childrenCache.put(object, objectArray2);
            }
        }
        int n3 = objectArray.length;
        n = Math.min(n3, n);
        n2 = Math.min(n3, n2);
        if (n == 0 && n2 == n3) {
            return objectArray;
        }
        objectArray2 = new Object[n2 - n];
        System.arraycopy(objectArray, n, objectArray2, 0, n2 - n);
        objectArray = objectArray2;
        return objectArray;
    }

    private Object[] computeChildren(Object object) {
        if (object.equals("Root")) {
            return this.debugger.getTopLevelThreadGroups();
        }
        if (object instanceof JPDAThreadGroup) {
            JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object;
            JPDAThreadGroup[] jPDAThreadGroupArray = jPDAThreadGroup.getThreadGroups();
            JPDAThread[] jPDAThreadArray = jPDAThreadGroup.getThreads();
            int n = jPDAThreadGroupArray.length + jPDAThreadArray.length;
            Object[] objectArray = new Object[n];
            System.arraycopy(jPDAThreadGroupArray, 0, objectArray, 0, jPDAThreadGroupArray.length);
            System.arraycopy(jPDAThreadArray, 0, objectArray, jPDAThreadGroupArray.length, jPDAThreadArray.length);
            return objectArray;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeChildren() {
        Map map = this.childrenCache;
        synchronized (map) {
            this.recomputeChildren(this.getRoot());
        }
    }

    private void recomputeChildren(Object object) {
        ChildrenTree childrenTree = (ChildrenTree)this.childrenCache.get(object);
        if (childrenTree != null) {
            Set set = this.childrenCache.keySet();
            Object[] objectArray = childrenTree.getChildren();
            Object[] objectArray2 = this.computeChildren(object);
            childrenTree.setChildren(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                if (!set.contains(objectArray2[i])) continue;
                this.recomputeChildren(objectArray2[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount(Object object) throws UnknownTypeException {
        Object[] objectArray;
        ChildrenTree childrenTree;
        Map map = this.childrenCache;
        synchronized (map) {
            childrenTree = (ChildrenTree)this.childrenCache.get(object);
            objectArray = childrenTree != null ? childrenTree.getChildren() : null;
        }
        if (objectArray == null) {
            objectArray = this.computeChildren(object);
            if (objectArray == null) {
                throw new UnknownTypeException(object);
            }
            map = this.childrenCache;
            synchronized (map) {
                childrenTree = new ChildrenTree(object);
                childrenTree.setChildren(objectArray);
                this.childrenCache.put(object, childrenTree);
            }
        }
        return objectArray.length;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object instanceof JPDAThread) {
            return true;
        }
        if (object instanceof JPDAThreadGroup) {
            return false;
        }
        if (object == "Root") {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] objectArray;
        this.recomputeChildren();
        Collection collection = this.listeners;
        synchronized (collection) {
            objectArray = this.listeners.toArray();
        }
        collection = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged((ModelEvent)collection);
        }
    }

    private static class ChildrenTree {
        private Object node;
        private Object[] ch;

        public ChildrenTree(Object object) {
            this.node = object;
        }

        public void setChildren(Object[] objectArray) {
            this.ch = objectArray;
        }

        public Object[] getChildren() {
            return this.ch;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(ThreadsTreeModel threadsTreeModel, JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            this.model = new WeakReference<ThreadsTreeModel>(threadsTreeModel);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
            if (jPDADebugger.getState() == 2) {
                this.task = this.createTask();
                this.task.schedule(500);
            }
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel threadsTreeModel = (ThreadsTreeModel)this.model.get();
            if (threadsTreeModel == null) {
                this.destroy();
            }
            return threadsTreeModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            Listener listener = this;
            synchronized (listener) {
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("TTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
            }
        }

        private RequestProcessor.Task createTask() {
            RequestProcessor.Task task = new RequestProcessor("Threads Refresh", 1).create((Runnable)new RefreshTree());
            if (verbose) {
                System.out.println("TTM  create task " + task);
            }
            return task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "state") {
                if (this.debugger.getState() == 3) {
                    ThreadsTreeModel threadsTreeModel = this.getModel();
                    if (threadsTreeModel == null) {
                        return;
                    }
                    Listener listener = this;
                    synchronized (listener) {
                        if (this.task == null) {
                            this.task = this.createTask();
                        }
                    }
                    this.task.schedule(500);
                    return;
                }
            }
            if (propertyChangeEvent.getPropertyName() != "state") return;
            if (this.debugger.getState() != 2) return;
            ThreadsTreeModel threadsTreeModel = this.getModel();
            if (threadsTreeModel == null) {
                return;
            }
            Listener listener = this;
            synchronized (listener) {
                if (this.task == null) {
                    this.task = this.createTask();
                }
            }
            this.task.schedule(2000);
        }

        private class RefreshTree
        implements Runnable {
            public void run() {
                ThreadsTreeModel threadsTreeModel = Listener.this.getModel();
                if (threadsTreeModel == null) {
                    return;
                }
                if (verbose) {
                    System.out.println("TTM do R task " + Listener.this.task);
                }
                threadsTreeModel.fireTreeChanged();
                int n = Listener.this.debugger.getState();
                Listener.this.debugger;
                if (n == 2) {
                    Listener.this.task.schedule(2000);
                }
            }
        }
    }
}

