/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JPDAUtils {
    public static void printFeatures(VirtualMachine virtualMachine) {
        System.out.println("canAddMethod " + virtualMachine.canAddMethod());
        System.out.println("canGetBytecodes " + virtualMachine.canGetBytecodes());
        System.out.println("canGetCurrentContendedMonitor " + virtualMachine.canGetCurrentContendedMonitor());
        System.out.println("canGetMonitorInfo " + virtualMachine.canGetMonitorInfo());
        System.out.println("canGetOwnedMonitorInfo " + virtualMachine.canGetOwnedMonitorInfo());
        System.out.println("canGetSourceDebugExtension " + virtualMachine.canGetSourceDebugExtension());
        System.out.println("canGetSyntheticAttribute " + virtualMachine.canGetSyntheticAttribute());
        System.out.println("canPopFrames " + virtualMachine.canPopFrames());
        System.out.println("canRedefineClasses " + virtualMachine.canRedefineClasses());
        System.out.println("canRequestVMDeathEvent " + virtualMachine.canRequestVMDeathEvent());
        System.out.println("canUnrestrictedlyRedefineClasses " + virtualMachine.canUnrestrictedlyRedefineClasses());
        System.out.println("canUseInstanceFilters " + virtualMachine.canUseInstanceFilters());
        System.out.println("canWatchFieldAccess " + virtualMachine.canWatchFieldAccess());
        System.out.println("canWatchFieldModification " + virtualMachine.canWatchFieldModification());
    }

    public static void showMethods(ReferenceType referenceType) {
        System.out.println("  ============================================");
        System.out.println("  Methods for " + referenceType.name());
        List<Method> list = referenceType.methods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            System.out.println(list.get(i).name() + " ; " + list.get(i).signature());
        }
        System.out.println("  ============================================");
    }

    public static void showLinesForClass(ReferenceType referenceType) {
        System.out.println("  ============================================");
        System.out.println("  Lines for " + referenceType.name());
        List<Location> list = null;
        try {
            list = referenceType.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            System.out.println("   " + list.get(i).lineNumber() + " : " + list.get(i).codeIndex());
        }
        System.out.println("  ============================================");
    }

    public static void showRequests(EventRequestManager eventRequestManager) {
        int n;
        System.out.println("  ============================================");
        List<EventRequest> list = eventRequestManager.breakpointRequests();
        System.out.println("  Break request: " + list.size());
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.classPrepareRequests();
        System.out.println("  Class prepare request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.accessWatchpointRequests();
        System.out.println("  Access watch request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.classUnloadRequests();
        System.out.println("  Class unload request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.exceptionRequests();
        System.out.println("  Exception request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.methodEntryRequests();
        System.out.println("  Method entry request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.methodExitRequests();
        System.out.println("  Method exit request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.modificationWatchpointRequests();
        System.out.println("  Modif watch request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.stepRequests();
        System.out.println("  Step request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.threadDeathRequests();
        System.out.println("  Thread death entry request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        list = eventRequestManager.threadStartRequests();
        System.out.println("  Thread start request: " + list.size());
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println("    " + list.get(n));
        }
        System.out.println("  ============================================");
    }

    public static void showConnectors(List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JPDAUtils.showConnector((Connector)list.get(i));
        }
    }

    public static void showConnector(Connector connector) {
        System.out.println("  ============================================");
        System.out.println("  Connector: " + connector);
        System.out.println("    name: " + connector.name());
        System.out.println("    description: " + connector.description());
        System.out.println("    transport: " + (connector.transport() != null ? connector.transport().name() : "null"));
        JPDAUtils.showProperties(connector.defaultArguments());
        System.out.println("  ============================================");
    }

    public static void showThread(ThreadReference threadReference) {
        System.out.println("  ============================================");
        try {
            System.out.println("  Thread: " + threadReference.name());
        }
        catch (Exception exception) {
            System.out.println("  Thread: " + exception);
        }
        try {
            System.out.println("    status: " + threadReference.status());
        }
        catch (Exception exception) {
            System.out.println("    status: " + exception);
        }
        try {
            System.out.println("    isSuspended: " + threadReference.isSuspended());
        }
        catch (Exception exception) {
            System.out.println("    isSuspended: " + exception);
        }
        try {
            System.out.println("    frameCount: " + threadReference.frameCount());
        }
        catch (Exception exception) {
            System.out.println("    frameCount: " + exception);
        }
        try {
            System.out.println("    location: " + threadReference.frame(0));
        }
        catch (Exception exception) {
            System.out.println("    location: " + exception);
        }
        System.out.println("  ============================================");
    }

    private static void showProperties(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Connector.Argument argument = (Connector.Argument)map.get(k);
            System.out.println("    property: " + k + " > " + argument.name());
            System.out.println("      desc: " + argument.description());
            System.out.println("      mustSpecify: " + argument.mustSpecify());
            System.out.println("      value: " + argument.value());
        }
    }

    public static void listGroup(String string, ThreadGroupReference threadGroupReference) {
        int n;
        List<ObjectReference> list = threadGroupReference.threadGroups();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println(string + "Thread Group: " + list.get(n) + " : " + ((ThreadGroupReference)list.get(n)).name());
            JPDAUtils.listGroup(string + "  ", (ThreadGroupReference)list.get(n));
        }
        list = threadGroupReference.threads();
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            System.out.println(string + "Thread: " + list.get(n) + " : " + ((ThreadReference)list.get(n)).name());
        }
    }

    private static void listGroups(List list) {
        System.out.println("  ============================================");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            System.out.println("Thread Group: " + list.get(i) + " : " + ((ThreadGroupReference)list.get(i)).name());
            JPDAUtils.listGroup("  ", (ThreadGroupReference)list.get(i));
        }
        System.out.println("  ============================================");
    }
}

